/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.ecs.strategy.ocr.impl.aliyun.rules;

import cn.hutool.core.collection.CollUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.ecs.model.invoice.EcsInvoiceInfoVO;
import com.bringspring.ecs.strategy.ocr.impl.aliyun.model.AirItinerary;
import com.bringspring.ecs.strategy.ocr.impl.aliyun.model.AirItineraryFlights;
import com.bringspring.ecs.strategy.ocr.impl.aliyun.rules.AliyunInvoiceOcrResultParse;
import com.bringspring.ecs.strategy.ocr.model.AliyunResult;
import com.bringspring.ecs.utils.ConvertNumberToUpper;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="aliyun_air_itinerary")
public class AirItineraryProcessor
implements AliyunInvoiceOcrResultParse {
    private static final Logger log = LoggerFactory.getLogger(AirItineraryProcessor.class);
    private static final String FIRST_CABIN_CLASS = "FA";
    private static final String BUSINESS_CABIN_CLASS = "CD";

    @Override
    public EcsInvoiceInfoVO parse(AliyunResult msg) {
        try {
            Map<String, Object> result = msg.getResult();
            String data = result.get("data").toString();
            AirItinerary invoice = (AirItinerary)JsonUtil.getJsonToBean((String)data, AirItinerary.class);
            EcsInvoiceInfoVO invoiceInfoVO = new EcsInvoiceInfoVO();
            invoiceInfoVO.setInvoiceNumber(invoice.getTicketNumber());
            invoiceInfoVO.setInvoiceCode("");
            invoiceInfoVO.setInvoiceDate(invoice.getIssueDate());
            invoiceInfoVO.setPurchaserName(invoice.getPassengerName());
            invoiceInfoVO.setPurchaserTaxCode(invoice.getIdCardNumber());
            List<AirItineraryFlights> flights = invoice.getFlights();
            String departureStation = "";
            String arrivalStation = "";
            String flightNumber = "";
            String flightDate = "";
            String cabinClass = "";
            if (CollUtil.isNotEmpty(flights)) {
                AirItineraryFlights flights1 = flights.get(0);
                departureStation = flights1.getDepartureStation();
                arrivalStation = flights1.getArrivalStation();
                flightNumber = flights1.getFlightNumber();
                flightDate = flights1.getFlightDate();
                cabinClass = flights1.getCabinClass();
            }
            invoiceInfoVO.setDepartureStation(departureStation);
            invoiceInfoVO.setArrivalStation(arrivalStation);
            invoiceInfoVO.setTrainNumber(flightNumber);
            if (FIRST_CABIN_CLASS.contains(cabinClass)) {
                invoiceInfoVO.setSeatType("\u5934\u7b49\u8231");
            } else if (BUSINESS_CABIN_CLASS.contains(cabinClass)) {
                invoiceInfoVO.setSeatType("\u5546\u52a1\u8231");
            } else {
                invoiceInfoVO.setSeatType("\u7ecf\u6d4e\u8231");
            }
            invoiceInfoVO.setPassengerName(invoice.getPassengerName());
            invoiceInfoVO.setTravelDate(flightDate);
            invoiceInfoVO.setInvoiceAmount(new BigDecimal(invoice.getFare()));
            invoiceInfoVO.setInvoiceAmountWords(ConvertNumberToUpper.digitUppercase(invoiceInfoVO.getInvoiceAmount().doubleValue()));
            invoiceInfoVO.setInvoiceSummary(invoice.getPassengerName() + " -- ");
            invoiceInfoVO.setInvoiceKind("\u7eb8\u8d28\u53d1\u7968");
            invoiceInfoVO.setInvoiceType("\u98de\u673a\u7968");
            invoiceInfoVO.setInvoiceCategory("\u4e13\u7528\u53d1\u7968");
            invoiceInfoVO.setInvoiceOp(msg.getOp());
            invoiceInfoVO.setInvoiceOpZh(msg.getType());
            invoiceInfoVO.setExtendedFields(JsonUtil.getObjectToString((Object)invoice));
            return invoiceInfoVO;
        }
        catch (Exception e) {
            log.error("Failed to process invoice: {}", (Object)msg, (Object)e);
            return null;
        }
    }
}

