/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.ecs.strategy.ocr.impl.aliyun.rules;

import com.bringspring.common.util.JsonUtil;
import com.bringspring.ecs.model.invoice.EcsInvoiceInfoVO;
import com.bringspring.ecs.strategy.ocr.impl.aliyun.model.NonTaxInvoice;
import com.bringspring.ecs.strategy.ocr.impl.aliyun.rules.AliyunInvoiceOcrResultParse;
import com.bringspring.ecs.strategy.ocr.model.AliyunResult;
import java.math.BigDecimal;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="aliyun_nontax_invoice")
public class NonTaxInvoiceProcessor
implements AliyunInvoiceOcrResultParse {
    private static final Logger log = LoggerFactory.getLogger(NonTaxInvoiceProcessor.class);

    @Override
    public EcsInvoiceInfoVO parse(AliyunResult msg) {
        try {
            Map<String, Object> result = msg.getResult();
            String data = result.get("data").toString();
            NonTaxInvoice nonTaxInvoice = (NonTaxInvoice)JsonUtil.getJsonToBean((String)data, NonTaxInvoice.class);
            EcsInvoiceInfoVO invoiceInfoVO = new EcsInvoiceInfoVO();
            invoiceInfoVO.setInvoiceCode(nonTaxInvoice.getInvoiceCode());
            invoiceInfoVO.setInvoiceNumber(nonTaxInvoice.getInvoiceNumber());
            invoiceInfoVO.setInvoiceDate(nonTaxInvoice.getInvoiceDate());
            invoiceInfoVO.setPurchaserName(nonTaxInvoice.getPayerName());
            invoiceInfoVO.setPurchaserTaxCode(nonTaxInvoice.getPayerCreditCode());
            invoiceInfoVO.setInvoiceAmount(new BigDecimal(nonTaxInvoice.getTotalAmount()));
            invoiceInfoVO.setInvoiceAmountWords(nonTaxInvoice.getTotalAmountInWords());
            invoiceInfoVO.setInvoiceSummary(nonTaxInvoice.getAdditionalInfo());
            invoiceInfoVO.setInvoiceKind("\u7eb8\u8d28\u53d1\u7968");
            invoiceInfoVO.setInvoiceType("\u975e\u7a0e\u6536\u5165\u53d1\u7968");
            invoiceInfoVO.setInvoiceCategory("\u4e13\u7528\u53d1\u7968");
            invoiceInfoVO.setInvoiceOp(msg.getOp());
            invoiceInfoVO.setInvoiceOpZh(msg.getType());
            invoiceInfoVO.setExtendedFields(JsonUtil.getObjectToString((Object)nonTaxInvoice));
            return invoiceInfoVO;
        }
        catch (Exception e) {
            log.error("Failed to process quota_invoice: {}", (Object)msg, (Object)e);
            return null;
        }
    }
}

