/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.ecs.strategy.ocr.impl.aliyun.rules;

import com.bringspring.common.util.JsonUtil;
import com.bringspring.ecs.model.invoice.EcsInvoiceInfoVO;
import com.bringspring.ecs.strategy.ocr.impl.aliyun.model.QuotaInvoice;
import com.bringspring.ecs.strategy.ocr.impl.aliyun.rules.AliyunInvoiceOcrResultParse;
import com.bringspring.ecs.strategy.ocr.model.AliyunResult;
import java.math.BigDecimal;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="aliyun_quota_invoice")
public class QuotaInvoiceProcessor
implements AliyunInvoiceOcrResultParse {
    private static final Logger log = LoggerFactory.getLogger(QuotaInvoiceProcessor.class);

    @Override
    public EcsInvoiceInfoVO parse(AliyunResult msg) {
        try {
            Map<String, Object> result = msg.getResult();
            String data = result.get("data").toString();
            QuotaInvoice quotaInvoice = (QuotaInvoice)JsonUtil.getJsonToBean((String)data, QuotaInvoice.class);
            EcsInvoiceInfoVO invoiceInfoVO = new EcsInvoiceInfoVO();
            invoiceInfoVO.setInvoiceCode(quotaInvoice.getInvoiceCode());
            invoiceInfoVO.setInvoiceNumber(quotaInvoice.getInvoiceNumber());
            invoiceInfoVO.setInvoiceAmount(new BigDecimal(quotaInvoice.getAmount()));
            invoiceInfoVO.setInvoiceAmount(invoiceInfoVO.getInvoiceAmount());
            invoiceInfoVO.setInvoiceAmountWords(quotaInvoice.getAmountInWords());
            invoiceInfoVO.setInvoiceSummary(quotaInvoice.getTitle());
            invoiceInfoVO.setInvoiceKind("\u7eb8\u8d28\u53d1\u7968");
            invoiceInfoVO.setInvoiceType("\u666e\u901a\u53d1\u7968");
            invoiceInfoVO.setInvoiceOp(msg.getOp());
            invoiceInfoVO.setInvoiceOpZh(msg.getType());
            invoiceInfoVO.setExtendedFields(JsonUtil.getObjectToString((Object)quotaInvoice));
            return invoiceInfoVO;
        }
        catch (Exception e) {
            log.error("Failed to process quota_invoice: {}", (Object)msg, (Object)e);
            return null;
        }
    }
}

