/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.ecs.strategy.ocr.impl.baidu.rules;

import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.ecs.model.invoice.EcsInvoiceInfoVO;
import com.bringspring.ecs.strategy.ocr.impl.baidu.enums.BaiduTypeEnum;
import com.bringspring.ecs.strategy.ocr.impl.baidu.model.PrintedInvoice;
import com.bringspring.ecs.strategy.ocr.impl.baidu.rules.BaiduInvoiceOcrResultParse;
import com.bringspring.ecs.strategy.ocr.model.BaiduResult;
import com.bringspring.ecs.utils.ConvertNumberToUpper;
import java.util.Date;
import org.springframework.stereotype.Component;

@Component(value="baidu_printed_invoice")
public class PrintedInvoiceProcessor
implements BaiduInvoiceOcrResultParse {
    @Override
    public EcsInvoiceInfoVO parse(BaiduResult baiduResult) {
        String op = baiduResult.getType();
        String opZh = BaiduTypeEnum.getNameByCode(op);
        String result = baiduResult.getResult();
        PrintedInvoice printedInvoice = (PrintedInvoice)JsonUtil.getJsonToBean((String)result, PrintedInvoice.class);
        EcsInvoiceInfoVO invoiceInfoVO = new EcsInvoiceInfoVO();
        invoiceInfoVO.setServiceTypeName(this.getWord(printedInvoice.getServiceType()));
        invoiceInfoVO.setInvoiceNumber(this.getWord(printedInvoice.getInvoiceNum()));
        invoiceInfoVO.setInvoiceCode(this.getWord(printedInvoice.getInvoiceCode()));
        String invoiceDate = DateUtil.formatDate((Date)DateUtil.parse((CharSequence)this.getWord(printedInvoice.getInvoiceDate())));
        invoiceInfoVO.setInvoiceDate(invoiceDate);
        invoiceInfoVO.setSellerName(this.getWord(printedInvoice.getSellerName()));
        invoiceInfoVO.setSellerTaxCode(this.getWord(printedInvoice.getSellerRegisterNum()));
        invoiceInfoVO.setPurchaserName(this.getWord(printedInvoice.getPurchaserName()));
        invoiceInfoVO.setPurchaserTaxCode(this.getWord(printedInvoice.getPurchaserRegisterNum()));
        String amount = this.getWord(printedInvoice.getAmountInFiguers());
        invoiceInfoVO.setInvoiceAmount(this.replaceAndToBigDecimal(amount));
        invoiceInfoVO.setInvoiceAmountPreTax(this.replaceAndToBigDecimal(amount));
        invoiceInfoVO.setInvoiceTax(this.replaceAndToBigDecimal(this.getWord(printedInvoice.getTotalTax())));
        invoiceInfoVO.setInvoiceAmountWords(ConvertNumberToUpper.digitUppercase(invoiceInfoVO.getInvoiceAmount().doubleValue()));
        invoiceInfoVO.setInvoiceSummary(invoiceInfoVO.getDepartureStation() + " \u81f3 " + invoiceInfoVO.getArrivalStation());
        invoiceInfoVO.setInvoiceKind("\u7eb8\u8d28\u53d1\u7968");
        invoiceInfoVO.setInvoiceCategory("\u4e13\u7528\u53d1\u7968");
        invoiceInfoVO.setInvoiceOp(op);
        invoiceInfoVO.setInvoiceOpZh(opZh);
        invoiceInfoVO.setInvoiceType("\u901a\u7528\u673a\u6253\u53d1\u7968");
        invoiceInfoVO.setExtendedFields(JsonUtil.getObjectToString((Object)printedInvoice));
        return invoiceInfoVO;
    }
}

