/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.ecs.strategy.ocr.impl.baidu.rules;

import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.ecs.model.invoice.EcsInvoiceInfoVO;
import com.bringspring.ecs.strategy.ocr.impl.baidu.enums.BaiduTypeEnum;
import com.bringspring.ecs.strategy.ocr.impl.baidu.model.RollNormalInvoice;
import com.bringspring.ecs.strategy.ocr.impl.baidu.rules.BaiduInvoiceOcrResultParse;
import com.bringspring.ecs.strategy.ocr.model.BaiduResult;
import com.bringspring.ecs.utils.ConvertNumberToUpper;
import java.util.Date;
import org.springframework.stereotype.Component;

@Component(value="baidu_roll_normal_invoice")
public class RollNormalInvoiceProcessor
implements BaiduInvoiceOcrResultParse {
    @Override
    public EcsInvoiceInfoVO parse(BaiduResult baiduResult) {
        String op = baiduResult.getType();
        String opZh = BaiduTypeEnum.getNameByCode(op);
        String result = baiduResult.getResult();
        RollNormalInvoice rollNormalInvoice = (RollNormalInvoice)JsonUtil.getJsonToBean((String)result, RollNormalInvoice.class);
        EcsInvoiceInfoVO invoiceInfoVO = new EcsInvoiceInfoVO();
        invoiceInfoVO.setInvoiceNumber(this.getWord(rollNormalInvoice.getInvoiceNum()));
        invoiceInfoVO.setInvoiceCode(this.getWord(rollNormalInvoice.getInvoiceCode()));
        String invoiceDate = DateUtil.formatDate((Date)DateUtil.parse((CharSequence)this.getWord(rollNormalInvoice.getInvoiceDate())));
        invoiceInfoVO.setInvoiceDate(invoiceDate);
        invoiceInfoVO.setSellerName(this.getWord(rollNormalInvoice.getSellerName()));
        invoiceInfoVO.setSellerTaxCode(this.getWord(rollNormalInvoice.getSellerRegisterNum()));
        invoiceInfoVO.setPurchaserName(this.getWord(rollNormalInvoice.getPurchaserName()));
        invoiceInfoVO.setPurchaserTaxCode(this.getWord(rollNormalInvoice.getPurchaserRegisterNum()));
        String amount = this.getWord(rollNormalInvoice.getAmountInFiguers());
        invoiceInfoVO.setInvoiceAmount(this.replaceAndToBigDecimal(amount));
        invoiceInfoVO.setInvoiceAmountPreTax(this.replaceAndToBigDecimal(amount));
        invoiceInfoVO.setInvoiceTax(this.replaceAndToBigDecimal(this.getWord(rollNormalInvoice.getTotalTax())));
        invoiceInfoVO.setInvoiceAmountWords(ConvertNumberToUpper.digitUppercase(invoiceInfoVO.getInvoiceAmount().doubleValue()));
        invoiceInfoVO.setInvoiceKind("\u7eb8\u8d28\u53d1\u7968");
        invoiceInfoVO.setInvoiceCategory("\u666e\u901a\u53d1\u7968");
        invoiceInfoVO.setInvoiceOp(op);
        invoiceInfoVO.setInvoiceOpZh(opZh);
        invoiceInfoVO.setInvoiceType("\u589e\u503c\u7a0e\u666e\u901a\u53d1\u7968(\u5377\u7968)");
        invoiceInfoVO.setExtendedFields(JsonUtil.getObjectToString((Object)rollNormalInvoice));
        return invoiceInfoVO;
    }
}

