/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.ecs.strategy.ocr.impl.baidu.rules;

import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.ecs.model.invoice.EcsInvoiceInfoVO;
import com.bringspring.ecs.strategy.ocr.impl.baidu.enums.BaiduTypeEnum;
import com.bringspring.ecs.strategy.ocr.impl.baidu.model.VatInvoice;
import com.bringspring.ecs.strategy.ocr.impl.baidu.rules.BaiduInvoiceOcrResultParse;
import com.bringspring.ecs.strategy.ocr.model.BaiduResult;
import com.bringspring.ecs.strategy.ocr.model.BaiduRowWord;
import com.bringspring.ecs.utils.ConvertNumberToUpper;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.springframework.stereotype.Component;

@Component(value="baidu_vat_invoice")
public class VatInvoiceProcessor
implements BaiduInvoiceOcrResultParse {
    @Override
    public EcsInvoiceInfoVO parse(BaiduResult baiduResult) {
        String op = baiduResult.getType();
        String opZh = BaiduTypeEnum.getNameByCode(op);
        String result = baiduResult.getResult();
        VatInvoice vatInvoice = (VatInvoice)JsonUtil.getJsonToBean((String)result, VatInvoice.class);
        EcsInvoiceInfoVO invoiceInfoVO = new EcsInvoiceInfoVO();
        invoiceInfoVO.setServiceTypeName(this.getWord(vatInvoice.getServiceType()));
        invoiceInfoVO.setInvoiceType(this.getWord(vatInvoice.getInvoiceType()));
        invoiceInfoVO.setInvoiceNumber(this.getWord(vatInvoice.getInvoiceNum()));
        invoiceInfoVO.setInvoiceCode(this.getWord(vatInvoice.getInvoiceCode()));
        String invoiceDate = DateUtil.formatDate((Date)DateUtil.parse((CharSequence)this.getWord(vatInvoice.getInvoiceDate())));
        invoiceInfoVO.setInvoiceDate(invoiceDate);
        invoiceInfoVO.setSellerName(this.getWord(vatInvoice.getSellerName()));
        invoiceInfoVO.setSellerTaxCode(this.getWord(vatInvoice.getSellerRegisterNum()));
        invoiceInfoVO.setPurchaserName(this.getWord(vatInvoice.getPurchaserName()));
        invoiceInfoVO.setPurchaserTaxCode(this.getWord(vatInvoice.getPurchaserRegisterNum()));
        invoiceInfoVO.setPurchaserBankAccountInfo(this.getWord(vatInvoice.getPurchaserBank()));
        invoiceInfoVO.setPurchaserContactInfo(this.getWord(vatInvoice.getPurchaserAddress()));
        invoiceInfoVO.setInvoiceAmount(new BigDecimal(this.getWord(vatInvoice.getAmountInFiguers())));
        invoiceInfoVO.setDeductibleTax(new BigDecimal("0"));
        invoiceInfoVO.setInvoiceAmountPreTax(new BigDecimal(this.getWord(vatInvoice.getTotalAmount())));
        invoiceInfoVO.setInvoiceTax(new BigDecimal(this.getWord(vatInvoice.getTotalTax())));
        invoiceInfoVO.setInvoiceAmountWords(ConvertNumberToUpper.digitUppercase(invoiceInfoVO.getInvoiceAmount().doubleValue()));
        invoiceInfoVO.setInvoiceSummary("");
        invoiceInfoVO.setCheckCode(this.getWord(vatInvoice.getCheckCode()));
        int size = vatInvoice.getCommodityName().size();
        ArrayList commodityList = new ArrayList();
        for (int i = 1; i <= size; ++i) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("CommodityName", this.getRowWordInfo(vatInvoice.getCommodityName(), i));
            map.put("CommodityType", this.getRowWordInfo(vatInvoice.getCommodityType(), i));
            map.put("CommodityUnit", this.getRowWordInfo(vatInvoice.getCommodityUnit(), i));
            map.put("CommodityNum", this.getRowWordInfo(vatInvoice.getCommodityNum(), i));
            map.put("CommodityPrice", this.getRowWordInfo(vatInvoice.getCommodityPrice(), i));
            map.put("CommodityAmount", this.getRowWordInfo(vatInvoice.getCommodityAmount(), i));
            map.put("CommodityTaxRate", this.getRowWordInfo(vatInvoice.getCommodityTaxRate(), i));
            map.put("CommodityTax", this.getRowWordInfo(vatInvoice.getCommodityTax(), i));
            commodityList.add(map);
        }
        invoiceInfoVO.setCommodityInfo(JsonUtil.getObjectToString(commodityList));
        String invoiceType = invoiceInfoVO.getInvoiceType();
        if (invoiceType.contains("\u4e13\u7528")) {
            invoiceInfoVO.setInvoiceCategory("\u4e13\u7528\u53d1\u7968");
        } else {
            invoiceInfoVO.setInvoiceCategory("\u666e\u901a\u53d1\u7968");
        }
        if (invoiceType.contains("\u7535\u5b50")) {
            invoiceInfoVO.setInvoiceKind("\u7535\u5b50\u53d1\u7968");
        } else {
            invoiceInfoVO.setInvoiceKind("\u7eb8\u8d28\u53d1\u7968");
        }
        invoiceInfoVO.setInvoiceOp(op);
        invoiceInfoVO.setInvoiceOpZh(opZh);
        invoiceInfoVO.setExtendedFields(JsonUtil.getObjectToString((Object)vatInvoice));
        return invoiceInfoVO;
    }

    private Object getRowWordInfo(List<BaiduRowWord> column, int index) {
        if (column == null || column.isEmpty()) {
            return null;
        }
        if (column.size() < index) {
            return null;
        }
        for (BaiduRowWord baiduRowWord : column) {
            if (index != baiduRowWord.getRow()) continue;
            return baiduRowWord.getWord();
        }
        return null;
    }
}

