/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.ecs.strategy.ocr.impl.textin.rules;

import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.ecs.enums.InvoiceCatergoryEnum;
import com.bringspring.ecs.enums.InvoiceKindEnum;
import com.bringspring.ecs.model.invoice.EcsInvoiceInfoVO;
import com.bringspring.ecs.strategy.ocr.impl.textin.enums.TextInServiceType;
import com.bringspring.ecs.strategy.ocr.impl.textin.model.response.TextInItem;
import com.bringspring.ecs.strategy.ocr.impl.textin.model.response.TextInObjectData;
import com.bringspring.ecs.strategy.ocr.impl.textin.rules.TextInInvoiceResultParse;
import com.bringspring.ecs.utils.ConvertNumberToUpper;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Component;

@Component(value="textin_flight_digital_ticket")
public class FlightDigitalTicket
implements TextInInvoiceResultParse {
    private static final String[] FIRST_CLASS = new String[]{"F", "A"};
    private static final String[] BUSINESS_CLASS = new String[]{"C", "D"};

    @Override
    public EcsInvoiceInfoVO parse(TextInObjectData result) throws DataException {
        List<TextInItem> itemList = result.getItemList();
        Map<String, String> itemMap = this.parseResultToMap(itemList);
        List<Map<String, String>> flightDataList = this.parseResultToList(result.getFlight_data_list());
        EcsInvoiceInfoVO invoice = new EcsInvoiceInfoVO();
        invoice.setServiceTypeCode(result.getKind());
        String nameByCode = TextInServiceType.getNameByCode(result.getKind());
        invoice.setServiceTypeName(nameByCode);
        invoice.setInvoiceOp(result.getType());
        invoice.setInvoiceOpZh("\u98de\u673a\u7968(\u7535\u5b50\u53d1\u7968)");
        invoice.setInvoiceType("\u98de\u673a\u7968(\u7535\u5b50\u53d1\u7968)");
        invoice.setCipher(null);
        invoice.setInvoiceNumber(itemMap.get("invoice_number"));
        invoice.setInvoiceCode(null);
        String date = itemMap.get("issued_date");
        String invoiceDate = DateUtil.formatDate((Date)DateUtil.parse((CharSequence)date));
        invoice.setInvoiceDate(invoiceDate);
        invoice.setSellerName(itemMap.get("issued_by"));
        invoice.setSellerTaxCode(null);
        invoice.setPurchaserName(itemMap.get("buyer"));
        invoice.setPurchaserTaxCode(itemMap.get("buyer_tax_id"));
        invoice.setPurchaserBankAccountInfo(null);
        invoice.setPurchaserContactInfo(null);
        invoice.setPassengerName(itemMap.get("passenger_name"));
        invoice.setPassengerIdNum(itemMap.get("id_no"));
        Map<String, String> stringStringMap = flightDataList.get(0);
        if (stringStringMap != null) {
            String vatInvoiceDate = stringStringMap.getOrDefault("date", "");
            String vatInvoiceTime = stringStringMap.getOrDefault("time", "");
            if (!vatInvoiceDate.isEmpty()) {
                String date1 = DateUtil.formatDate((Date)DateUtil.parse((CharSequence)vatInvoiceDate));
                date1 = !vatInvoiceTime.isEmpty() ? date1 + " " + vatInvoiceTime + ":00" : date1 + " 00:00:00";
                invoice.setTravelDate(date1);
            }
            invoice.setDepartureStation(stringStringMap.get("from"));
            invoice.setArrivalStation(stringStringMap.get("to"));
            invoice.setTrainNumber(stringStringMap.get("flight_number"));
            String s = stringStringMap.get("seat_class");
            invoice.setSeatType(stringStringMap.get("seat_class"));
            if (StringUtils.equalsAnyIgnoreCase((CharSequence)s, (CharSequence[])FIRST_CLASS)) {
                invoice.setSeatType("\u5934\u7b49\u8231");
            } else if (StringUtils.equalsAnyIgnoreCase((CharSequence)s, (CharSequence[])BUSINESS_CLASS)) {
                invoice.setSeatType("\u5546\u52a1\u8231");
            } else {
                invoice.setSeatType("\u7ecf\u6d4e\u8231");
            }
        }
        BigDecimal fare = this.replaceAndToBigDecimal(itemMap.get("fare"));
        BigDecimal fuelFare = this.replaceAndToBigDecimal(itemMap.get("fuel_surcharge"));
        BigDecimal civilAviationFund = this.replaceAndToBigDecimal(itemMap.get("civil_aviation_fund"));
        invoice.setInvoiceAmountPreTax(fare.add(fuelFare));
        invoice.setInvoiceTaxRate(itemMap.get("tax_rate"));
        invoice.setInvoiceTax(this.replaceAndToBigDecimal(itemMap.get("tax")));
        invoice.setInvoiceAmount(this.replaceAndToBigDecimal(itemMap.get("total")));
        invoice.setInvoiceAmountWords(ConvertNumberToUpper.digitUppercase(invoice.getInvoiceAmount().doubleValue()));
        invoice.setDeductibleTax(invoice.getInvoiceTax());
        String summary = invoice.getDepartureStation() + " - " + invoice.getArrivalStation();
        invoice.setInvoiceSummary(summary);
        invoice.setPayee(null);
        invoice.setReview(null);
        invoice.setDrawer(null);
        String invoiceType = itemMap.getOrDefault("invoice_type", "");
        invoice.setInvoiceKind(InvoiceKindEnum.E_INVOICE.getName());
        invoice.setInvoiceCategory(InvoiceCatergoryEnum.SPECIAL_INVOICE.getName());
        invoice.setExtendedFields(JsonUtil.getObjectToString((Object)result));
        invoice.setCheckCode(null);
        invoice.setInvoiceSum(invoice.getInvoiceAmount());
        invoice.setExistInvoiceSeal(true);
        return invoice;
    }
}

