/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.ecs.strategy.ocr.impl.textin.rules;

import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.ecs.model.invoice.EcsInvoiceInfoVO;
import com.bringspring.ecs.strategy.ocr.impl.textin.enums.TextInServiceType;
import com.bringspring.ecs.strategy.ocr.impl.textin.model.response.TextInItem;
import com.bringspring.ecs.strategy.ocr.impl.textin.model.response.TextInObjectData;
import com.bringspring.ecs.strategy.ocr.impl.textin.rules.TextInInvoiceResultParse;
import com.bringspring.ecs.utils.ConvertNumberToUpper;
import com.bringspring.ecs.utils.OcrDateUtil;
import com.bringspring.ecs.utils.OcrTimeUtil;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Component;

@Component(value="textin_passenger_transport_invoice")
public class PassengerTransportInvoice
implements TextInInvoiceResultParse {
    @Override
    public EcsInvoiceInfoVO parse(TextInObjectData result) throws DataException {
        List<TextInItem> itemList = result.getItemList();
        Map<String, String> itemMap = this.parseResultToMap(itemList);
        EcsInvoiceInfoVO invoice = new EcsInvoiceInfoVO();
        String kind = "traffic";
        invoice.setServiceTypeCode(kind);
        String nameByCode = TextInServiceType.getNameByCode(kind);
        invoice.setServiceTypeName(nameByCode);
        invoice.setInvoiceOp(result.getType());
        invoice.setInvoiceOpZh("\u65c5\u5ba2\u8fd0\u8f93\u53d1\u7968");
        invoice.setInvoiceType("\u65c5\u5ba2\u8fd0\u8f93\u53d1\u7968");
        invoice.setCipher(null);
        invoice.setInvoiceNumber(itemMap.get("invoice_number"));
        invoice.setInvoiceCode(itemMap.get("invoice_code"));
        String date = itemMap.get("date");
        String time = itemMap.get("time");
        String invoiceDate = "";
        if (StringUtils.isNotBlank((CharSequence)date)) {
            LocalDate localDate = OcrDateUtil.parseDate(date);
            invoiceDate = localDate.format(DateTimeFormatter.ofPattern("yyyy-MM-dd"));
            invoice.setInvoiceDate(invoiceDate);
        }
        invoice.setInvoiceAmount(this.replaceAndToBigDecimal(itemMap.get("money")));
        invoice.setInvoiceAmountWords(ConvertNumberToUpper.digitUppercase(invoice.getInvoiceAmount().doubleValue()));
        invoice.setInvoiceTaxRate("3%");
        BigDecimal taxRate = new BigDecimal(invoice.getInvoiceTaxRate().replace("%", "")).divide(new BigDecimal("100"), 2, RoundingMode.HALF_UP);
        BigDecimal preTaxAmount = invoice.getInvoiceAmount().divide(BigDecimal.ONE.add(taxRate), 2, RoundingMode.HALF_UP);
        invoice.setInvoiceAmountPreTax(preTaxAmount);
        invoice.setInvoiceTax(invoice.getInvoiceAmount().subtract(preTaxAmount));
        invoice.setDeductibleTax(invoice.getInvoiceTax());
        invoice.setDepartureStation(itemMap.get("departure"));
        invoice.setArrivalStation(itemMap.get("arrival"));
        invoice.setPassengerName(null);
        invoice.setPassengerIdNum(itemMap.get("passenger_id"));
        if (StringUtils.isNotBlank((CharSequence)invoiceDate)) {
            invoice.setTravelDate(invoiceDate);
            if (StringUtils.isNotBlank((CharSequence)time)) {
                String times = OcrTimeUtil.convertToStandardTime(time);
                invoiceDate = invoiceDate + " " + times;
                invoice.setTravelDate(invoiceDate);
            }
        }
        invoice.setCommodityInfo(null);
        invoice.setInvoiceSummary(this.concatNonNull(invoice.getDepartureStation(), "-", invoice.getArrivalStation()));
        invoice.setInvoiceKind("\u7eb8\u8d28\u53d1\u7968");
        invoice.setInvoiceCategory("\u4e13\u7528\u53d1\u7968");
        invoice.setExtendedFields(JsonUtil.getObjectToString((Object)result));
        String existInvoiceSeal = itemMap.get("exist_invoice_seal");
        invoice.setExistInvoiceSeal(false);
        if ("True".equals(existInvoiceSeal)) {
            invoice.setExistInvoiceSeal(true);
        }
        return invoice;
    }
}

