/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.ecs.strategy.ocr.impl.textin.rules;

import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.ecs.model.invoice.EcsInvoiceInfoVO;
import com.bringspring.ecs.strategy.ocr.impl.textin.enums.TextInServiceType;
import com.bringspring.ecs.strategy.ocr.impl.textin.model.response.TextInItem;
import com.bringspring.ecs.strategy.ocr.impl.textin.model.response.TextInObjectData;
import com.bringspring.ecs.strategy.ocr.impl.textin.rules.TextInInvoiceResultParse;
import com.bringspring.ecs.utils.ConvertNumberToUpper;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Component;

@Component(value="textin_quota_invoice")
public class QuotaInvoice
implements TextInInvoiceResultParse {
    @Override
    public EcsInvoiceInfoVO parse(TextInObjectData result) throws DataException {
        List<TextInItem> itemList = result.getItemList();
        Map<String, String> itemMap = this.parseResultToMap(itemList);
        EcsInvoiceInfoVO invoice = new EcsInvoiceInfoVO();
        invoice.setServiceTypeCode(result.getKind());
        String nameByCode = TextInServiceType.getNameByCode(result.getKind());
        invoice.setServiceTypeName(nameByCode);
        invoice.setInvoiceOp(result.getType());
        invoice.setInvoiceOpZh("\u901a\u7528\u5b9a\u989d\u53d1\u7968");
        invoice.setInvoiceType("\u901a\u7528\u5b9a\u989d\u53d1\u7968");
        invoice.setCipher(null);
        String title = itemMap.get("title");
        invoice.setInvoiceTitle(title);
        invoice.setInvoiceNumber(itemMap.get("quota_invoice_number"));
        invoice.setInvoiceCode(itemMap.get("quota_invoice_code"));
        invoice.setInvoiceAmount(this.replaceAndToBigDecimal(itemMap.get("amount_digits")));
        invoice.setInvoiceAmountWords(ConvertNumberToUpper.digitUppercase(invoice.getInvoiceAmount().doubleValue()));
        invoice.setInvoiceSummary(title);
        invoice.setPayee(null);
        invoice.setReview(null);
        invoice.setDrawer(null);
        invoice.setInvoiceKind("\u7eb8\u8d28\u53d1\u7968");
        invoice.setInvoiceCategory("\u5b9a\u989d\u53d1\u7968");
        invoice.setExtendedFields(JsonUtil.getObjectToString((Object)result));
        String existInvoiceSeal = itemMap.get("exist_invoice_seal");
        String existManufactureSupervisingSeal = itemMap.get("exist_manufacture_supervising_seal");
        invoice.setExistInvoiceSeal(false);
        if ("True".equals(existInvoiceSeal) || "True".equals(existManufactureSupervisingSeal)) {
            invoice.setExistInvoiceSeal(true);
        }
        return invoice;
    }
}

