/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.ecs.strategy.ocr.impl.textin.rules;

import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.ecs.model.invoice.EcsInvoiceInfoVO;
import com.bringspring.ecs.strategy.ocr.impl.textin.enums.TextInServiceType;
import com.bringspring.ecs.strategy.ocr.impl.textin.model.response.TextInItem;
import com.bringspring.ecs.strategy.ocr.impl.textin.model.response.TextInObjectData;
import com.bringspring.ecs.strategy.ocr.impl.textin.rules.TextInInvoiceResultParse;
import com.bringspring.ecs.utils.ConvertNumberToUpper;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Component;

@Component(value="textin_train_ticket")
public class TrainTicket
implements TextInInvoiceResultParse {
    @Override
    public EcsInvoiceInfoVO parse(TextInObjectData result) throws DataException {
        List<TextInItem> itemList = result.getItemList();
        Map<String, String> itemMap = this.parseResultToMap(itemList);
        EcsInvoiceInfoVO invoice = new EcsInvoiceInfoVO();
        invoice.setServiceTypeCode(result.getKind());
        String nameByCode = TextInServiceType.getNameByCode(result.getKind());
        invoice.setServiceTypeName(nameByCode);
        invoice.setInvoiceOp(result.getType());
        invoice.setInvoiceOpZh("\u706b\u8f66\u7968");
        invoice.setInvoiceType("\u706b\u8f66\u7968");
        invoice.setCipher(null);
        invoice.setInvoiceNumber(itemMap.get("ticket_number"));
        invoice.setInvoiceCode(itemMap.get("ticket_id"));
        String date = itemMap.get("departure_date");
        String invoiceDate = DateUtil.formatDate((Date)DateUtil.parse((CharSequence)date));
        invoice.setInvoiceDate(invoiceDate);
        invoice.setPassengerName(itemMap.get("passenger_name"));
        invoice.setPassengerIdNum(itemMap.get("passenger_id"));
        String vatInvoiceDate = itemMap.getOrDefault("departure_date", "");
        if (!vatInvoiceDate.isEmpty()) {
            invoice.setTravelDate(DateUtil.formatDateTime((Date)DateUtil.parse((CharSequence)vatInvoiceDate)));
        }
        invoice.setDepartureStation(itemMap.get("departure_station"));
        invoice.setArrivalStation(itemMap.get("arrival_station"));
        invoice.setTrainNumber(itemMap.get("train_number"));
        invoice.setSeatType(itemMap.get("class"));
        invoice.setInvoiceAmount(this.replaceAndToBigDecimal(itemMap.get("price")));
        if ("\u9000\u7968\u8d39".equals(itemMap.get("refund"))) {
            invoice.setRefund(invoice.getInvoiceAmount());
        }
        if ("\u6539\u7b7e\u8d39".equals(itemMap.get("rebook"))) {
            invoice.setRebook(invoice.getInvoiceAmount());
        }
        if (invoice.getRefund() != null && BigDecimal.ZERO.compareTo(invoice.getRefund()) != 0) {
            invoice.setBusinessType("\u9000\u7968");
        } else if (invoice.getRebook() != null && BigDecimal.ZERO.compareTo(invoice.getRebook()) != 0) {
            invoice.setBusinessType("\u6539\u7b7e");
        } else {
            invoice.setBusinessType("\u6b63\u5e38");
        }
        invoice.setInvoiceTaxRate("9%");
        if ("\u9000\u7968".equals(invoice.getBusinessType())) {
            invoice.setInvoiceTaxRate("6%");
        }
        BigDecimal taxRate = new BigDecimal(invoice.getInvoiceTaxRate().replace("%", "")).divide(new BigDecimal("100"), 2, RoundingMode.HALF_UP);
        BigDecimal preTaxAmount = invoice.getInvoiceAmount().divide(BigDecimal.ONE.add(taxRate), 2, RoundingMode.HALF_UP);
        invoice.setInvoiceAmountPreTax(preTaxAmount);
        invoice.setInvoiceTax(invoice.getInvoiceAmount().subtract(preTaxAmount));
        invoice.setDeductibleTax(invoice.getInvoiceTax());
        invoice.setInvoiceAmountWords(ConvertNumberToUpper.digitUppercase(invoice.getInvoiceAmount().doubleValue()));
        invoice.setInvoiceSummary(this.concatNonNull(invoice.getDepartureStation(), "-", invoice.getArrivalStation()));
        invoice.setPayee(null);
        invoice.setReview(null);
        invoice.setDrawer(null);
        invoice.setInvoiceKind("\u7eb8\u8d28\u53d1\u7968");
        invoice.setInvoiceCategory("\u4e13\u7528\u53d1\u7968");
        invoice.setExtendedFields(JsonUtil.getObjectToString((Object)result));
        invoice.setCheckCode(null);
        invoice.setInvoiceSum(null);
        invoice.setExistInvoiceSeal(true);
        return invoice;
    }
}

