/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.ecs.strategy.ocr.impl.textin.rules;

import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.ecs.model.invoice.EcsInvoiceInfoVO;
import com.bringspring.ecs.strategy.ocr.impl.textin.enums.TextInServiceType;
import com.bringspring.ecs.strategy.ocr.impl.textin.model.response.TextInItem;
import com.bringspring.ecs.strategy.ocr.impl.textin.model.response.TextInObjectData;
import com.bringspring.ecs.strategy.ocr.impl.textin.rules.TextInInvoiceResultParse;
import com.bringspring.ecs.strategy.ocr.model.ProductInfo;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Component;

@Component(value="textin_vat_digital_invoice")
public class VatDigitalInvoiceProcessor
implements TextInInvoiceResultParse {
    private final String[] SHOW_DEDUCTIBLE_TAX = new String[]{"\u7ecf\u8425\u79df\u8d41*\u901a\u884c\u8d39", "\u8fd0\u8f93\u670d\u52a1*\u5ba2\u8fd0\u670d\u52a1\u8d39", "\u8fd0\u8f93\u670d\u52a1*\u65c5\u5ba2\u8fd0\u8f93\u8d39", "\u8fd0\u8f93\u670d\u52a1*\u56fd\u5185\u673a\u7968"};

    @Override
    public EcsInvoiceInfoVO parse(TextInObjectData result) throws DataException {
        List<TextInItem> itemList = result.getItemList();
        Map<String, String> itemMap = this.parseResultToMap(itemList);
        List<Map<String, String>> productList = this.parseResultToList(result.getProduct_list());
        List<Map<String, String>> transportList = this.parseResultToList(result.getTransport_list());
        EcsInvoiceInfoVO invoice = new EcsInvoiceInfoVO();
        invoice.setServiceTypeCode(result.getKind());
        String nameByCode = TextInServiceType.getNameByCode(result.getKind());
        invoice.setServiceTypeName(nameByCode);
        invoice.setInvoiceOp(result.getType());
        invoice.setInvoiceType("\u6570\u7535\u53d1\u7968");
        invoice.setCipher(null);
        invoice.setInvoiceNumber(itemMap.get("vat_invoice_number"));
        invoice.setInvoiceCode(null);
        String date = itemMap.get("vat_invoice_issue_date");
        date = StringUtils.replaceEach((String)date, (String[])new String[]{" "}, (String[])new String[]{""});
        String invoiceDate = DateUtil.formatDate((Date)DateUtil.parse((CharSequence)date));
        invoice.setInvoiceDate(invoiceDate);
        invoice.setSellerName(itemMap.get("vat_invoice_seller_name"));
        invoice.setSellerTaxCode(itemMap.get("vat_invoice_seller_id"));
        invoice.setPurchaserName(itemMap.get("vat_invoice_payer_name"));
        invoice.setPurchaserTaxCode(itemMap.get("vat_invoice_rate_payer_id"));
        invoice.setPurchaserBankAccountInfo(null);
        invoice.setPurchaserContactInfo(null);
        String vatInvoiceServiceType = itemMap.getOrDefault("vat_invoice_service_type", "");
        if ("\u65c5\u5ba2\u8fd0\u8f93\u670d\u52a1".contains(vatInvoiceServiceType) && !transportList.isEmpty()) {
            invoice.setJourneyNum(transportList.size());
            Map<String, String> stringStringMap = transportList.get(0);
            String passengerName = stringStringMap.get("vat_invoice_passenger");
            if ("-".equals(passengerName)) {
                passengerName = "";
            }
            invoice.setPassengerName(passengerName);
            String passengerIdNum = stringStringMap.get("vat_invoice_user_id");
            if ("-".equals(passengerIdNum)) {
                passengerIdNum = "";
            }
            invoice.setPassengerIdNum(passengerIdNum);
            Object vatInvoiceDate = stringStringMap.getOrDefault("vat_invoice_date", "");
            if (!((String)vatInvoiceDate).isEmpty()) {
                vatInvoiceDate = StringUtils.replaceEach((String)vatInvoiceDate, (String[])new String[]{" "}, (String[])new String[]{""});
                invoice.setTravelDate(DateUtil.formatDateTime((Date)DateUtil.parse((CharSequence)vatInvoiceDate)));
            }
            invoice.setDepartureStation(stringStringMap.get("vat_invoice_from"));
            invoice.setArrivalStation(stringStringMap.get("vat_invoice_to"));
            invoice.setTrainNumber(stringStringMap.get("vat_invoice_transport_type"));
            invoice.setSeatType(stringStringMap.get("vat_invoice_seat"));
        }
        invoice.setInvoiceAmountPreTax(this.replaceAndToBigDecimal(itemMap.get("vat_invoice_total")));
        invoice.setInvoiceTax(this.replaceAndToBigDecimal(itemMap.get("vat_invoice_tax_total")));
        invoice.setInvoiceAmount(this.replaceAndToBigDecimal(itemMap.get("vat_invoice_total_cover_tax_digits")));
        invoice.setInvoiceAmountWords(itemMap.get("vat_invoice_total_cover_tax"));
        String summary = "";
        ArrayList<ProductInfo> productInfos = new ArrayList<ProductInfo>();
        String taxRate = "";
        for (Map map : productList) {
            ProductInfo productInfo = new ProductInfo();
            productInfo.setProductName((String)map.get("vat_invoice_product_name"));
            productInfo.setProductType((String)map.get("vat_invoice_specification"));
            productInfo.setProductUnit((String)map.get("vat_invoice_unit"));
            productInfo.setProductNum((String)map.get("vat_invoice_quantity"));
            productInfo.setProductPrice((String)map.get("vat_invoice_unit_price"));
            productInfo.setProductAmount((String)map.get("vat_invoice_price"));
            productInfo.setProductTaxRate((String)map.get("vat_invoice_tax_rate"));
            productInfo.setProductTax((String)map.get("vat_invoice_tax"));
            if (!summary.contains(productInfo.getProductName())) {
                summary = summary + productInfo.getProductName() + ";";
            }
            if (StringUtils.isBlank((CharSequence)taxRate)) {
                taxRate = productInfo.getProductTaxRate();
            }
            productInfos.add(productInfo);
        }
        if ("\u4e0d\u5f81\u7a0e".equals(taxRate)) {
            taxRate = "0%";
        }
        invoice.setInvoiceTaxRate(taxRate);
        invoice.setCommodityInfo(JsonUtil.getObjectToString(productInfos));
        invoice.setInvoiceSummary(summary);
        invoice.setPayee(null);
        invoice.setReview(null);
        invoice.setDrawer(itemMap.get("vat_invoice_drawer"));
        String invoiceType = itemMap.getOrDefault("invoice_type", "");
        String string = invoiceType.contains("\u4e13\u7528") ? "\u4e13\u7528\u53d1\u7968" : "\u666e\u901a\u53d1\u7968";
        invoice.setInvoiceType("\u6570\u7535\u53d1\u7968(" + string + ")");
        invoice.setInvoiceKind("\u7535\u5b50\u53d1\u7968");
        invoice.setInvoiceCategory(string);
        if ("\u4e13\u7528\u53d1\u7968".equals(string)) {
            invoice.setDeductibleTax(invoice.getInvoiceTax());
        } else {
            boolean n = Arrays.stream(this.SHOW_DEDUCTIBLE_TAX).anyMatch(summary::contains);
            if (n) {
                invoice.setDeductibleTax(invoice.getInvoiceTax());
            } else {
                invoice.setDeductibleTax(BigDecimal.ZERO);
            }
        }
        invoice.setInvoiceOpZh("\u589e\u503c\u7a0e\u6570\u7535\u53d1\u7968");
        if (summary.contains("\u4ee3\u8ba2\u673a\u7968")) {
            invoice.setInvoiceOpZh("\u4ee3\u8ba2\u673a\u7968");
        } else if (summary.contains("\u5ba2\u8fd0\u670d\u52a1")) {
            invoice.setInvoiceOpZh("\u5ba2\u8fd0\u670d\u52a1");
        }
        invoice.setInvoiceRemark(itemMap.get("vat_invoice_total_note"));
        invoice.setExtendedFields(JsonUtil.getObjectToString((Object)result));
        invoice.setCheckCode(itemMap.get("vat_invoice_correct_code"));
        invoice.setInvoiceSum(invoice.getInvoiceAmount());
        String existInvoiceSeal = itemMap.get("exist_manufacture_supervising_seal");
        invoice.setExistInvoiceSeal(false);
        if ("True".equals(existInvoiceSeal)) {
            invoice.setExistInvoiceSeal(true);
        }
        return invoice;
    }
}

