/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.ecs.strategy.ocr.impl.textin.rules;

import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.ecs.model.invoice.EcsInvoiceInfoVO;
import com.bringspring.ecs.strategy.ocr.impl.textin.enums.TextInServiceType;
import com.bringspring.ecs.strategy.ocr.impl.textin.model.response.TextInItem;
import com.bringspring.ecs.strategy.ocr.impl.textin.model.response.TextInObjectData;
import com.bringspring.ecs.strategy.ocr.impl.textin.rules.TextInInvoiceResultParse;
import com.bringspring.ecs.strategy.ocr.model.ProductInfo;
import com.bringspring.ecs.utils.ConvertNumberToUpper;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Component;

@Component(value="textin_vat_volume_invoice")
public class VatVolumeInvoice
implements TextInInvoiceResultParse {
    @Override
    public EcsInvoiceInfoVO parse(TextInObjectData result) throws DataException {
        List<TextInItem> itemList = result.getItemList();
        Map<String, String> itemMap = this.parseResultToMap(itemList);
        List<Map<String, String>> productList = this.parseResultToList(result.getProduct_list());
        EcsInvoiceInfoVO invoice = new EcsInvoiceInfoVO();
        invoice.setServiceTypeCode(result.getKind());
        String nameByCode = TextInServiceType.getNameByCode(result.getKind());
        invoice.setServiceTypeName(nameByCode);
        invoice.setInvoiceOp(result.getType());
        invoice.setInvoiceType("\u589e\u503c\u7a0e\u666e\u901a\u53d1\u7968\uff08\u5377\u7968\uff09");
        invoice.setCipher(itemMap.get("vat_invoice_cipher_field"));
        invoice.setInvoiceNumber(itemMap.get("invoice_number"));
        invoice.setInvoiceCode(itemMap.get("invoice_code"));
        String date = itemMap.get("date_of_invoice");
        String invoiceDate = DateUtil.formatDate((Date)DateUtil.parse((CharSequence)date));
        invoice.setInvoiceDate(invoiceDate);
        invoice.setSellerName(itemMap.get("sold_name"));
        invoice.setSellerTaxCode(itemMap.get("sold_tax_number"));
        invoice.setPurchaserName(itemMap.get("buy_name"));
        invoice.setPurchaserTaxCode(itemMap.get("buy_tax_number"));
        invoice.setInvoiceAmount(this.replaceAndToBigDecimal(itemMap.get("total_digits")));
        invoice.setInvoiceAmountWords(ConvertNumberToUpper.digitUppercase(invoice.getInvoiceAmount().doubleValue()));
        ArrayList<ProductInfo> productInfos = new ArrayList<ProductInfo>();
        for (Map<String, String> stringStringMap : productList) {
            ProductInfo productInfo = new ProductInfo();
            productInfo.setProductName(stringStringMap.get("goods_name_list"));
            productInfo.setProductUnit(stringStringMap.get("vat_invoice_unit"));
            productInfo.setProductNum(stringStringMap.get("goods_number_list"));
            productInfo.setProductPrice(stringStringMap.get("goods_unit_price_list"));
            productInfo.setProductAmount(stringStringMap.get("goods_money_list"));
            productInfos.add(productInfo);
        }
        invoice.setCommodityInfo(JsonUtil.getObjectToString(productInfos));
        invoice.setInvoiceSummary("");
        invoice.setInvoiceKind("\u7eb8\u8d28\u53d1\u7968");
        invoice.setInvoiceCategory("\u666e\u901a\u53d1\u7968");
        invoice.setInvoiceOpZh("\u589e\u503c\u7a0e\u5377\u7968");
        invoice.setExtendedFields(JsonUtil.getObjectToString((Object)result));
        invoice.setCheckCode(null);
        invoice.setInvoiceSum(invoice.getInvoiceAmount());
        invoice.setExistInvoiceSeal(true);
        return invoice;
    }
}

