/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.ecs.strategy.ocr.parse;

import com.bringspring.common.exception.DataException;
import com.bringspring.ecs.model.invoice.EcsInvoiceInfoVO;
import com.bringspring.ecs.strategy.ocr.impl.baidu.rules.BaiduInvoiceOcrResultParse;
import com.bringspring.ecs.strategy.ocr.model.BaiduResult;
import com.bringspring.ecs.strategy.ocr.parse.InvoiceOcrResultParseFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;

@Component
public class BaiduOcrResultParseFactory
implements InvoiceOcrResultParseFactory<BaiduResult> {
    private final ApplicationContext applicationContext;

    public BaiduOcrResultParseFactory(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    @Override
    public EcsInvoiceInfoVO parse(BaiduResult result) throws DataException {
        String type = "baidu_" + result.getType();
        BaiduInvoiceOcrResultParse parser = (BaiduInvoiceOcrResultParse)this.applicationContext.getBean(type, BaiduInvoiceOcrResultParse.class);
        EcsInvoiceInfoVO parsed = parser.parse(result);
        if (parsed == null) {
            throw new DataException("\u6682\u4e0d\u652f\u6301\u8be5\u53d1\u7968");
        }
        parsed.setOcrSource("baidu");
        return parsed;
    }
}

