/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.ecs.strategy.ocr.recognize;

import com.bringspring.common.util.JsonUtil;
import com.bringspring.ecs.model.invoice.EcsInvoiceInfoVO;
import com.bringspring.ecs.strategy.ocr.config.OcrClient;
import com.bringspring.ecs.strategy.ocr.model.BaiduResult;
import com.bringspring.ecs.strategy.ocr.recognize.InvoiceOcrService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.multipart.MultipartFile;

public class BaiduInvoiceOcrService
implements InvoiceOcrService {
    private static final Logger log = LoggerFactory.getLogger(BaiduInvoiceOcrService.class);
    private final OcrClient<BaiduResult> ocrClient;

    public BaiduInvoiceOcrService(OcrClient<BaiduResult> ocrClient) {
        this.ocrClient = ocrClient;
    }

    @Override
    public EcsInvoiceInfoVO ocr(MultipartFile file, String suffix, Boolean prevHandleImage) throws Exception {
        String recognize = this.ocrClient.recognize(file, suffix, prevHandleImage);
        BaiduResult wordsResult = (BaiduResult)JsonUtil.getJsonToBean((String)recognize, BaiduResult.class);
        return this.ocrClient.parse(wordsResult);
    }
}

