/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.ecs.strategy.ocr.recognize;

import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.Md5Util;
import com.bringspring.ecs.model.invoice.EcsInvoiceInfoVO;
import com.bringspring.ecs.strategy.ocr.config.OcrClient;
import com.bringspring.ecs.strategy.ocr.impl.textin.model.response.TextInObjectData;
import com.bringspring.ecs.strategy.ocr.impl.textin.model.response.TextInResponse;
import com.bringspring.ecs.strategy.ocr.impl.textin.model.response.TextInResult;
import com.bringspring.ecs.strategy.ocr.recognize.InvoiceOcrService;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.multipart.MultipartFile;

public class TextInInvoiceOcrService
implements InvoiceOcrService {
    private static final Logger log = LoggerFactory.getLogger(TextInInvoiceOcrService.class);
    private final OcrClient<TextInObjectData> ocrClient;

    public TextInInvoiceOcrService(OcrClient<TextInObjectData> ocrClient) {
        this.ocrClient = ocrClient;
    }

    @Override
    public EcsInvoiceInfoVO ocr(MultipartFile file, String suffix, Boolean prevHandleImage) throws Exception {
        String recognize = this.ocrClient.recognize(file, suffix, prevHandleImage);
        TextInResponse wordsResult = (TextInResponse)JsonUtil.getJsonToBean((String)recognize, TextInResponse.class);
        TextInResult result = wordsResult.getPages().get(0).getResult();
        List<TextInObjectData> objectList = result.getObjectList();
        TextInObjectData textInObjectData = objectList.get(0);
        textInObjectData.setFileMd5(Md5Util.getMd5((MultipartFile)file));
        EcsInvoiceInfoVO parse = this.ocrClient.parse(textInObjectData);
        parse.setVerifyJson(JsonUtil.getObjectToString((Object)textInObjectData.getVerifyVat()));
        return parse;
    }
}

