/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.ecs.strategy.records;

import com.bringspring.common.util.UserProvider;
import com.bringspring.ecs.entity.EcsInvoiceRuleEntity;
import com.bringspring.ecs.exception.RecordsValidateException;
import com.bringspring.ecs.model.invoicerule.EcsInvoiceRulePagination;
import com.bringspring.ecs.model.records.EcsRecordsInfoVO;
import com.bringspring.ecs.service.EcsInvoiceRuleService;
import com.bringspring.ecs.strategy.records.RecordsValidate;
import com.bringspring.ecs.strategy.validate.AnnotationContext;
import com.bringspring.ecs.strategy.validate.annotation.ValidateService;
import com.bringspring.ecs.strategy.validate.enums.RuleType;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RecordsStrategyManager {
    private final List<RecordsValidate> strategies;
    private final EcsInvoiceRuleService ruleService;
    private final UserProvider userProvider;

    @Autowired
    public RecordsStrategyManager(List<RecordsValidate> strategies, EcsInvoiceRuleService ruleService, UserProvider userProvider) {
        this.strategies = strategies;
        this.ruleService = ruleService;
        this.userProvider = userProvider;
    }

    public void execute(EcsRecordsInfoVO records, AnnotationContext context) throws RecordsValidateException {
        String organizeId = this.userProvider.get().getOrganizeId();
        EcsInvoiceRulePagination ecsInvoiceRulePagination = new EcsInvoiceRulePagination();
        ecsInvoiceRulePagination.setCompanyId(organizeId);
        ecsInvoiceRulePagination.setRuleType("1");
        List<EcsInvoiceRuleEntity> companyRuleList = this.ruleService.getCompanyRuleList(ecsInvoiceRulePagination);
        HashMap<String, Integer> maps = new HashMap<String, Integer>();
        for (EcsInvoiceRuleEntity ecsInvoiceRuleEntity : companyRuleList) {
            maps.put(ecsInvoiceRuleEntity.getRuleStrategy(), ecsInvoiceRuleEntity.getEnableMark());
        }
        for (RecordsValidate strategy : this.strategies) {
            ValidateService annotation = strategy.getClass().getAnnotation(ValidateService.class);
            if (annotation == null) continue;
            RuleType ruleType = annotation.ruleType();
            String simpleName = strategy.getClass().getSimpleName();
            Integer enableMark = (Integer)maps.get(simpleName);
            if (enableMark == null) continue;
            switch (ruleType) {
                case ALWAYS: {
                    if (enableMark == 0) break;
                    strategy.validate(records, context, true);
                    break;
                }
                case CONDITIONAL: {
                    if (enableMark == 0) break;
                    strategy.validate(records, context, false);
                    break;
                }
                case THROW_OR_WARN: {
                    boolean b = enableMark == 0;
                    strategy.validate(records, context, !b);
                    break;
                }
            }
        }
    }
}

