/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.ecs.strategy.records.rules;

import cn.hutool.core.collection.CollUtil;
import com.bringspring.ecs.exception.RecordsValidateException;
import com.bringspring.ecs.model.invoice.EcsInvoiceInfoVO;
import com.bringspring.ecs.model.records.EcsRecordsInfoVO;
import com.bringspring.ecs.model.subject.EcsRecordsChargesDetailInfoVO;
import com.bringspring.ecs.strategy.records.RecordsValidate;
import com.bringspring.ecs.strategy.validate.AnnotationContext;
import com.bringspring.ecs.strategy.validate.annotation.ValidateService;
import com.bringspring.ecs.strategy.validate.enums.RuleType;
import com.bringspring.ecs.strategy.validate.enums.ValidateCustomizableType;
import java.util.ArrayList;
import java.util.List;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Order(value=3)
@Component
@ValidateService(value="\u63d0\u4ea4\u65f6\u6821\u9a8c\u53d1\u7968\u662f\u5426\u91cd\u590d\u4e0a\u4f20", ruleType=RuleType.ALWAYS, customizableType=ValidateCustomizableType.NO)
public class RecordsDuplicateInvoice
implements RecordsValidate {
    @Override
    public void validate(EcsRecordsInfoVO records, AnnotationContext context, boolean throwErr) throws RecordsValidateException {
        if (records == null) {
            throw new RecordsValidateException("\u62a5\u9500\u5355\u6821\u9a8c\u53d1\u7968\u662f\u5426\u91cd\u590d\u5f02\u5e38");
        }
        if (records.getStatus() == 0) {
            return;
        }
        List<EcsRecordsChargesDetailInfoVO> subjectList = records.getSubjectList();
        if (CollUtil.isEmpty(subjectList)) {
            return;
        }
        ArrayList<String> existInvoiceList = new ArrayList<String>();
        for (EcsRecordsChargesDetailInfoVO subject : subjectList) {
            if (subject.getInvoiceList() == null || subject.getInvoiceList().isEmpty()) {
                throw new RecordsValidateException("\u8bf7\u4e0a\u4f20\u53d1\u7968\u540e\u63d0\u4ea4");
            }
            for (EcsInvoiceInfoVO infoVO : subject.getInvoiceList()) {
                if (existInvoiceList.contains(infoVO.getInvoiceNumber())) {
                    throw new RecordsValidateException("\u53d1\u7968:" + infoVO.getInvoiceNumber() + "\u91cd\u590d\u4e0a\u4f20");
                }
                existInvoiceList.add(infoVO.getInvoiceNumber());
            }
        }
    }
}

