/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.ecs.strategy.records.rules;

import cn.hutool.core.collection.CollUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.ecs.entity.EcsConfigEntity;
import com.bringspring.ecs.enums.ConfigServiceTypeEnum;
import com.bringspring.ecs.exception.RecordsValidateException;
import com.bringspring.ecs.model.invoice.EcsInvoiceInfoVO;
import com.bringspring.ecs.model.records.EcsRecordsInfoVO;
import com.bringspring.ecs.model.subject.EcsRecordsChargesDetailInfoVO;
import com.bringspring.ecs.service.EcsConfigService;
import com.bringspring.ecs.strategy.ocr.impl.textin.enums.TextInServiceType;
import com.bringspring.ecs.strategy.ocr.model.ProductInfo;
import com.bringspring.ecs.strategy.records.RecordsValidate;
import com.bringspring.ecs.strategy.validate.AnnotationContext;
import com.bringspring.ecs.strategy.validate.annotation.ValidateService;
import com.bringspring.ecs.strategy.validate.enums.RuleType;
import com.bringspring.ecs.strategy.validate.enums.ValidateCustomizableType;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Order(value=0)
@Component
@ValidateService(value="\u5982\u679c\u5305\u542b\u9152\u7c7b\u53d1\u7968\uff0c\u5fc5\u987b\u6709\u9910\u996e\u7968", ruleType=RuleType.ALWAYS, customizableType=ValidateCustomizableType.NO)
public class RequireRepastWithWine
implements RecordsValidate {
    @Autowired
    private EcsConfigService configService;

    @Override
    public void validate(EcsRecordsInfoVO records, AnnotationContext context, boolean throwErr) throws RecordsValidateException {
        List<EcsRecordsChargesDetailInfoVO> subjectList = records.getSubjectList();
        if (CollUtil.isEmpty(subjectList) || records.getStatus() == 0) {
            return;
        }
        boolean hasWineInvoice = false;
        boolean hasRepastInvoice = false;
        String companyId = records.getCompanyId();
        for (EcsRecordsChargesDetailInfoVO subject : subjectList) {
            List<EcsInvoiceInfoVO> invoiceList = subject.getInvoiceList();
            if (CollUtil.isEmpty(invoiceList)) continue;
            for (EcsInvoiceInfoVO invoice : invoiceList) {
                if (!hasRepastInvoice) {
                    hasRepastInvoice = this.isRepastInvoice(invoice, companyId);
                }
                if (!hasRepastInvoice) {
                    hasRepastInvoice = this.hasQuotaInvoice(invoice);
                }
                if (!hasWineInvoice) {
                    hasWineInvoice = this.checkIsWineInvoice(invoice);
                }
                if (!hasWineInvoice || !hasRepastInvoice) continue;
                return;
            }
        }
        if (hasWineInvoice && !hasRepastInvoice) {
            throw new RecordsValidateException("\u4e0a\u4f20\u9152\u7c7b\u53d1\u7968\uff0c\u5fc5\u987b\u9644\u5e26\u5728\u9910\u996e\u7c7b\u53d1\u7968\u4e0b");
        }
    }

    private boolean checkIsWineInvoice(EcsInvoiceInfoVO invoice) {
        String commodityInfo = invoice.getCommodityInfo();
        if (StringUtils.isBlank((CharSequence)commodityInfo)) {
            return false;
        }
        List productInfos = JsonUtil.getJsonToList((String)commodityInfo, ProductInfo.class);
        if (CollUtil.isEmpty((Collection)productInfos)) {
            return false;
        }
        for (ProductInfo productInfo : productInfos) {
            if (!TextInServiceType.REPAST.getCode().equals(invoice.getServiceTypeCode()) || !productInfo.getProductName().contains("*\u9152*")) continue;
            return true;
        }
        return false;
    }

    private boolean hasQuotaInvoice(EcsInvoiceInfoVO invoice) {
        return "quota_invoice".equals(invoice.getInvoiceOp());
    }

    public boolean isRepastInvoice(EcsInvoiceInfoVO invoice, String companyId) {
        block12: {
            String keyValue;
            String ruleKey;
            block14: {
                String[] keyValues;
                block13: {
                    String[] keyValues2;
                    EcsConfigEntity config = this.configService.getByKeyName("custom_repast", companyId);
                    if (!Objects.nonNull(config)) break block12;
                    String name = config.getName();
                    ruleKey = config.getRuleKey();
                    keyValue = config.getKeyValue();
                    if (StringUtils.isBlank((CharSequence)keyValue)) {
                        return false;
                    }
                    if (!ConfigServiceTypeEnum.SERVICE_TYPE.getCode().equalsIgnoreCase(ruleKey)) break block13;
                    for (String value : keyValues2 = keyValue.split(",")) {
                        if (!value.equalsIgnoreCase(invoice.getServiceTypeCode())) continue;
                        return true;
                    }
                    break block12;
                }
                if (!ConfigServiceTypeEnum.PRODUCT_NAME.getCode().equalsIgnoreCase(ruleKey)) break block14;
                String commodityInfo = invoice.getCommodityInfo();
                if (StringUtils.isBlank((CharSequence)commodityInfo)) {
                    return false;
                }
                List jsonToList = JsonUtil.getJsonToList((String)commodityInfo, ProductInfo.class);
                for (String value : keyValues = keyValue.split(",")) {
                    for (ProductInfo productInfo : jsonToList) {
                        if (!productInfo.getProductName().contains(value)) continue;
                        return true;
                    }
                }
                break block12;
            }
            if (!ConfigServiceTypeEnum.MIX.getCode().equalsIgnoreCase(ruleKey)) break block12;
            List jsonToList = null;
            try {
                jsonToList = JsonUtil.getJsonToListMap((String)keyValue);
            }
            catch (Exception e) {
                return false;
            }
            if (CollUtil.isNotEmpty((Collection)jsonToList)) {
                for (Map stringObjectMap : jsonToList) {
                    String invoiceOp;
                    Object serviceTypeObj = stringObjectMap.get(ConfigServiceTypeEnum.SERVICE_TYPE.getCode());
                    Object productNameObj = stringObjectMap.get(ConfigServiceTypeEnum.PRODUCT_NAME.getCode());
                    Object invoiceOpObj = stringObjectMap.get(ConfigServiceTypeEnum.INVOICE_OP.getCode());
                    String serviceType = serviceTypeObj != null ? serviceTypeObj.toString() : null;
                    String productName = productNameObj != null ? productNameObj.toString() : null;
                    String string = invoiceOp = invoiceOpObj != null ? invoiceOpObj.toString() : null;
                    if (productName == null || StringUtils.isBlank((CharSequence)productName)) {
                        if (serviceType != null && !"*".equalsIgnoreCase(serviceType) && !serviceType.equalsIgnoreCase(invoice.getServiceTypeCode()) || invoiceOp != null && !"*".equalsIgnoreCase(invoiceOp) && !invoiceOp.equalsIgnoreCase(invoice.getInvoiceOp())) continue;
                        return true;
                    }
                    if (serviceType == null || StringUtils.isBlank((CharSequence)serviceType) || !"*".equalsIgnoreCase(serviceType) && !serviceType.equalsIgnoreCase(invoice.getServiceTypeCode())) continue;
                    String commodityInfo = invoice.getCommodityInfo();
                    if (StringUtils.isBlank((CharSequence)commodityInfo)) {
                        return false;
                    }
                    List productInfoList = JsonUtil.getJsonToList((String)commodityInfo, ProductInfo.class);
                    boolean productMatch = false;
                    for (ProductInfo productInfo : productInfoList) {
                        if (!productInfo.getProductName().contains(productName)) continue;
                        productMatch = true;
                        break;
                    }
                    if (!productMatch) continue;
                    return true;
                }
            }
        }
        return false;
    }
}

