/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.ecs.strategy.validate;

import com.bringspring.common.util.UserProvider;
import com.bringspring.ecs.entity.EcsInvoiceRuleEntity;
import com.bringspring.ecs.exception.InvoiceValidateException;
import com.bringspring.ecs.model.invoice.EcsInvoiceInfoVO;
import com.bringspring.ecs.model.invoicerule.EcsInvoiceRulePagination;
import com.bringspring.ecs.service.EcsInvoiceRuleService;
import com.bringspring.ecs.strategy.validate.AnnotationContext;
import com.bringspring.ecs.strategy.validate.InvoiceValidateHandler;
import com.bringspring.ecs.strategy.validate.InvoiceValidateStrategy;
import com.bringspring.ecs.strategy.validate.annotation.InvoiceValidateAspect;
import com.bringspring.ecs.strategy.validate.annotation.ValidateService;
import com.bringspring.ecs.strategy.validate.enums.RuleType;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class InvoiceStrategyManager {
    private final List<InvoiceValidateStrategy> strategies;
    private final List<InvoiceValidateHandler> handlers;
    private final EcsInvoiceRuleService ruleService;
    private final UserProvider userProvider;

    @Autowired
    public InvoiceStrategyManager(List<InvoiceValidateStrategy> strategies, List<InvoiceValidateHandler> handlers, EcsInvoiceRuleService ruleService, UserProvider userProvider) {
        this.strategies = strategies;
        this.handlers = handlers;
        this.ruleService = ruleService;
        this.userProvider = userProvider;
    }

    public void execute(EcsInvoiceInfoVO invoice, AnnotationContext context) throws InvoiceValidateException {
        this.executeHandlers(invoice, context, InvoiceValidateAspect.AspectType.BEFORE);
        this.executeStrategies(invoice, context);
        this.executeHandlers(invoice, context, InvoiceValidateAspect.AspectType.AFTER);
    }

    private void executeHandlers(EcsInvoiceInfoVO invoice, AnnotationContext context, InvoiceValidateAspect.AspectType aspectType) throws InvoiceValidateException {
        List sortedHandlers = this.handlers.stream().filter(handler -> {
            InvoiceValidateAspect aspect = handler.getClass().getAnnotation(InvoiceValidateAspect.class);
            return aspect != null && aspect.type() != null && aspect.type() == aspectType;
        }).sorted((h1, h2) -> {
            InvoiceValidateAspect a1 = h1.getClass().getAnnotation(InvoiceValidateAspect.class);
            InvoiceValidateAspect a2 = h2.getClass().getAnnotation(InvoiceValidateAspect.class);
            return Integer.compare(a1.order(), a2.order());
        }).collect(Collectors.toList());
        for (InvoiceValidateHandler handler2 : sortedHandlers) {
            handler2.handle(invoice, context);
        }
    }

    private void executeStrategies(EcsInvoiceInfoVO invoice, AnnotationContext context) throws InvoiceValidateException {
        String organizeId = this.userProvider.get().getOrganizeId();
        EcsInvoiceRulePagination ecsInvoiceRulePagination = new EcsInvoiceRulePagination();
        ecsInvoiceRulePagination.setCompanyId(organizeId);
        ecsInvoiceRulePagination.setRuleType("0");
        List<EcsInvoiceRuleEntity> companyRuleList = this.ruleService.getCompanyRuleList(ecsInvoiceRulePagination);
        HashMap<String, Integer> maps = new HashMap<String, Integer>();
        for (EcsInvoiceRuleEntity ecsInvoiceRuleEntity : companyRuleList) {
            maps.put(ecsInvoiceRuleEntity.getRuleStrategy(), ecsInvoiceRuleEntity.getEnableMark());
        }
        for (InvoiceValidateStrategy strategy : this.strategies) {
            ValidateService annotation = strategy.getClass().getAnnotation(ValidateService.class);
            if (annotation == null) continue;
            RuleType ruleType = annotation.ruleType();
            String simpleName = strategy.getClass().getSimpleName();
            Integer enableMark = (Integer)maps.get(simpleName);
            if (enableMark == null) break;
            switch (ruleType) {
                case ALWAYS: {
                    if (enableMark == 0) break;
                    strategy.validate(invoice, context, true);
                    break;
                }
                case CONDITIONAL: {
                    if (enableMark == 0) break;
                    strategy.validate(invoice, context, false);
                    break;
                }
                case THROW_OR_WARN: {
                    boolean b = enableMark == 0;
                    strategy.validate(invoice, context, !b);
                    break;
                }
            }
        }
    }
}

