/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.ecs.strategy.validate.handler.after;

import com.bringspring.common.util.Md5Util;
import com.bringspring.common.util.StringUtils;
import com.bringspring.ecs.model.invoice.EcsInvoiceInfoVO;
import com.bringspring.ecs.strategy.validate.AnnotationContext;
import com.bringspring.ecs.strategy.validate.InvoiceValidateHandler;
import com.bringspring.ecs.strategy.validate.annotation.InvoiceValidateAspect;
import org.springframework.stereotype.Component;

@Component
@InvoiceValidateAspect(type=InvoiceValidateAspect.AspectType.AFTER, order=4)
public class InvoiceNumberNullAfterHandler
implements InvoiceValidateHandler {
    @Override
    public void handle(EcsInvoiceInfoVO invoice, AnnotationContext context) {
        if ("bus_ticket".equals(invoice.getInvoiceOp())) {
            context.addAnnotation("OCR\u8bc6\u522b\u53d1\u7968\u53f7\u7801\u4e3a\u7a7a");
            context.addErrorFields("invoiceNumber");
            return;
        }
        if ("electronic_medical_invoice".equals(invoice.getInvoiceOp()) && StringUtils.isBlank((CharSequence)invoice.getInvoiceNumber())) {
            String invoiceNumber = Md5Util.getStringMd5((String)(invoice.getInvoiceDate() + invoice.getPurchaserName() + invoice.getPurchaserTaxCode() + invoice.getCommodityInfo()));
            invoice.setInvoiceNumber(invoiceNumber);
            context.addAnnotation("OCR\u8bc6\u522b\u53d1\u7968\u53f7\u7801\u4e3a\u7a7a");
            context.addErrorFields("invoiceNumber");
        }
    }
}

