/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.ecs.strategy.validate.handler.before;

import com.bringspring.common.util.StringUtils;
import com.bringspring.ecs.entity.EcsConfigEntity;
import com.bringspring.ecs.model.invoice.EcsInvoiceInfoVO;
import com.bringspring.ecs.service.EcsConfigService;
import com.bringspring.ecs.strategy.validate.AnnotationContext;
import com.bringspring.ecs.strategy.validate.InvoiceValidateHandler;
import com.bringspring.ecs.strategy.validate.annotation.InvoiceValidateAspect;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@InvoiceValidateAspect(type=InvoiceValidateAspect.AspectType.BEFORE, order=1)
public class HandleRemarkInfo
implements InvoiceValidateHandler {
    @Autowired
    private EcsConfigService ecsConfigService;

    @Override
    public void handle(EcsInvoiceInfoVO invoice, AnnotationContext context) {
        Object companyId = context.getMetaData("companyId");
        Map<String, String> invoiceInfo = this.extractInvoiceInfo(invoice.getCommodityInfo(), invoice.getInvoiceRemark(), companyId.toString());
        if (!invoiceInfo.isEmpty()) {
            invoice.setPassengerName(invoiceInfo.get("\u59d3\u540d"));
            invoice.setPassengerIdNum(invoiceInfo.get("\u8eab\u4efd\u8bc1\u53f7"));
            invoice.setTravelDate(invoiceInfo.get("\u65f6\u95f4"));
            invoice.setDepartureStation(invoiceInfo.get("\u8d77\u59cb\u5730"));
            invoice.setArrivalStation(invoiceInfo.get("\u76ee\u7684\u5730"));
        }
    }

    private List<String> getSupportedTypes(String companyId) {
        EcsConfigEntity config = this.ecsConfigService.getByKeyName("extractInvoiceRemarkType", companyId);
        if (config != null && StringUtils.isNotBlank((CharSequence)config.getKeyValue())) {
            return Arrays.asList(config.getKeyValue().split(","));
        }
        return Collections.emptyList();
    }

    public Map<String, String> extractInvoiceInfo(String commodityInfo, String remark, String companyId) {
        Map<String, String> result = new HashMap<String, String>();
        if (commodityInfo == null || remark == null || StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{commodityInfo, remark})) {
            return result;
        }
        List<String> supportedTypes = this.getSupportedTypes(companyId);
        boolean b = supportedTypes.stream().anyMatch(commodityInfo::contains);
        if (b) {
            result = this.extractInfo(commodityInfo, remark);
        }
        return result;
    }

    private Map<String, String> extractInfo(String commodity, String remark) {
        HashMap<String, String> result = new HashMap<String, String>();
        try {
            if (remark.contains("\u667a\u884c\u8ba2\u5355\u53f7")) {
                HandleRemarkInfo.extractZhixingFlightInfo(remark, result);
            } else if (remark.contains("\u643a\u7a0b\u8ba2\u5355")) {
                HandleRemarkInfo.extractCtripInfo(remark, result);
            } else if (commodity.contains("\u7ecf\u7eaa\u4ee3\u7406\u670d\u52a1*\u673a\u7968\u6b3e")) {
                HandleRemarkInfo.extractFlightPaymentInfo(remark, result);
            } else if (commodity.contains("\u7269\u6d41\u8f85\u52a9\u670d\u52a1*\u7535\u5b50\u5ba2\u7968")) {
                HandleRemarkInfo.extractBusTicketInfo(remark, result);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    private static void extractBusTicketInfo(String remark, Map<String, String> result) {
        Pattern passengerPattern;
        Matcher passengerMatcher;
        Pattern sitePattern;
        Matcher siteMatcher;
        Pattern timePattern = Pattern.compile("\u73ed\u6b21\u65f6\u95f4:(\\d{4}-\\d{2}-\\d{2} \\d{2}:\\d{2})");
        Matcher timeMatcher = timePattern.matcher(remark);
        if (timeMatcher.find()) {
            result.put("\u65f6\u95f4", timeMatcher.group(1) + ":00");
        }
        if ((siteMatcher = (sitePattern = Pattern.compile("\u8d77\u6b62\u7ad9\u70b9:\u3010(.*?)\u3011\u81f3\u3010(.*?)\u3011")).matcher(remark)).find()) {
            result.put("\u8d77\u59cb\u5730", siteMatcher.group(1));
            result.put("\u76ee\u7684\u5730", siteMatcher.group(2));
        }
        if ((passengerMatcher = (passengerPattern = Pattern.compile("\u4e58\u5ba2\u4fe1\u606f:([^\\d]+?)(\\d{4}\\*+\\d{4})")).matcher(remark)).find()) {
            result.put("\u59d3\u540d", passengerMatcher.group(1).trim());
            result.put("\u8eab\u4efd\u8bc1\u53f7", passengerMatcher.group(2));
        }
    }

    private static void extractZhixingFlightInfo(String remark, Map<String, String> result) {
        Pattern pattern = Pattern.compile("\u884c\u7a0b\u4fe1\u606f:(\\d{4}-\\d{2}-\\d{2}) (.*?)-(.*?)\u822a\u73ed\u53f7:(.*?)\u4e58\u673a\u4eba:(.*)");
        Matcher matcher = pattern.matcher(remark);
        if (matcher.find()) {
            result.put("\u65f6\u95f4", matcher.group(1) + " 00:00:00");
            result.put("\u8d77\u59cb\u5730", matcher.group(2).trim());
            result.put("\u76ee\u7684\u5730", matcher.group(3).trim());
            result.put("\u8f66\u53f7", matcher.group(4).trim());
            result.put("\u59d3\u540d", matcher.group(5).trim());
        }
    }

    private static void extractCtripInfo(String remark, Map<String, String> result) {
        Pattern pattern = Pattern.compile(".*?(\\d{4}/\\d{1,2}/\\d{1,2}) (.*?)-(.*?) (.*?) (\\p{L}+)");
        Matcher matcher = pattern.matcher(remark);
        if (matcher.find()) {
            try {
                SimpleDateFormat inputFormat = new SimpleDateFormat("yyyy/M/d");
                SimpleDateFormat outputFormat = new SimpleDateFormat("yyyy-MM-dd");
                String formattedDate = outputFormat.format(inputFormat.parse(matcher.group(1)));
                result.put("\u65f6\u95f4", formattedDate + " 00:00:00");
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            result.put("\u8d77\u59cb\u5730", matcher.group(2).trim());
            result.put("\u76ee\u7684\u5730", matcher.group(3).trim());
            result.put("\u8f66\u53f7", matcher.group(4).trim());
            result.put("\u59d3\u540d", matcher.group(5).trim());
        }
    }

    private static void extractFlightPaymentInfo(String remark, Map<String, String> result) {
        Pattern pattern2 = Pattern.compile("\u4e58\u673a\u4eba:(.*?);\u822a\u73ed:(.*?)-(.*?);\u822a\u73ed\u53f7:(.*?);\u8d77\u98de\u65f6\u95f4:(\\d{4}-\\d{2}-\\d{2})");
        Matcher matcher2 = pattern2.matcher(remark);
        if (matcher2.find()) {
            result.put("\u59d3\u540d", matcher2.group(1).trim());
            result.put("\u8d77\u59cb\u5730", matcher2.group(2).trim());
            result.put("\u76ee\u7684\u5730", matcher2.group(3).trim());
            result.put("\u8f66\u53f7", matcher2.group(4).trim());
            result.put("\u65f6\u95f4", matcher2.group(5) + " 00:00:00");
            return;
        }
        Pattern pattern1 = Pattern.compile("(\\d{4}-\\d{2}-\\d{2}) (\\d{2}:\\d{2})-\\d{2}:\\d{2} (.*?)-(.*?) .* (\\p{L}+)");
        Matcher matcher1 = pattern1.matcher(remark);
        if (matcher1.find()) {
            result.put("\u65f6\u95f4", matcher1.group(1) + " " + matcher1.group(2) + ":00");
            result.put("\u8d77\u59cb\u5730", matcher1.group(3).trim());
            result.put("\u76ee\u7684\u5730", matcher1.group(4).trim());
            result.put("\u59d3\u540d", matcher1.group(5).trim());
            return;
        }
    }
}

