/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.ecs.strategy.validate.handler.before;

import com.bringspring.common.util.StringUtils;
import com.bringspring.ecs.model.invoice.EcsInvoiceInfoVO;
import com.bringspring.ecs.strategy.validate.AnnotationContext;
import com.bringspring.ecs.strategy.validate.InvoiceValidateHandler;
import com.bringspring.ecs.strategy.validate.annotation.InvoiceValidateAspect;
import org.springframework.stereotype.Component;

@Component
@InvoiceValidateAspect(type=InvoiceValidateAspect.AspectType.BEFORE, order=0)
public class PassengerNameBeforeHandler
implements InvoiceValidateHandler {
    @Override
    public void handle(EcsInvoiceInfoVO invoice, AnnotationContext context) {
        String passengerName = invoice.getPassengerName();
        if (StringUtils.isNotBlank((CharSequence)passengerName) && passengerName.endsWith("\u65e0")) {
            invoice.setPassengerName(passengerName.substring(0, passengerName.length() - 1));
        }
    }
}

