/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.ecs.strategy.validate.handler.before;

import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.ecs.entity.EcsConfigEntity;
import com.bringspring.ecs.model.invoice.EcsInvoiceInfoVO;
import com.bringspring.ecs.service.EcsConfigService;
import com.bringspring.ecs.strategy.validate.AnnotationContext;
import com.bringspring.ecs.strategy.validate.InvoiceValidateHandler;
import com.bringspring.ecs.strategy.validate.annotation.InvoiceValidateAspect;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@InvoiceValidateAspect(type=InvoiceValidateAspect.AspectType.BEFORE, order=1)
public class RareWordHandler
implements InvoiceValidateHandler {
    @Autowired
    private EcsConfigService ecsConfigService;

    @Override
    public void handle(EcsInvoiceInfoVO invoice, AnnotationContext context) {
        String passengerIdNum = invoice.getPassengerIdNum();
        String passengerName = invoice.getPassengerName();
        Object companyId = context.getMetaData("companyId");
        EcsConfigEntity config = this.ecsConfigService.getByKeyName("rareWord", companyId.toString());
        if (config == null) {
            return;
        }
        if (StringUtils.isNotBlank((CharSequence)passengerName) && StringUtils.isNotBlank((CharSequence)passengerIdNum)) {
            String keyValue = config.getKeyValue();
            List jsonToList = JsonUtil.getJsonToListMap((String)keyValue);
            for (Map rule : jsonToList) {
                Map conditions = (Map)rule.get("conditions");
                boolean match = true;
                for (Map.Entry entry : conditions.entrySet()) {
                    String field = (String)entry.getKey();
                    Map condition = (Map)entry.getValue();
                    String value = field.equals("passengerIdNum") ? passengerIdNum : passengerName;
                    for (Map.Entry cond : condition.entrySet()) {
                        String type = (String)cond.getKey();
                        String expected = (String)cond.getValue();
                        if (type.equals("equals") && !value.equals(expected)) {
                            match = false;
                            continue;
                        }
                        if (type.equals("startsWith") && !value.startsWith(expected)) {
                            match = false;
                            continue;
                        }
                        if (!type.equals("endsWith") || value.endsWith(expected)) continue;
                        match = false;
                    }
                }
                if (!match) continue;
                Map result = (Map)rule.get("result");
                if (result.containsKey("setPassengerName")) {
                    invoice.setPassengerName((String)result.get("setPassengerName"));
                }
                return;
            }
        }
    }
}

