/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.ecs.strategy.validate.rules;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.bringspring.common.util.StringUtils;
import com.bringspring.ecs.entity.EcsInvoiceEntity;
import com.bringspring.ecs.entity.EcsRecordsEntity;
import com.bringspring.ecs.enums.DeleteMarkEnum;
import com.bringspring.ecs.exception.InvoiceValidateException;
import com.bringspring.ecs.model.invoice.EcsInvoiceInfoVO;
import com.bringspring.ecs.service.EcsInvoiceService;
import com.bringspring.ecs.service.EcsRecordsService;
import com.bringspring.ecs.strategy.validate.AnnotationContext;
import com.bringspring.ecs.strategy.validate.InvoiceValidateStrategy;
import com.bringspring.ecs.strategy.validate.annotation.ValidateService;
import com.bringspring.ecs.strategy.validate.enums.RuleType;
import java.io.Serializable;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Order(value=1)
@Component
@ValidateService(value="\u68c0\u67e5\u53d1\u7968\u662f\u5426\u91cd\u590d", ruleType=RuleType.ALWAYS)
public class DuplicateInvoiceStrategy
implements InvoiceValidateStrategy {
    @Autowired
    private EcsInvoiceService invoiceService;
    @Autowired
    private EcsRecordsService recordsService;

    @Override
    public void validate(EcsInvoiceInfoVO invoice, AnnotationContext context, boolean throwErr) throws InvoiceValidateException {
        if (invoice == null || StringUtils.isBlank((CharSequence)invoice.getInvoiceNumber())) {
            throw new InvoiceValidateException("\u53d1\u7968\u4e0d\u5408\u6cd5");
        }
        List duplicates = this.invoiceService.list((Wrapper)new LambdaQueryWrapper().eq(EcsInvoiceEntity::getInvoiceNumber, (Object)invoice.getInvoiceNumber()));
        for (EcsInvoiceEntity duplicate : duplicates) {
            EcsRecordsEntity byId;
            if (!StringUtils.isNotBlank((CharSequence)duplicate.getRecordId()) || (byId = (EcsRecordsEntity)this.recordsService.getById((Serializable)((Object)duplicate.getRecordId()))) == null || !DeleteMarkEnum.NOT_DELETE.getDeleteMark().equals(byId.getDeleteMark())) continue;
            throw new InvoiceValidateException(String.format("\u8be5\u53d1\u7968\u5728\u5355\u636e[%s]\u4e2d\u5df2\u7ecf\u5173\u8054", byId.getOrderNumber()));
        }
        if (!duplicates.isEmpty()) {
            context.addMetaData("duplicateId", ((EcsInvoiceEntity)duplicates.get(0)).getId());
        }
    }
}

