/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.ecs.strategy.validate.rules;

import com.bringspring.common.util.StringUtils;
import com.bringspring.ecs.entity.EcsConfigEntity;
import com.bringspring.ecs.exception.InvoiceValidateException;
import com.bringspring.ecs.model.invoice.EcsInvoiceInfoVO;
import com.bringspring.ecs.service.EcsConfigService;
import com.bringspring.ecs.strategy.validate.AnnotationContext;
import com.bringspring.ecs.strategy.validate.InvoiceValidateStrategy;
import com.bringspring.ecs.strategy.validate.annotation.ValidateService;
import com.bringspring.ecs.strategy.validate.enums.RuleType;
import java.time.LocalDate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Order(value=1)
@Component
@ValidateService(value="\u5f00\u7968\u65f6\u95f4\u4e0d\u80fd\u65e9\u4e8e\u51fa\u5dee\u5f00\u59cb\u65f6\u95f4", ruleType=RuleType.ALWAYS)
public class InvoiceDateBeforeTravelDateStrategy
implements InvoiceValidateStrategy {
    @Autowired
    private EcsConfigService ecsConfigService;

    @Override
    public void validate(EcsInvoiceInfoVO invoice, AnnotationContext context, boolean throwErr) throws InvoiceValidateException {
        String keyValue;
        if (!"traffic".equals(context.getMetaData("reimbType"))) {
            return;
        }
        Object ccBeginDate = context.getMetaData("ccBeginDate");
        if (ccBeginDate == null) {
            return;
        }
        String string = ccBeginDate.toString();
        String invoiceDate = invoice.getInvoiceDate();
        if (StringUtils.isBlank((CharSequence)invoiceDate)) {
            return;
        }
        Object companyId = context.getMetaData("companyId");
        EcsConfigEntity config = this.ecsConfigService.getByKeyName("reimbType", companyId.toString());
        int daysToAdd = 7;
        if (config != null && StringUtils.isNotBlank((CharSequence)(keyValue = config.getKeyValue()))) {
            daysToAdd = Integer.parseInt(keyValue);
        }
        LocalDate parse = LocalDate.parse(invoiceDate);
        LocalDate parse1 = LocalDate.parse(string);
        LocalDate newInvoiceDate = parse.plusDays(daysToAdd);
        if (newInvoiceDate.isBefore(parse1)) {
            throw new InvoiceValidateException("\u5f00\u7968\u65e5\u671f\u4e0d\u80fd\u65e9\u4e8e\u51fa\u5dee\u5f00\u59cb\u65e5\u671f\u8d85\u8fc7" + daysToAdd + "\u5929");
        }
    }
}

