/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.ecs.strategy.validate.rules;

import com.bringspring.common.util.StringUtils;
import com.bringspring.ecs.entity.EcsCompanyEntity;
import com.bringspring.ecs.exception.InvoiceValidateException;
import com.bringspring.ecs.model.invoice.EcsInvoiceInfoVO;
import com.bringspring.ecs.service.EcsCompanyService;
import com.bringspring.ecs.strategy.validate.AnnotationContext;
import com.bringspring.ecs.strategy.validate.InvoiceValidateStrategy;
import com.bringspring.ecs.strategy.validate.annotation.ValidateService;
import com.bringspring.ecs.strategy.validate.enums.RuleType;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Order(value=0)
@Component
@ValidateService(value="\u68c0\u67e5\u53d1\u7968\u62ac\u5934\u4e00\u81f4\u6027", ruleType=RuleType.ALWAYS)
public class InvoiceTitleStrategy
implements InvoiceValidateStrategy {
    private static final String ERROR_INFO = "\u53d1\u7968\u62ac\u5934\u4e0e\u62a5\u9500\u516c\u53f8\u540d\u79f0\u6216\u7a0e\u53f7\u4e0d\u4e00\u81f4";
    @Autowired
    private EcsCompanyService companyService;

    @Override
    public void validate(EcsInvoiceInfoVO invoice, AnnotationContext context, boolean throwErr) throws InvoiceValidateException {
        Object reimbCompany = context.getMetaData("reimbCompany");
        if (reimbCompany == null) {
            throw new InvoiceValidateException(ERROR_INFO);
        }
        EcsCompanyEntity info = this.companyService.getInfo(reimbCompany.toString());
        if (info == null) {
            throw new InvoiceValidateException(ERROR_INFO);
        }
        if (StringUtils.isAllBlank((CharSequence[])new CharSequence[]{invoice.getPurchaserName(), invoice.getPurchaserTaxCode()})) {
            return;
        }
        if (!info.getName().equals(invoice.getPurchaserName())) {
            throw new InvoiceValidateException(ERROR_INFO);
        }
        if (!info.getTaxId().equals(invoice.getPurchaserTaxCode())) {
            throw new InvoiceValidateException(ERROR_INFO);
        }
    }
}

