/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.ecs.strategy.validate.rules;

import com.bringspring.ecs.enums.InvoiceCatergoryEnum;
import com.bringspring.ecs.exception.InvoiceValidateException;
import com.bringspring.ecs.model.invoice.EcsInvoiceInfoVO;
import com.bringspring.ecs.service.EcsConfigService;
import com.bringspring.ecs.strategy.validate.AnnotationContext;
import com.bringspring.ecs.strategy.validate.InvoiceValidateStrategy;
import com.bringspring.ecs.strategy.validate.annotation.ValidateService;
import com.bringspring.ecs.strategy.validate.enums.RuleType;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Order(value=5)
@Component
@ValidateService(value="\u62db\u5f85\u8d39\u4e13\u7968\u63d0\u9192", ruleType=RuleType.ALWAYS)
public class ReceiveProfessionalStrategy
implements InvoiceValidateStrategy {
    @Autowired
    private EcsConfigService ecsConfigService;

    @Override
    public void validate(EcsInvoiceInfoVO invoice, AnnotationContext context, boolean throwErr) throws InvoiceValidateException {
        Object reimbType = context.getMetaData("reimbType");
        if (!"receive".equals(reimbType)) {
            return;
        }
        if (!"vat_invoice".equals(invoice.getInvoiceOp()) && !"vat_digital_invoice".equals(invoice.getInvoiceOp())) {
            return;
        }
        if (InvoiceCatergoryEnum.SPECIAL_INVOICE.getName().equals(invoice.getInvoiceCategory())) {
            context.addAnnotation("\u62db\u5f85\u8d39\u4e13\u7968");
        }
    }
}

