/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.ecs.strategy.validate.rules;

import com.bringspring.common.util.StringUtils;
import com.bringspring.ecs.entity.EcsConfigEntity;
import com.bringspring.ecs.exception.InvoiceValidateException;
import com.bringspring.ecs.model.invoice.EcsInvoiceInfoVO;
import com.bringspring.ecs.service.EcsConfigService;
import com.bringspring.ecs.strategy.validate.AnnotationContext;
import com.bringspring.ecs.strategy.validate.InvoiceValidateStrategy;
import com.bringspring.ecs.strategy.validate.annotation.ValidateService;
import com.bringspring.ecs.strategy.validate.enums.RuleType;
import com.bringspring.ecs.strategy.validate.enums.ValidateCustomizableType;
import java.math.BigDecimal;
import java.math.RoundingMode;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Order(value=1)
@Component
@ValidateService(value="\u62db\u5f85\u8d39\u62a5\u9500\u5355\u4e2a\u53d1\u7968\u91d1\u989d", ruleType=RuleType.CONDITIONAL, customizableType=ValidateCustomizableType.YES)
public class ReceiveTotalAmountStrategy
implements InvoiceValidateStrategy {
    @Autowired
    private EcsConfigService ecsConfigService;

    @Override
    public void validate(EcsInvoiceInfoVO invoice, AnnotationContext context, boolean throwErr) throws InvoiceValidateException {
        String keyValue;
        if (!"receive".equals(context.getMetaData("reimbType"))) {
            return;
        }
        Object companyId = context.getMetaData("companyId");
        String defaultValue = "2000";
        BigDecimal limitAmount = new BigDecimal(defaultValue).setScale(2, RoundingMode.HALF_UP);
        EcsConfigEntity receiveWaterListAmount = this.ecsConfigService.getByKeyName("receiveWaterListAmount", companyId.toString());
        if (receiveWaterListAmount != null && StringUtils.isNotBlank((CharSequence)(keyValue = receiveWaterListAmount.getKeyValue()))) {
            try {
                limitAmount = new BigDecimal(keyValue).setScale(2, RoundingMode.HALF_UP);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        String fileType = "\u6c34\u5355";
        if ("2".equals(companyId)) {
            fileType = "\u4ed8\u6b3e\u622a\u56fe";
        }
        if (invoice.getInvoiceAmount().compareTo(limitAmount) > 0) {
            context.addAnnotation("\u62db\u5f85\u8d39\u91d1\u989d\u8d85\u8fc7" + limitAmount + "\u5143\uff0c\u9700\u4e0a\u4f20" + fileType);
        }
    }
}

