/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.ecs.strategy.validate.rules;

import com.bringspring.common.util.DateUtil;
import com.bringspring.ecs.exception.InvoiceValidateException;
import com.bringspring.ecs.model.invoice.EcsInvoiceInfoVO;
import com.bringspring.ecs.strategy.ocr.config.OcrClient;
import com.bringspring.ecs.strategy.validate.AnnotationContext;
import com.bringspring.ecs.strategy.validate.InvoiceValidateStrategy;
import com.bringspring.ecs.strategy.validate.annotation.ValidateService;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Order(value=10)
@Component
@ValidateService(value="\u589e\u503c\u7a0e\u53d1\u7968\u9a8c\u771f")
public class VatInvoiceVerification
implements InvoiceValidateStrategy {
    @Autowired
    private OcrClient ocrClient;

    @Override
    public void validate(EcsInvoiceInfoVO invoice, AnnotationContext context, boolean throwErr) throws InvoiceValidateException {
        String invoiceDate = invoice.getInvoiceDate();
        String nowDate = DateUtil.formatDate((Date)DateUtil.getNowDate());
        if (nowDate.equals(invoiceDate)) {
            throw new InvoiceValidateException("\u4eca\u65e5\u53d1\u7968\u4fe1\u606f\u672a\u540c\u6b65\u7a0e\u52a1\u7cfb\u7edf\uff0c\u8bf7\u660e\u65e5\u518d\u63d0\u4ea4\u62a5\u9500\u7533\u8bf7");
        }
        this.ocrClient.verification(invoice);
    }
}

