/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.ecs.utils;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.awt.image.RescaleOp;
import java.awt.image.WritableRaster;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Arrays;
import javax.imageio.ImageIO;
import org.springframework.web.multipart.MultipartFile;

public class ImageEnhancer {
    public static byte[] processFile(MultipartFile multipartFile, String suffix) throws IOException {
        String lowerName = suffix.toLowerCase();
        if (lowerName.endsWith("pdf")) {
            return multipartFile.getBytes();
        }
        if (lowerName.matches("(jpg|jpeg|png|bmp|tif|tiff)")) {
            return ImageEnhancer.enhanceImage(multipartFile);
        }
        throw new IOException("\u4e0d\u652f\u6301\u7684\u6587\u4ef6\u7c7b\u578b\uff0c\u4ec5\u652f\u6301\u56fe\u50cf\u6216 PDF \u6587\u4ef6");
    }

    public static byte[] enhanceImage(MultipartFile multipartFile) throws IOException {
        BufferedImage original = ImageIO.read(multipartFile.getInputStream());
        if (original == null) {
            throw new IOException("\u65e0\u6cd5\u8bfb\u53d6\u56fe\u7247\u6587\u4ef6.");
        }
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            BufferedImage denoised = ImageEnhancer.applyMedianFilter(original);
            BufferedImage merged = ImageEnhancer.mergeWithOriginal(original, denoised);
            boolean written = ImageIO.write((RenderedImage)merged, "png", baos);
            if (!written) {
                throw new IOException("Failed to encode image to PNG format.");
            }
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
    }

    public static BufferedImage enhanceContrast(BufferedImage src, float scale, float offset) {
        RescaleOp rescaleOp = new RescaleOp(scale, offset, null);
        return rescaleOp.filter(src, null);
    }

    private static BufferedImage applyOtsuThreshold(BufferedImage gray) {
        int width = gray.getWidth();
        int height = gray.getHeight();
        WritableRaster raster = gray.getRaster();
        int[] histogram = new int[256];
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int n = raster.getSample(x, y, 0);
                histogram[n] = histogram[n] + 1;
            }
        }
        int total = width * height;
        float sum = 0.0f;
        for (int i = 0; i < 256; ++i) {
            sum += (float)(i * histogram[i]);
        }
        float sumB = 0.0f;
        int wB = 0;
        float maxVar = 0.0f;
        int threshold = 0;
        for (int i = 0; i < 256; ++i) {
            float mF;
            float betweenVar;
            if ((wB += histogram[i]) == 0) continue;
            int wF = total - wB;
            if (wF == 0) break;
            float mB = (sumB += (float)(i * histogram[i])) / (float)wB;
            if (!((betweenVar = (float)wB * (float)wF * (mB - (mF = (sum - sumB) / (float)wF)) * (mB - mF)) > maxVar)) continue;
            maxVar = betweenVar;
            threshold = i;
        }
        BufferedImage binary = new BufferedImage(width, height, 12);
        WritableRaster out = binary.getRaster();
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int grayVal = raster.getSample(x, y, 0);
                out.setSample(x, y, 0, grayVal > threshold ? 1 : 0);
            }
        }
        return binary;
    }

    private static BufferedImage toGrayscale(BufferedImage src) {
        BufferedImage gray = new BufferedImage(src.getWidth(), src.getHeight(), 10);
        Graphics g = gray.getGraphics();
        g.drawImage(src, 0, 0, null);
        g.dispose();
        return gray;
    }

    public static BufferedImage equalize(BufferedImage original) {
        int width = original.getWidth();
        int height = original.getHeight();
        int[] gray = new int[width * height];
        int[] histogram = new int[256];
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int grayVal;
                int rgb = original.getRGB(x, y);
                int r = rgb >> 16 & 0xFF;
                int g = rgb >> 8 & 0xFF;
                int b = rgb & 0xFF;
                gray[y * width + x] = grayVal = (int)(0.299 * (double)r + 0.587 * (double)g + 0.114 * (double)b);
                int n = grayVal;
                histogram[n] = histogram[n] + 1;
            }
        }
        int[] cdf = new int[256];
        cdf[0] = histogram[0];
        for (int i = 1; i < 256; ++i) {
            cdf[i] = cdf[i - 1] + histogram[i];
        }
        int totalPixels = width * height;
        int[] lut = new int[256];
        for (int i = 0; i < 256; ++i) {
            lut[i] = (cdf[i] - cdf[0]) * 255 / (totalPixels - cdf[0]);
            lut[i] = Math.max(0, Math.min(255, lut[i]));
        }
        BufferedImage result = new BufferedImage(width, height, 10);
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int val = lut[gray[y * width + x]];
                int rgb = val << 16 | val << 8 | val;
                result.setRGB(x, y, rgb);
            }
        }
        return result;
    }

    private static BufferedImage equalizeHistogram(BufferedImage gray) {
        int w = gray.getWidth();
        int h = gray.getHeight();
        WritableRaster raster = gray.getRaster();
        int[] histogram = new int[256];
        int[] cdf = new int[256];
        for (int y = 0; y < h; ++y) {
            for (int x = 0; x < w; ++x) {
                int n = raster.getSample(x, y, 0);
                histogram[n] = histogram[n] + 1;
            }
        }
        cdf[0] = histogram[0];
        for (int i = 1; i < 256; ++i) {
            cdf[i] = cdf[i - 1] + histogram[i];
        }
        int cdfMin = 0;
        for (int i = 0; i < 256; ++i) {
            if (cdf[i] == 0) continue;
            cdfMin = cdf[i];
            break;
        }
        int totalPixels = w * h;
        int[] lut = new int[256];
        for (int i = 0; i < 256; ++i) {
            lut[i] = Math.round((float)(cdf[i] - cdfMin) * 255.0f / (float)(totalPixels - cdfMin));
        }
        for (int y = 0; y < h; ++y) {
            for (int x = 0; x < w; ++x) {
                int val = raster.getSample(x, y, 0);
                raster.setSample(x, y, 0, lut[val]);
            }
        }
        return gray;
    }

    private static BufferedImage applySharpen(BufferedImage img) {
        float[] kernel = new float[]{0.0f, -1.0f, 0.0f, -1.0f, 5.0f, -1.0f, 0.0f, -1.0f, 0.0f};
        return ImageEnhancer.applyConvolution(img, kernel);
    }

    private static BufferedImage applyConvolution(BufferedImage img, float[] kernel) {
        int w = img.getWidth();
        int h = img.getHeight();
        BufferedImage result = new BufferedImage(w, h, 10);
        WritableRaster src = img.getRaster();
        WritableRaster dst = result.getRaster();
        for (int y = 1; y < h - 1; ++y) {
            for (int x = 1; x < w - 1; ++x) {
                float sum = 0.0f;
                int idx = 0;
                for (int j = -1; j <= 1; ++j) {
                    for (int i = -1; i <= 1; ++i) {
                        sum += kernel[idx++] * (float)src.getSample(x + i, y + j, 0);
                    }
                }
                int val = Math.min(255, Math.max(0, Math.round(sum)));
                dst.setSample(x, y, 0, val);
            }
        }
        return result;
    }

    private static BufferedImage applyMedianFilter(BufferedImage img) {
        int w = img.getWidth();
        int h = img.getHeight();
        BufferedImage result = new BufferedImage(w, h, 10);
        WritableRaster src = img.getRaster();
        WritableRaster dst = result.getRaster();
        for (int y = 1; y < h - 1; ++y) {
            for (int x = 1; x < w - 1; ++x) {
                int[] values = new int[9];
                int idx = 0;
                for (int j = -1; j <= 1; ++j) {
                    for (int i = -1; i <= 1; ++i) {
                        values[idx++] = src.getSample(x + i, y + j, 0);
                    }
                }
                Arrays.sort(values);
                dst.setSample(x, y, 0, values[4]);
            }
        }
        return result;
    }

    private static BufferedImage mergeWithOriginal(BufferedImage original, BufferedImage processedGray) {
        int w = original.getWidth();
        int h = original.getHeight();
        BufferedImage result = new BufferedImage(w, h, 1);
        for (int y = 0; y < h; ++y) {
            for (int x = 0; x < w; ++x) {
                Color orig = new Color(original.getRGB(x, y));
                int grayVal = new Color(processedGray.getRGB(x, y)).getRed();
                int r = (int)(0.8 * (double)orig.getRed() + 0.2 * (double)grayVal);
                int g = (int)(0.8 * (double)orig.getGreen() + 0.2 * (double)grayVal);
                int b = (int)(0.8 * (double)orig.getBlue() + 0.2 * (double)grayVal);
                Color combined = new Color(ImageEnhancer.clamp(r), ImageEnhancer.clamp(g), ImageEnhancer.clamp(b));
                result.setRGB(x, y, combined.getRGB());
            }
        }
        return result;
    }

    private static int clamp(int val) {
        return Math.max(0, Math.min(255, val));
    }
}

