/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.ecs.utils;

import cn.hutool.core.img.ImgUtil;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.config.ConfigValueUtil;
import com.bringspring.common.model.UploaderVO;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.FilePathUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.Md5Util;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UpUtil;
import com.bringspring.common.util.UploaderUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.common.util.file.UploadUtil;
import com.bringspring.files.entity.FileEntity;
import com.bringspring.files.mapper.FileMapper;
import com.bringspring.files.utils.YozoUtils;
import com.bringspring.system.base.util.OptimizeUtil;
import java.awt.Image;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class UploadFiles {
    @Autowired
    private ConfigValueUtil configValueUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private YozoUtils yozoUtils;
    @Autowired
    private FileMapper fileMapper;

    public UploaderVO uploader(MultipartFile file, String modular, String type) {
        try {
            String fileType = UpUtil.getFileType((MultipartFile)file);
            if (!OptimizeUtil.fileType((String)this.configValueUtil.getAllowUploadFileType(), (String)fileType)) {
                // empty if block
            }
            UploaderVO vo = this.uploaderVO(file, type, modular, file.getOriginalFilename());
            return vo;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UploaderVO uploaderVO(MultipartFile file, String type, String modular, String orgFileName) throws IOException {
        String[] arr;
        String fileType = UpUtil.getFileType((MultipartFile)file);
        String fileName = DateUtil.dateNow((String)"yyyyMMdd") + "_" + RandomUtil.uuId() + "." + fileType;
        byte[] bytes = null;
        try {
            bytes = file.getBytes();
        }
        catch (Exception exception) {
            // empty catch block
        }
        String bucketName = type.toLowerCase();
        String filePath = FilePathUtil.getFilePath((String)bucketName);
        if (StringUtils.isNotEmpty((String)filePath) && (arr = filePath.split("/|\\\\")).length > 0) {
            bucketName = arr[arr.length - 1];
        }
        String secondFilePath = DateUtil.dateNow((String)"yyyy/MM/dd/") + modular + "/";
        UploaderVO vo = UploaderVO.builder().name(fileName).secondFilePath(secondFilePath).build();
        String fileType1 = this.configValueUtil.getFileType();
        vo.setFileDigest(Md5Util.getMd5((MultipartFile)file));
        UploadUtil.uploadFile((String)fileType1, (String)bucketName, (String)fileName, (MultipartFile)file, (String)filePath, (String)secondFilePath);
        String apiUrl = "/api/file/Image/" + type + "/" + secondFilePath;
        vo.setUrl(UploaderUtil.uploaderImg((String)apiUrl, (String)fileName));
        UserInfo userInfo = this.userProvider.get();
        FileEntity fe = new FileEntity();
        String fileId = IdWorker.getIdStr();
        fe.setFileId(fileId);
        fe.setUrl(vo.getUrl());
        fe.setFileType(type);
        fe.setSecondFilePath(secondFilePath);
        fe.setEngine(fileType1);
        fe.setBucket(bucketName);
        fe.setCreatorUserId(userInfo.getUserId());
        fe.setFileName(orgFileName);
        fe.setObjName(fileName);
        fe.setSuffix(fileType);
        fe.setSizeInfo(FileUtil.readableFileSize((long)file.getSize()));
        fe.setStoragePath(filePath + secondFilePath + "/" + fileName);
        fe.setFileDigest(vo.getFileDigest());
        fe.setModular(modular);
        if (ObjectUtil.isNotEmpty((Object)fileType) && UploadFiles.isPic(fileType)) {
            try {
                fe.setThumbnail(ImgUtil.toBase64DataUri((Image)ImgUtil.scale((Image)ImgUtil.toImage((byte[])bytes), (int)100, (int)100, null), (String)fileType));
            }
            catch (Exception ignored) {
                ignored.printStackTrace();
            }
        }
        this.fileMapper.insert((Object)fe);
        if ("yozo".equals(this.configValueUtil.getAllowPreviewFileType())) {
            try {
                InputStream inputStream = file.getInputStream();
                try {
                    String s = this.yozoUtils.uploadFileInPreview(inputStream, orgFileName);
                    Map map = JsonUtil.stringToMap((String)s);
                    if ("\u64cd\u4f5c\u6210\u529f".equals(map.get("message"))) {
                        Map dataMap = JsonUtil.stringToMap((String)String.valueOf(map.get("data")));
                        String verId = String.valueOf(dataMap.get("fileVersionId"));
                        vo.setFileVersionId(verId);
                    }
                }
                finally {
                    if (Collections.singletonList(inputStream).get(0) != null) {
                        inputStream.close();
                    }
                }
            }
            catch (Exception e) {
                System.out.println("\u4e0a\u4f20\u5230\u6c38\u4e2d\u5931\u8d25");
                e.printStackTrace();
            }
        }
        return vo;
    }

    private static boolean isPic(String fileSuffix) {
        return "gif".equals(fileSuffix = fileSuffix.toLowerCase()) || "jpg".equals(fileSuffix) || "jpeg".equals(fileSuffix) || "bmp".equals(fileSuffix) || "png".equals(fileSuffix) || "psd".equals(fileSuffix);
    }
}

