/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.dynamic.datasource.spring.boot.autoconfigure;

import cn.beecp.BeeDataSource;
import com.alibaba.druid.pool.DruidDataSource;
import com.baomidou.dynamic.datasource.creator.BasicDataSourceCreator;
import com.baomidou.dynamic.datasource.creator.BeeCpDataSourceCreator;
import com.baomidou.dynamic.datasource.creator.DataSourceCreator;
import com.baomidou.dynamic.datasource.creator.Dbcp2DataSourceCreator;
import com.baomidou.dynamic.datasource.creator.DefaultDataSourceCreator;
import com.baomidou.dynamic.datasource.creator.DruidDataSourceCreator;
import com.baomidou.dynamic.datasource.creator.HikariDataSourceCreator;
import com.baomidou.dynamic.datasource.creator.JndiDataSourceCreator;
import com.zaxxer.hikari.HikariDataSource;
import java.util.List;
import org.apache.commons.dbcp2.BasicDataSource;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.core.annotation.Order;

@Configuration
public class DynamicDataSourceCreatorAutoConfiguration {
    public static final int JNDI_ORDER = 1000;
    public static final int DRUID_ORDER = 2000;
    public static final int HIKARI_ORDER = 3000;
    public static final int BEECP_ORDER = 4000;
    public static final int DBCP2_ORDER = 5000;
    public static final int DEFAULT_ORDER = 6000;

    @Primary
    @Bean
    @ConditionalOnMissingBean
    public DefaultDataSourceCreator dataSourceCreator(List<DataSourceCreator> dataSourceCreators) {
        DefaultDataSourceCreator defaultDataSourceCreator = new DefaultDataSourceCreator();
        defaultDataSourceCreator.setCreators(dataSourceCreators);
        return defaultDataSourceCreator;
    }

    @Bean
    @Order(value=6000)
    public BasicDataSourceCreator basicDataSourceCreator() {
        return new BasicDataSourceCreator();
    }

    @Bean
    @Order(value=1000)
    public JndiDataSourceCreator jndiDataSourceCreator() {
        return new JndiDataSourceCreator();
    }

    @ConditionalOnClass(value={BasicDataSource.class})
    @Configuration
    static class Dbcp2DataSourceCreatorConfiguration {
        Dbcp2DataSourceCreatorConfiguration() {
        }

        @Bean
        @Order(value=5000)
        public Dbcp2DataSourceCreator dbcp2DataSourceCreator() {
            return new Dbcp2DataSourceCreator();
        }
    }

    @ConditionalOnClass(value={BeeDataSource.class})
    @Configuration
    static class BeeCpDataSourceCreatorConfiguration {
        BeeCpDataSourceCreatorConfiguration() {
        }

        @Bean
        @Order(value=4000)
        public BeeCpDataSourceCreator beeCpDataSourceCreator() {
            return new BeeCpDataSourceCreator();
        }
    }

    @ConditionalOnClass(value={HikariDataSource.class})
    @Configuration
    static class HikariDataSourceCreatorConfiguration {
        HikariDataSourceCreatorConfiguration() {
        }

        @Bean
        @Order(value=3000)
        public HikariDataSourceCreator hikariDataSourceCreator() {
            return new HikariDataSourceCreator();
        }
    }

    @ConditionalOnClass(value={DruidDataSource.class})
    @Configuration
    static class DruidDataSourceCreatorConfiguration {
        DruidDataSourceCreatorConfiguration() {
        }

        @Bean
        @Order(value=2000)
        public DruidDataSourceCreator druidDataSourceCreator() {
            return new DruidDataSourceCreator();
        }
    }
}

