/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.cp.tp.service.impl;

import com.google.gson.JsonObject;
import java.util.Date;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.cp.bean.order.WxCpTpOrderDetails;
import me.chanjar.weixin.cp.bean.order.WxCpTpOrderListGetResult;
import me.chanjar.weixin.cp.tp.service.WxCpTpOrderService;
import me.chanjar.weixin.cp.tp.service.WxCpTpService;

public class WxCpTpOrderServiceImpl
implements WxCpTpOrderService {
    private final WxCpTpService mainService;

    @Override
    public WxCpTpOrderDetails getOrder(String orderId) throws WxErrorException {
        String url = this.mainService.getWxCpTpConfigStorage().getApiUrl("/cgi-bin/service/get_order");
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("orderid", orderId);
        String result = this.mainService.post(url, jsonObject.toString());
        return WxCpTpOrderDetails.fromJson(result);
    }

    @Override
    public WxCpTpOrderListGetResult getOrderList(Date startTime, Date endTime, Integer testMode) throws WxErrorException {
        String url = this.mainService.getWxCpTpConfigStorage().getApiUrl("/cgi-bin/service/get_order_list");
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("start_time", (Number)(startTime.getTime() / 1000L));
        jsonObject.addProperty("end_time", (Number)(endTime.getTime() / 1000L));
        jsonObject.addProperty("test_mode", (Number)testMode);
        String result = this.mainService.post(url, jsonObject.toString());
        return WxCpTpOrderListGetResult.fromJson(result);
    }

    public WxCpTpOrderServiceImpl(WxCpTpService mainService) {
        this.mainService = mainService;
    }
}

