/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.attendance.service.impl;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import com.bringspring.attendance.model.approvemodel.SpNoQuery;
import com.bringspring.attendance.model.hrmspushcard.PushCardVo;
import com.bringspring.attendance.service.PushCardService;
import com.bringspring.attendance.utils.QiWeiParametersUtil;
import com.bringspring.attendance.utils.SendRequest;
import com.bringspring.hrms.util.OaConstants;
import com.bringspring.visit.utils.DateUtil;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class PushCardServiceImpl
implements PushCardService {
    private Logger logger = LoggerFactory.getLogger(PushCardServiceImpl.class);

    @Override
    public void listPushCardData() {
        try {
            String accessToken = QiWeiParametersUtil.getPushCardAccessToken();
            String approveAccessToken = QiWeiParametersUtil.getApproveAccessToken();
            PushCardVo vo = new PushCardVo();
            vo.setOpencheckindatatype(3);
            vo.setStarttime(DateUtil.dateAddDays((Date)DateUtil.getDayBegin(), (int)-3).getTime() / 1000L);
            vo.setEndtime(DateUtil.getDayEnd().getTime() / 1000L);
            ArrayList<String> userList = new ArrayList<String>();
            userList.add("13137188721");
            userList.add("13526655676");
            vo.setUseridlist(userList);
            String jsonStr = JSONObject.toJSONString((Object)vo);
            String url = QiWeiParametersUtil.getPushCardUrl.replace("ACCESS_TOKEN", accessToken);
            String approveUrl = QiWeiParametersUtil.getApproveUrl.replace("ACCESS_TOKEN", approveAccessToken);
            JSONObject jsonObject = SendRequest.sendPost(url, jsonStr);
            JSONObject approveJsonObject = SendRequest.sendPost(approveUrl, jsonStr);
            List list = (List)jsonObject.get((Object)"checkindata");
            for (Object o : list) {
                Map dataMap = (Map)o;
                System.out.println("wifi\u7684\u540d\u5b57\u4e3a\uff1a----" + dataMap.get("wifiname"));
                System.out.println("\u7528\u6237id\uff1a----" + dataMap.get("userid"));
                System.out.println("\u5730\u5740\u8be6\u60c5\uff1a----" + dataMap.get("location_detail"));
                System.out.println("\u6253\u5361\u7c7b\u578b\uff1a----" + dataMap.get("checkin_type"));
            }
        }
        catch (Exception e) {
            this.logger.error("\u83b7\u53d6\u6253\u5361\u8bb0\u5f55\u6570\u636e\u5931\u8d25", (Throwable)e);
        }
    }

    @Override
    public void pullApproveData() {
        try {
            String approveAccessToken = QiWeiParametersUtil.getApproveAccessToken();
            SpNoQuery vo = new SpNoQuery();
            vo.setSize(100);
            vo.setStarttime(String.valueOf(DateUtil.dateAddDays((Date)DateUtil.getDayBegin(), (int)-3).getTime() / 1000L));
            vo.setEndtime(String.valueOf(DateUtil.getDayEnd().getTime() / 1000L));
            vo.setNew_cursor("");
            String approveUrl = QiWeiParametersUtil.getApproveUrl.replace("ACCESS_TOKEN", approveAccessToken);
            ArrayList<String> objects = new ArrayList<String>();
            List<String> result = this.cyclePullApproveData(approveUrl, vo, objects);
            for (int i = 0; i < result.size(); ++i) {
                HashMap<String, String> json2 = new HashMap<String, String>();
                json2.put("sp_no", result.get(i));
                JSONObject json3 = new JSONObject(json2);
                String s2 = json3.toString();
                String approveInfoUrl = QiWeiParametersUtil.getApproveDetailUrl.replace("ACCESS_TOKEN", approveAccessToken);
                String jsonStr = JSONObject.toJSONString(json2);
                JSONObject jSONObject = SendRequest.sendPost(approveInfoUrl, jsonStr);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void pullHolidayData(Map<String, String> paramMap) {
        try {
            String approveAccessToken = QiWeiParametersUtil.getApproveAccessToken();
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("userid", paramMap.get("userid"));
            String jsonStr = JSONObject.toJSONString(map);
            String approveUrl = QiWeiParametersUtil.getHolidayBalance.replace("ACCESS_TOKEN", approveAccessToken);
            String updateHpliday = QiWeiParametersUtil.updateHolidayBalance.replace("ACCESS_TOKEN", approveAccessToken);
            JSONObject jsonObject = SendRequest.sendPost(approveUrl, jsonStr);
            List holidayList = (List)jsonObject.get((Object)"lists");
            Iterator iterator = holidayList.iterator();
            while (iterator.hasNext()) {
                ObjectMapper objectMapper = new ObjectMapper();
                Object object = iterator.next();
                Map map2 = (Map)objectMapper.convertValue(object, Map.class);
                if (!map2.get("vacationname").equals("\u6d4b\u8bd5\u5e74\u5047")) continue;
                HashMap<String, Object> map1 = new HashMap<String, Object>();
                map1.put("userid", paramMap.get("userid"));
                map1.put("vacation_id", map2.get("id"));
                map1.put("leftduration", Long.valueOf(paramMap.get("leftduration")));
                map1.put("time_attr", Integer.valueOf(paramMap.get("timeAttr")));
                map1.put("remarks", "\u63cf\u8ff0");
                String mapStr = JSONObject.toJSONString(map1);
                JSONObject jSONObject = SendRequest.sendPost(updateHpliday, mapStr);
            }
        }
        catch (Exception e) {
            this.logger.error("\u83b7\u53d6\u6253\u5361\u8bb0\u5f55\u6570\u636e\u5931\u8d25", (Throwable)e);
        }
    }

    @Override
    public List<String> cyclePullApproveData(String approveUrl, SpNoQuery vo, List<String> resultList) {
        try {
            SpNoQuery newVo = new SpNoQuery();
            String jsonStr = JSONObject.toJSONString((Object)vo);
            JSONObject approveJsonObject = SendRequest.sendPost(approveUrl, jsonStr);
            List spNoList = (List)approveJsonObject.get((Object)"sp_no_list");
            resultList.addAll(spNoList);
            if (!ObjectUtil.isNotEmpty((Object)approveJsonObject.get((Object)"new_next_cursor"))) {
                return resultList;
            }
            vo.setNew_cursor(String.valueOf(approveJsonObject.get((Object)"new_next_cursor")));
            this.cyclePullApproveData(approveUrl, vo, resultList);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return resultList;
    }

    @Override
    public Integer updateQiWeiHolidayBalance(HashMap<String, String> paramMap) {
        Integer counter = Integer.valueOf(paramMap.get("counter"));
        String companyId = paramMap.get("companyId");
        try {
            String approveAccessToken = paramMap.get("approveAccessToken");
            if (StrUtil.isBlank((CharSequence)approveAccessToken)) {
                return 0;
            }
            List<Map<String, Object>> holidayList = this.getHolidayList(approveAccessToken, paramMap.get("userid"));
            for (Map<String, Object> holiday : holidayList) {
                Integer n;
                Integer n2;
                String vacationname = (String)holiday.get("vacationname");
                if (vacationname.equals(OaConstants.HOLIDAY_TYPE_NIANJIA)) {
                    n2 = counter;
                    n = counter = Integer.valueOf(counter + 1);
                    this.updateHoliday(holiday, paramMap, "leftdurationNj", "timeAttrNj", 86400.0f);
                    continue;
                }
                if (vacationname.equals(OaConstants.HOLIDAY_TYPE_TIAOXIU)) {
                    n2 = counter;
                    n = counter = Integer.valueOf(counter + 1);
                    this.updateHoliday(holiday, paramMap, "leftdurationTxj", "timeAttrTxj", 86400.0f);
                    continue;
                }
                if (!vacationname.equals(OaConstants.HOLIDAY_TYPE_TIAOXIUMJ)) continue;
                n2 = counter;
                n = counter = Integer.valueOf(counter + 1);
                this.updateHoliday(holiday, paramMap, "leftdurationTxj", "timeAttrTxj", 3600.0f);
            }
        }
        catch (Exception e) {
            this.logger.error("\u66f4\u65b0\u5e74\u5047\u4f59\u989d\u5931\u8d25", (Throwable)e);
        }
        return counter;
    }

    private List<Map<String, Object>> getHolidayList(String approveAccessToken, String userid) throws IOException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("userid", userid);
        String jsonStr = JSONObject.toJSONString(map);
        String approveUrl = QiWeiParametersUtil.getHolidayBalance.replace("ACCESS_TOKEN", approveAccessToken);
        JSONObject jsonObject = SendRequest.sendPost(approveUrl, jsonStr);
        this.logger.error("\u83b7\u53d6\u5047\u671f\u6570\u636e\u8be6\u60c5");
        return (List)jsonObject.get((Object)"lists");
    }

    private void updateHoliday(Map<String, Object> holiday, HashMap<String, String> paramMap, String durationKey, String attrKey, float multiplier) throws IOException {
        String userid = paramMap.get("userid");
        String updateHolidayUrl = QiWeiParametersUtil.updateHolidayBalance.replace("ACCESS_TOKEN", paramMap.get("approveAccessToken"));
        HashMap<String, Object> map1 = new HashMap<String, Object>();
        map1.put("userid", userid);
        map1.put("vacation_id", holiday.get("id"));
        map1.put("leftduration", Float.valueOf(Float.valueOf(paramMap.get(durationKey)).floatValue() * multiplier));
        map1.put("time_attr", paramMap.get(attrKey));
        map1.put("remarks", "\u6bcf\u65e5\u63a5\u53e3\u81ea\u52a8\u540c\u6b65\u6267\u884c\u00b7\u00b7\u00b7");
        String mapStr = JSONObject.toJSONString(map1);
        SendRequest.sendPost(updateHolidayUrl, mapStr);
    }
}

