/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.document.controller;

import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.bringspring.common.annotation.NotCheckLogin;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.NoDataSourceBind;
import com.bringspring.common.base.Page;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.DownloadVO;
import com.bringspring.common.base.vo.ListVO;
import com.bringspring.common.config.ConfigValueUtil;
import com.bringspring.common.constant.MsgCode;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.FilePathUtil;
import com.bringspring.common.util.FileUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UpUtil;
import com.bringspring.common.util.UploaderUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.common.util.XSSEscape;
import com.bringspring.common.util.file.UploadUtil;
import com.bringspring.common.util.treeutil.newtreeutil.TreeDotUtils;
import com.bringspring.crm.entity.CrmProductEntity;
import com.bringspring.crm.service.CrmProductService;
import com.bringspring.document.entity.DocumentTrendsEntity;
import com.bringspring.document.model.document.DocumentCrForm;
import com.bringspring.document.model.document.DocumentFolderTreeModel;
import com.bringspring.document.model.document.DocumentFolderTreeVO;
import com.bringspring.document.model.document.DocumentInfoVO;
import com.bringspring.document.model.document.DocumentListVO;
import com.bringspring.document.model.document.DocumentShareForm;
import com.bringspring.document.model.document.DocumentShareUserListVO;
import com.bringspring.document.model.document.DocumentSoutListVO;
import com.bringspring.document.model.document.DocumentStomeListVO;
import com.bringspring.document.model.document.DocumentUpForm;
import com.bringspring.document.model.document.DocumentUploader;
import com.bringspring.document.model.document.PageDocument;
import com.bringspring.document.service.DocumentHistoryService;
import com.bringspring.document.service.DocumentService;
import com.bringspring.document.service.DocumentShareService;
import com.bringspring.document.service.DocumentTrendsService;
import com.bringspring.document.util.DocumentEnum;
import com.bringspring.extend.entity.DocumentEntity;
import com.bringspring.extend.entity.DocumentHistoryEntity;
import com.bringspring.extend.entity.DocumentShareEntity;
import com.bringspring.extend.utils.CommonUtil;
import com.bringspring.files.model.MergeChunkDto;
import com.bringspring.system.base.util.JsonUtilEx;
import com.bringspring.system.base.util.OptimizeUtil;
import com.bringspring.system.permission.entity.OrganizeEntity;
import com.bringspring.system.permission.entity.UserEntity;
import com.bringspring.system.permission.service.OrganizeService;
import com.bringspring.system.permission.service.UserService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.validation.Valid;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@Api(tags={"\u77e5\u8bc6\u7ba1\u7406"}, value="document/Document")
@RestController
@RequestMapping(value={"/api/document/Document"})
public class DocumentFileController {
    private static final Logger log = LoggerFactory.getLogger(DocumentFileController.class);
    @Autowired
    private DocumentService documentService;
    @Autowired
    private ConfigValueUtil configValueUtil;
    @Autowired
    private UserService userService;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private DocumentHistoryService documentHistoryService;
    @Autowired
    private DocumentShareService documentShareService;
    @Autowired
    private OrganizeService organizeService;
    @Autowired
    private CrmProductService crmProductService;
    @Autowired
    private DocumentTrendsService documentTrendsService;

    @ApiOperation(value="\u83b7\u53d6\u6587\u4ef6/\u6587\u4ef6\u5939\u4fe1\u606f")
    @GetMapping(value={"/{id}"})
    public ActionResult<DocumentInfoVO> info(@PathVariable(value="id") String id) throws DataException {
        CrmProductEntity product;
        DocumentEntity entity = this.documentService.getInfo(id);
        DocumentInfoVO vo = (DocumentInfoVO)JsonUtilEx.getJsonToBeanEx((Object)entity, DocumentInfoVO.class);
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(DocumentTrendsEntity::getDocumentId, (Object)id);
        queryWrapper.lambda().orderByDesc(DocumentTrendsEntity::getExecDate);
        List documentTrendsList = this.documentTrendsService.list((Wrapper)queryWrapper);
        if (ObjectUtil.isNotEmpty((Object)documentTrendsList)) {
            Map<String, DocumentEnum> allToMap = DocumentEnum.getAllToMap();
            Iterator iterator = documentTrendsList.iterator();
            while (iterator.hasNext()) {
                DocumentTrendsEntity trends;
                trends.setNodeType(StringUtils.isEmpty((String)(trends = (DocumentTrendsEntity)iterator.next()).getNodeType()) ? "" : allToMap.get(trends.getNodeType()).getDesc());
            }
        }
        vo.setDocumentTrendsEntityList(documentTrendsList);
        OrganizeEntity org = this.organizeService.getInfo(vo.getCompanyId());
        if (ObjectUtil.isNotEmpty((Object)org)) {
            vo.setCompanyName(org.getFullName());
        }
        if (ObjectUtil.isNotEmpty((Object)(product = this.crmProductService.getInfo(entity.getAssociationProduct())))) {
            vo.setAssociationProductName(product.getProductName());
        }
        vo.setCreatorUserName(this.userService.getInfo(vo.getCreatorUserId()).getRealName());
        String[] fullName = vo.getFullName().split("\\.");
        if (fullName.length > 1) {
            String fullNames = "";
            for (int i = 0; i < fullName.length - 1; ++i) {
                fullNames = i > 0 ? fullNames + "." + fullName[i] : fullNames + fullName[i];
            }
            vo.setFullName(fullNames);
        }
        return ActionResult.success((Object)vo);
    }

    @ApiOperation(value="\u6dfb\u52a0\u6587\u4ef6\u5939")
    @PostMapping
    public ActionResult create(@RequestBody @Valid DocumentCrForm documentCrForm) {
        UserInfo userInfo = this.userProvider.get();
        DocumentEntity entity = (DocumentEntity)JsonUtil.getJsonToBean((Object)documentCrForm, DocumentEntity.class);
        if ("0".equals(entity.getParentId())) {
            entity.setFilePath(userInfo.getUserId() + File.separator + DateUtil.getNowYear() + File.separator + entity.getFullName());
        } else {
            String absoluteRouteById = this.documentService.getAbsoluteRouteById(entity.getParentId());
            absoluteRouteById = absoluteRouteById + entity.getFullName();
            entity.setFilePath(absoluteRouteById.substring(this.configValueUtil.getDocumentFilePath().length()));
        }
        if (this.documentService.isExistByFullName(entity)) {
            return ActionResult.fail((String)MsgCode.EXIST004.get());
        }
        entity.setCompanyId(userInfo.getOrganizeId());
        entity.setIsPublic("0");
        this.documentService.create(entity);
        return ActionResult.success((String)MsgCode.SU001.get());
    }

    @ApiOperation(value="\u4fee\u6539\u6587\u4ef6\u540d/\u6587\u4ef6\u5939\u540d")
    @PutMapping(value={"/{id}"})
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid DocumentUpForm documentUpForm) {
        documentUpForm.setFilePath(null);
        DocumentEntity entity = (DocumentEntity)JsonUtil.getJsonToBean((Object)documentUpForm, DocumentEntity.class);
        if (this.documentService.isExistByFullName(entity)) {
            return ActionResult.fail((String)MsgCode.EXIST004.get());
        }
        DocumentEntity info = this.documentService.getInfo(id);
        String[] fullName = info.getFullName().split("\\.");
        if (fullName.length > 1) {
            entity.setFullName(entity.getFullName() + "." + fullName[fullName.length - 1]);
        }
        if (0 == info.getType() && StringUtils.isNotEmpty((String)info.getFilePath())) {
            String source = info.getFilePath();
            String target = info.getFullName();
            int lastIndex = source.lastIndexOf(target);
            String result = source.substring(0, lastIndex) + documentUpForm.getFullName() + source.substring(lastIndex + target.length());
            entity.setFilePath(result);
            UserInfo userInfo = this.userProvider.get();
        }
        boolean flag = this.documentService.update(id, entity);
        if (1 == info.getType()) {
            UserInfo userInfo = this.userProvider.get();
            DocumentTrendsEntity trends = new DocumentTrendsEntity();
            trends.setId(RandomUtil.uuId());
            trends.setDocumentId(entity.getId());
            trends.setUserId(userInfo.getUserId());
            trends.setUserName(userInfo.getUserName());
            trends.setCompanyId(userInfo.getOrganizeId());
            trends.setExecDate(new Date());
            trends.setCreatorTime(new Date());
            trends.setCreatorUserId(userInfo.getUserId());
            if (StringUtils.isNotEmpty((String)entity.getIsPublic()) && !entity.getIsPublic().equals(info.getIsPublic())) {
                trends.setNodeType(DocumentEnum.DOUCUMENT_AUTHORITY.getType());
                trends.setOldData(info.getIsPublic());
                trends.setNewData(entity.getIsPublic());
            }
            if (!info.getFullName().equals(entity.getFullName())) {
                trends.setNodeType(DocumentEnum.DOUCUMENT_RENAME.getType());
                trends.setOldData(info.getFullName());
                trends.setNewData(entity.getFullName());
            }
            this.documentTrendsService.create(trends);
        }
        if (!flag) {
            return ActionResult.fail((String)MsgCode.FA002.get());
        }
        return ActionResult.success((String)MsgCode.SU004.get());
    }

    public void getChildNodes(String parentId, String oldPath, String newPath) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(DocumentEntity::getParentId, (Object)parentId);
        List nodes = this.documentService.list((Wrapper)queryWrapper);
        for (DocumentEntity node : nodes) {
            DocumentEntity entity = new DocumentEntity();
            entity.setId(node.getId());
            entity.setFilePath(node.getFilePath().replace(oldPath, newPath));
            this.documentService.update(node.getId(), entity);
            this.getChildNodes(node.getId(), oldPath, newPath);
        }
    }

    @ApiOperation(value="\u5220\u9664\u77e5\u8bc6\u7ba1\u7406")
    @DeleteMapping(value={"/{id}"})
    public ActionResult delete(@PathVariable(value="id") String id) {
        DocumentEntity entity = this.documentService.getInfo(id);
        if (entity != null) {
            List<DocumentEntity> allList = this.documentService.getAllList(entity.getId(), "");
            if (allList.size() > 0) {
                return ActionResult.fail((String)MsgCode.FA016.get());
            }
            if (entity.getIsShare() != null && 0 != entity.getIsShare()) {
                entity.setIsShare(Integer.valueOf(0));
                this.documentService.updateById(entity);
            }
            UserInfo userInfo = this.userProvider.get();
            DocumentTrendsEntity trends = new DocumentTrendsEntity();
            trends.setId(RandomUtil.uuId());
            trends.setDocumentId(entity.getId());
            trends.setNodeType(DocumentEnum.DOUCUMENT_DELETE.getType());
            trends.setUserId(userInfo.getUserId());
            trends.setUserName(userInfo.getUserName());
            trends.setCompanyId(userInfo.getOrganizeId());
            trends.setExecDate(new Date());
            trends.setCreatorTime(new Date());
            trends.setCreatorUserId(userInfo.getUserId());
            this.documentTrendsService.create(trends);
            this.documentService.delete(entity);
            return ActionResult.success((String)MsgCode.SU003.get());
        }
        return ActionResult.fail((String)MsgCode.FA003.get());
    }

    @ApiOperation(value="\u83b7\u53d6\u77e5\u8bc6\u7ba1\u7406\u5217\u8868\uff08\u6587\u4ef6\u5939\u6811\uff09")
    @GetMapping(value={"/FolderTree/{id}"})
    public ActionResult<ListVO<DocumentFolderTreeVO>> folderTree(@PathVariable(value="id") String id) {
        List<DocumentEntity> data = this.documentService.getFolderList();
        if (!"0".equals(id)) {
            data.remove(this.documentService.getInfo(id));
        }
        ArrayList<DocumentFolderTreeModel> treeList = new ArrayList<DocumentFolderTreeModel>();
        DocumentFolderTreeModel model = new DocumentFolderTreeModel();
        model.setId("-1");
        model.setFullName("\u5168\u90e8\u6587\u6863");
        model.setParentId("0");
        model.setIcon("0");
        treeList.add(model);
        for (DocumentEntity entity : data) {
            DocumentFolderTreeModel treeModel = new DocumentFolderTreeModel();
            treeModel.setId(entity.getId());
            treeModel.setFullName(entity.getFullName());
            treeModel.setParentId(entity.getParentId());
            treeModel.setIcon("fa fa-folder");
            treeList.add(treeModel);
        }
        List trees = TreeDotUtils.convertListToTreeDotFilter(treeList);
        List listVO = JsonUtil.getJsonToList((Object)trees, DocumentFolderTreeVO.class);
        ListVO vo = new ListVO();
        vo.setList(listVO);
        return ActionResult.success((Object)vo);
    }

    @ApiOperation(value="\u83b7\u53d6\u77e5\u8bc6\u7ba1\u7406\u5217\u8868\uff08\u5168\u90e8\u6587\u6863\uff09")
    @GetMapping
    public ActionResult<ListVO<DocumentListVO>> allList(PageDocument page) {
        List listReturn;
        List list;
        String fileLable;
        List<DocumentEntity> data = this.documentService.getAllList(page.getParentId(), page.getIsPublic());
        List<DocumentEntity> allData = this.documentService.getFolderList();
        for (DocumentEntity dd : data) {
            dd.setFilePath(this.getFilePath(dd, allData, ""));
        }
        List<Object> returnList = new ArrayList();
        if (!StringUtils.isEmpty((String)page.getKeyword())) {
            page.setType(1);
            page.setParentId(null);
            returnList = this.documentService.getAllList(page);
            returnList = returnList.stream().filter(t -> t.getFullName().contains(page.getKeyword())).collect(Collectors.toList());
        }
        if (ObjectUtil.isNotEmpty((Object)((Object)page)) && StringUtils.isNotEmpty((String)(fileLable = page.getFileLable()))) {
            page.setType(1);
            page.setParentId(null);
            List<Object> listLable = ObjectUtil.isEmpty(returnList) ? this.documentService.getAllList(page) : returnList;
            String[] aa = fileLable.split(",");
            for (String lable : aa) {
                List ff = listLable.stream().filter(t -> ObjectUtil.isNotEmpty((Object)t.getFileLable()) && t.getFileLable().contains(lable)).collect(Collectors.toList());
                returnList.addAll(ff);
            }
        }
        if (ObjectUtil.isNotEmpty((Object)((Object)page)) && StringUtils.isEmpty((String)page.getKeyword()) && StringUtils.isEmpty((String)page.getFileLable())) {
            returnList = data;
        }
        if (ObjectUtil.isNotEmpty((Object)(list = JsonUtil.getJsonToList(listReturn = returnList.stream().collect(Collectors.toMap(DocumentEntity::getId, person -> person, (p1, p2) -> p1)).values().stream().collect(Collectors.toList()), DocumentListVO.class)))) {
            List userList = this.userService.getList();
            block2: for (DocumentListVO documentListVO : list) {
                if (documentListVO.getType() == 1) {
                    List<DocumentHistoryEntity> listByOriginalFileId = this.documentHistoryService.getListByOriginalFileId(documentListVO.getId());
                    documentListVO.setDocumentHistory(listByOriginalFileId);
                }
                for (UserEntity user : userList) {
                    if (!user.getId().equals(documentListVO.getCreatorUserId())) continue;
                    documentListVO.setCreatorUserName(user.getRealName());
                    continue block2;
                }
            }
        }
        ListVO vo = new ListVO();
        vo.setList(list);
        return ActionResult.success((Object)vo);
    }

    String getFilePath(DocumentEntity doc, List<DocumentEntity> list, String filePath) {
        for (DocumentEntity dd : list) {
            if (!dd.getId().equals(doc.getParentId())) continue;
            filePath = dd.getFullName() + "\\" + filePath;
            if ("0".equals(dd.getParentId())) {
                return filePath;
            }
            filePath = this.getFilePath(dd, list, filePath);
            break;
        }
        return filePath;
    }

    @ApiOperation(value="\u77e5\u8bc6\u7ba1\u7406\uff08\u6211\u7684\u5171\u4eab\u5217\u8868\uff09")
    @GetMapping(value={"/Share"})
    public ActionResult<ListVO<DocumentSoutListVO>> shareOutList(Page page) {
        List<Object> data = this.documentService.getShareOutList();
        if (!StringUtils.isEmpty((String)page.getKeyword())) {
            data = data.stream().filter(t -> t.getFullName().contains(page.getKeyword())).collect(Collectors.toList());
        }
        ListVO vo = new ListVO();
        vo.setList(data);
        return ActionResult.success((Object)vo);
    }

    @ApiOperation(value="\u83b7\u53d6\u77e5\u8bc6\u7ba1\u7406\u5217\u8868\uff08\u5171\u4eab\u7ed9\u6211\uff09")
    @GetMapping(value={"/ShareTome"})
    public ActionResult<ListVO<DocumentStomeListVO>> shareTomeList(Page page) {
        List<DocumentEntity> list = this.documentService.getListByShareUserId();
        List vos = JsonUtil.getJsonToList(list, DocumentStomeListVO.class);
        ListVO vo = new ListVO();
        vo.setList(vos);
        return ActionResult.success((Object)vo);
    }

    @ApiOperation(value="\u83b7\u53d6\u77e5\u8bc6\u7ba1\u7406\u5217\u8868\uff08\u56de\u6536\u7ad9\uff09")
    @GetMapping(value={"/Trash"})
    public ActionResult<ListVO<DocumentEntity>> trashList(Page page) {
        List<Object> data = this.documentService.getTrashList();
        if (!StringUtils.isEmpty((String)page.getKeyword())) {
            data = data.stream().filter(t -> t.getFullName().contains(page.getKeyword())).collect(Collectors.toList());
        }
        ListVO vo = new ListVO();
        vo.setList(data);
        return ActionResult.success((Object)vo);
    }

    @ApiOperation(value="\u83b7\u53d6\u77e5\u8bc6\u7ba1\u7406\u5217\u8868\uff08\u5171\u4eab\u4eba\u5458\uff09")
    @GetMapping(value={"/ShareUser/{documentId}"})
    public ActionResult<ListVO<DocumentShareUserListVO>> shareUserList(@PathVariable(value="documentId") String documentId) {
        List<DocumentShareEntity> data = this.documentService.getShareUserList(documentId);
        List list = JsonUtil.getJsonToList(data, DocumentShareUserListVO.class);
        for (DocumentShareUserListVO documentShareUserListVO : list) {
            if (!"1".equals(documentShareUserListVO.getShareType())) continue;
            DocumentShareForm shareEntityById = this.documentService.getShareEntityById(documentShareUserListVO.getId());
            documentShareUserListVO.setShareUserName(shareEntityById.getShareUserName());
        }
        ListVO vo = new ListVO();
        vo.setList(list);
        return ActionResult.success((Object)vo);
    }

    @ApiOperation(value="\u77e5\u8bc6\u7ba1\u7406\u4e0a\u4f20\u6587\u4ef6")
    @PostMapping(value={"/Uploader"})
    public ActionResult uploader(DocumentUploader documentUploader) {
        String fileName = documentUploader.getFile().getOriginalFilename();
        List<Object> data = this.documentService.getAllList(documentUploader.getParentId(), "");
        String finalFileName = fileName;
        if ((data = data.stream().filter(t -> finalFileName.equals(t.getFullName())).collect(Collectors.toList())).size() > 0) {
            fileName = DateUtil.getNow((String)"+8") + "-" + fileName;
        }
        String fileType = UpUtil.getFileType((MultipartFile)documentUploader.getFile());
        String name = RandomUtil.uuId();
        String filePath = this.configValueUtil.getDocumentFilePath();
        if (!OptimizeUtil.fileType((String)this.configValueUtil.getAllowUploadFileType(), (String)fileType)) {
            return ActionResult.fail((String)MsgCode.FA017.get());
        }
        UploadUtil.uploadFile((String)this.configValueUtil.getFileType(), (String)"document", (String)(name + "." + fileType), (MultipartFile)documentUploader.getFile(), (String)filePath);
        DocumentEntity entity = new DocumentEntity();
        entity.setType(Integer.valueOf(1));
        entity.setFullName(fileName);
        entity.setParentId(documentUploader.getParentId());
        entity.setFileExtension(fileType);
        entity.setFilePath(name + "." + fileType);
        entity.setFileSize(String.valueOf(documentUploader.getFile().getSize()));
        entity.setDeleteMark(Integer.valueOf(0));
        this.documentService.create(entity);
        return ActionResult.success((String)MsgCode.SU015.get());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NoDataSourceBind
    @ApiOperation(value="\u5206\u7247\u7ec4\u88c5")
    @PostMapping(value={"/merge"})
    public ActionResult merge(MergeChunkDto mergeChunkDto) {
        String identifier = mergeChunkDto.getIdentifier();
        String path = FilePathUtil.getFilePath((String)"temporary");
        String filePath = XSSEscape.escapePath((String)(path + identifier));
        String partFile = XSSEscape.escapePath((String)(path + mergeChunkDto.getFileName()));
        try {
            List mergeFileList = FileUtil.getFile((File)new File(filePath));
            FileOutputStream destTempfos = new FileOutputStream(partFile, true);
            try {
                for (int i = 0; i < mergeFileList.size(); ++i) {
                    String chunkName = identifier.concat("-") + (i + 1);
                    File files = new File(filePath, chunkName);
                    if (!files.exists()) continue;
                    FileUtils.copyFile((File)files, (OutputStream)destTempfos);
                }
                File partFiles = new File(partFile);
                if (partFiles.exists()) {
                    MultipartFile multipartFile = FileUtil.createFileItem((File)partFiles);
                    this.uploaderVO(multipartFile, mergeChunkDto.getParentId(), mergeChunkDto.getIsPublic());
                    FileUtil.deleteTmp((MultipartFile)multipartFile);
                }
            }
            finally {
                if (Collections.singletonList(destTempfos).get(0) != null) {
                    destTempfos.close();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            FileUtils.deleteQuietly((File)new File(filePath));
            FileUtils.deleteQuietly((File)new File(partFile));
        }
        return ActionResult.success((String)MsgCode.SU015.get());
    }

    @ApiOperation(value="\u83b7\u53d6\u4e0b\u8f7d\u6587\u4ef6\u94fe\u63a5")
    @PostMapping(value={"/Download/{id}"})
    public ActionResult<DownloadVO> download(@PathVariable(value="id") String id) {
        UserInfo userInfo = this.userProvider.get();
        DocumentEntity entity = this.documentService.getInfo(id);
        if (entity != null) {
            String name = entity.getFilePath();
            String fileName = userInfo.getId() + "#" + name + "#document";
            DownloadVO vo = DownloadVO.builder().name(entity.getFullName()).url(UploaderUtil.uploaderFile((String)fileName)).build();
            return ActionResult.success((Object)vo);
        }
        DocumentHistoryEntity info = this.documentHistoryService.getInfo(id);
        if (info != null) {
            String name = info.getFilePath();
            String fileName = userInfo.getId() + "#" + name + "#document#";
            DownloadVO vo = DownloadVO.builder().name(info.getFullName()).url(UploaderUtil.uploaderFile((String)fileName)).build();
            return ActionResult.success((Object)vo);
        }
        return ActionResult.fail((String)MsgCode.FA018.get());
    }

    @ApiOperation(value="\u56de\u6536\u7ad9\uff08\u5f7b\u5e95\u5220\u9664\uff09")
    @DeleteMapping(value={"/Trash/{id}"})
    public ActionResult trashDelete(@PathVariable(value="id") String id) {
        this.documentService.trashDelete(id);
        return ActionResult.success((String)MsgCode.SU003.get());
    }

    @ApiOperation(value="\u56de\u6536\u7ad9\uff08\u8fd8\u539f\u6587\u4ef6\uff09")
    @PostMapping(value={"/Trash/{id}/Actions/Recovery"})
    public ActionResult trashRecovery(@PathVariable(value="id") String id) {
        boolean flag = this.documentService.trashRecovery(id);
        if (!flag) {
            return ActionResult.fail((String)MsgCode.FA010.get());
        }
        return ActionResult.success((String)MsgCode.SU010.get());
    }

    @ApiOperation(value="\u5206\u4eab\u6587\u4ef6/\u6587\u4ef6\u5939")
    @PostMapping(value={"/{id}/Actions/Share"})
    public ActionResult shareCreate(@PathVariable(value="id") String id, @RequestBody DocumentShareForm documentShareForm) {
        if ("2".equals(documentShareForm.getPassword())) {
            documentShareForm.setPassword(CommonUtil.RandomGenerator());
        }
        documentShareForm.setId(id);
        boolean flag = this.documentService.shareCreate(id, documentShareForm);
        UserInfo userInfo = this.userProvider.get();
        DocumentTrendsEntity trends = new DocumentTrendsEntity();
        trends.setId(RandomUtil.uuId());
        trends.setDocumentId(id);
        trends.setNodeType(DocumentEnum.DOUCUMENT_SHARE.getType());
        trends.setUserId(userInfo.getUserId());
        trends.setUserName(userInfo.getUserName());
        trends.setCompanyId(userInfo.getOrganizeId());
        trends.setShareUserId(documentShareForm.getUserId());
        trends.setShareUserName(documentShareForm.getShareUserName());
        trends.setExecDate(new Date());
        trends.setCreatorTime(new Date());
        trends.setCreatorUserId(userInfo.getUserId());
        this.documentTrendsService.create(trends);
        if (!flag) {
            return ActionResult.fail((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u539f\u6587\u4ef6\u4e0d\u5b58\u5728");
        }
        return ActionResult.success((String)MsgCode.SU005.get());
    }

    @ApiOperation(value="\u5206\u4eab\u6587\u4ef6/\u6587\u4ef6\u5939")
    @PostMapping(value={"/{id}/Actions/updateShare"})
    public ActionResult shareUpdate(@PathVariable(value="id") String id, @RequestBody DocumentShareForm documentShareForm) {
        boolean flag = this.documentService.shareUpdate(id, documentShareForm);
        UserInfo userInfo = this.userProvider.get();
        DocumentTrendsEntity trends = new DocumentTrendsEntity();
        trends.setId(RandomUtil.uuId());
        trends.setDocumentId(id);
        trends.setNodeType(DocumentEnum.DOUCUMENT_SHARE.getType());
        trends.setUserId(userInfo.getUserId());
        trends.setUserName(userInfo.getUserName());
        trends.setCompanyId(userInfo.getOrganizeId());
        trends.setShareUserId(documentShareForm.getShareUserId());
        trends.setShareUserName(documentShareForm.getShareUserName());
        trends.setExecDate(new Date());
        trends.setCreatorTime(new Date());
        trends.setCreatorUserId(userInfo.getUserId());
        this.documentTrendsService.create(trends);
        if (!flag) {
            return ActionResult.fail((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u539f\u6587\u4ef6\u4e0d\u5b58\u5728");
        }
        return ActionResult.success((String)MsgCode.SU005.get());
    }

    @ApiOperation(value="\u6839\u636eid\u83b7\u53d6\u6587\u4ef6\u5206\u4eab\u5b9e\u4f53")
    @GetMapping(value={"/getShareEntityById/{id}"})
    @NotCheckLogin
    public ActionResult getShareEntityById(@PathVariable(value="id") String id) {
        DocumentShareForm shareEntityById = this.documentService.getShareEntityById(id);
        return ActionResult.success((Object)shareEntityById);
    }

    @ApiOperation(value="\u53d6\u6d88\u5206\u4eab\u6587\u4ef6/\u6587\u4ef6\u5939")
    @DeleteMapping(value={"/{id}/Actions/Share"})
    public ActionResult shareCancel(@PathVariable(value="id") String id) {
        boolean flag = this.documentService.shareCancel(id);
        if (!flag) {
            return ActionResult.fail((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u539f\u6587\u4ef6\u4e0d\u5b58\u5728");
        }
        return ActionResult.success((String)MsgCode.SU005.get());
    }

    @ApiOperation(value="\u53d6\u6d88\u5206\u4eab\u6587\u4ef6/\u6587\u4ef6\u5939")
    @DeleteMapping(value={"/{id}/Actions/handleDelShareLink"})
    public ActionResult handleDelShareLink(@PathVariable(value="id") String id) {
        boolean flag = this.documentService.handleDelShareLink(id);
        if (!flag) {
            return ActionResult.fail((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u539f\u6587\u4ef6\u4e0d\u5b58\u5728");
        }
        return ActionResult.success((String)MsgCode.SU003.get());
    }

    @ApiOperation(value="\u79fb\u52a8\u6587\u4ef6/\u6587\u4ef6\u5939")
    @PutMapping(value={"/{id}/Actions/MoveTo/{toId}"})
    public ActionResult moveTo(@PathVariable(value="id") String id, @PathVariable(value="toId") String toId) {
        if (id.equals(toId)) {
            return ActionResult.fail((String)"\u4e0d\u80fd\u79fb\u52a8\u5230\u81ea\u5df1\u7684\u6587\u4ef6\u5939");
        }
        boolean flag = this.documentService.moveTo(id, toId);
        if (!flag) {
            return ActionResult.fail((String)MsgCode.FA002.get());
        }
        return ActionResult.success((String)MsgCode.SU004.get());
    }

    private void uploaderVO(MultipartFile file, String parentId, String isPublic) {
        String name;
        UserInfo userInfo = this.userProvider.get();
        String fileType = UpUtil.getFileType((MultipartFile)file);
        String filePath = this.configValueUtil.getDocumentFilePath();
        filePath = filePath + userInfo.getUserId() + File.separator + DateUtil.getNowYear() + File.separator;
        String fPath = name = RandomUtil.uuId();
        if (!"0".equals(parentId)) {
            String absoluteRouteById;
            filePath = absoluteRouteById = this.documentService.getAbsoluteRouteById(parentId);
            fPath = absoluteRouteById.substring(this.configValueUtil.getDocumentFilePath().length()) + name;
        } else {
            fPath = userInfo.getUserId() + File.separator + DateUtil.getNowYear() + File.separator + name;
        }
        String fileName = file.getOriginalFilename();
        List<Object> data = this.documentService.getAllList(parentId, isPublic);
        String finalFileName = fileName;
        data = data.stream().filter(t -> finalFileName.equals(t.getFullName()) && isPublic.equals(t.getIsPublic())).collect(Collectors.toList());
        if (data.size() > 0) {
            this.documentService.removeBatchByIds(data);
        }
        UploadUtil.uploadFile((String)this.configValueUtil.getFileType(), (String)"document", (String)(name + "." + fileType), (MultipartFile)file, (String)filePath);
        DocumentEntity entity = new DocumentEntity();
        if (data.size() > 0) {
            entity.setId(((DocumentEntity)data.get(0)).getId());
            List<DocumentHistoryEntity> listByOriginalFileId = this.documentHistoryService.getListByOriginalFileId(entity.getId());
            entity.setFileVersion("V" + (listByOriginalFileId.size() + 2));
        } else {
            entity.setId(RandomUtil.uuId());
            entity.setFileVersion("V1");
        }
        entity.setType(Integer.valueOf(1));
        entity.setFullName(fileName);
        entity.setParentId(parentId);
        entity.setFileExtension(fileType);
        entity.setFilePath(fPath + "." + fileType);
        entity.setFileSize(String.valueOf(file.getSize()));
        entity.setDeleteMark(Integer.valueOf(0));
        entity.setCompanyId(userInfo.getOrganizeId());
        entity.setIsPublic(isPublic);
        this.documentService.create(entity);
        DocumentTrendsEntity trends = new DocumentTrendsEntity();
        trends.setId(RandomUtil.uuId());
        trends.setDocumentId(entity.getId());
        trends.setNodeType(DocumentEnum.DOUCUMENT_UPLOAD.getType());
        trends.setUserId(userInfo.getUserId());
        trends.setUserName(userInfo.getUserName());
        trends.setCompanyId(userInfo.getOrganizeId());
        trends.setExecDate(new Date());
        trends.setCreatorTime(new Date());
        trends.setCreatorUserId(userInfo.getUserId());
        this.documentTrendsService.create(trends);
        if (data.size() > 0) {
            DocumentHistoryEntity documentHistoryEntity = (DocumentHistoryEntity)JsonUtil.getJsonToBean((Object)data.get(0), DocumentHistoryEntity.class);
            documentHistoryEntity.setId(RandomUtil.uuId());
            documentHistoryEntity.setOriginalFileId(((DocumentEntity)data.get(0)).getId());
            this.documentHistoryService.create(documentHistoryEntity);
        }
    }

    @ApiOperation(value="\u538b\u7f29\u6587\u4ef6\u5939\u5e76\u4e0b\u8f7d")
    @GetMapping(value={"/toZip/{id}"})
    public ActionResult toZip(@PathVariable(value="id") String id) {
        DownloadVO allDocumentByParentId = this.documentService.getAllDocumentByParentId(id);
        return ActionResult.success((Object)allDocumentByParentId);
    }
}

