/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.hrms.controller;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.enmus.ExcelType;
import cn.afterturn.easypoi.excel.entity.params.ExcelExportEntity;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.bringspring.common.annotation.HandleLog;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.DownloadVO;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.config.ConfigValueUtil;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UploaderUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.common.util.XSSEscape;
import com.bringspring.common.util.file.UploadUtil;
import com.bringspring.hrms.entity.HrmsEmployeArchiveCertificateEntity;
import com.bringspring.hrms.entity.HrmsEmployeArchiveContactEntity;
import com.bringspring.hrms.entity.HrmsEmployeArchiveEducationEntity;
import com.bringspring.hrms.entity.HrmsEmployeArchiveEntity;
import com.bringspring.hrms.entity.HrmsEmployeArchiveWorkEntity;
import com.bringspring.hrms.entity.HrmsManagerEntryCompanyEntity;
import com.bringspring.hrms.model.hrmsemployearchive.HrmsEmployeArchiveCrForm;
import com.bringspring.hrms.model.hrmsemployearchive.HrmsEmployeArchiveInfoVO;
import com.bringspring.hrms.model.hrmsemployearchive.HrmsEmployeArchiveListVO;
import com.bringspring.hrms.model.hrmsemployearchive.HrmsEmployeArchiveOverviewCount;
import com.bringspring.hrms.model.hrmsemployearchive.HrmsEmployeArchivePagination;
import com.bringspring.hrms.model.hrmsemployearchive.HrmsEmployeArchivePaginationExportModel;
import com.bringspring.hrms.model.hrmsemployearchive.HrmsEmployeeArchiveApplyViewCount;
import com.bringspring.hrms.model.hrmsemployearchivecertificate.HrmsEmployeArchiveCertificateCrForm;
import com.bringspring.hrms.model.hrmsemployearchivecontact.HrmsEmployeArchiveContactCrForm;
import com.bringspring.hrms.model.hrmsemployearchiveeducation.HrmsEmployeArchiveEducationCrForm;
import com.bringspring.hrms.service.HrmsEmployeArchiveCertificateService;
import com.bringspring.hrms.service.HrmsEmployeArchiveContactService;
import com.bringspring.hrms.service.HrmsEmployeArchiveEducationService;
import com.bringspring.hrms.service.HrmsEmployeArchiveService;
import com.bringspring.hrms.service.HrmsEmployeArchiveWorkService;
import com.bringspring.hrms.service.HrmsManagerEntryCompanyService;
import com.bringspring.meeting.utils.ObjectComparator;
import com.bringspring.oa.service.OaRecordSubitemService;
import com.bringspring.system.permission.entity.UserEntity;
import com.bringspring.system.permission.exception.PermissionException;
import com.bringspring.system.permission.service.UserRelationService;
import com.bringspring.system.permission.service.UserService;
import com.bringspring.system.permission.util.BaseDataUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u5458\u5de5\u6863\u6848"}, value="hrms")
@RequestMapping(value={"/api/hrms/OaArchive"})
public class HrmsEmployeArchiveController {
    private static final Logger log = LoggerFactory.getLogger(HrmsEmployeArchiveController.class);
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private ConfigValueUtil configValueUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private HrmsEmployeArchiveService hrmsEmployeArchiveService;
    @Autowired
    private HrmsEmployeArchiveContactService hrmsEmployeArchiveContactService;
    @Autowired
    private HrmsEmployeArchiveEducationService hrmsEmployeArchiveEducationService;
    @Autowired
    private HrmsEmployeArchiveCertificateService oaArchiveCertificateService;
    @Autowired
    private HrmsEmployeArchiveWorkService hrmsEmployeArchiveWorkService;
    @Autowired
    private UserService userService;
    @Autowired
    private UserRelationService userRelationService;
    @Autowired
    private HrmsManagerEntryCompanyService hrmsManagerEntryCompanyService;
    @Autowired
    private OaRecordSubitemService oaRecordSubitemService;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody HrmsEmployeArchivePagination hrmsEmployeArchivePagination) throws IOException {
        List<HrmsEmployeArchiveEntity> list = this.hrmsEmployeArchiveService.getList(hrmsEmployeArchivePagination);
        List listVO = JsonUtil.getJsonToList(list, HrmsEmployeArchiveCrForm.class);
        if (!ObjectUtil.isEmpty((Object)listVO)) {
            for (HrmsEmployeArchiveCrForm entity : listVO) {
                UserEntity infoUser = this.userService.getInfo(entity.getId());
                if (ObjectUtil.isEmpty((Object)infoUser)) continue;
                entity.setUserId(infoUser.getId());
            }
            this.hrmsEmployeArchiveService.getNameByCode(listVO);
        }
        PageListVO vo = new PageListVO();
        vo.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)hrmsEmployeArchivePagination), PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success((Object)vo);
    }

    @GetMapping(value={"/getByCode/{code}"})
    public ActionResult getByCode(@PathVariable(value="code") String code) throws IOException {
        List<HrmsEmployeArchiveEntity> infoByCode = this.hrmsEmployeArchiveService.getInfoByCode(code);
        return ActionResult.success(infoByCode);
    }

    @GetMapping(value={"/getCount/{menuId}"})
    public ActionResult getCount(@PathVariable(value="menuId") String menuId) throws IOException {
        HrmsEmployeArchiveOverviewCount count = this.hrmsEmployeArchiveService.getCount(menuId);
        return ActionResult.success((Object)count);
    }

    @PostMapping(value={"/getApplyCount"})
    public ActionResult getApplyCount(@RequestBody HrmsEmployeArchivePagination hrmsEmployeArchivePagination) throws IOException {
        HrmsEmployeeArchiveApplyViewCount count = this.hrmsEmployeArchiveService.getApplyCount(hrmsEmployeArchivePagination.getMenuId(), hrmsEmployeArchivePagination.getFlowList());
        return ActionResult.success((Object)count);
    }

    @GetMapping(value={"/syncUser/{id}"})
    @DSTransactional
    @HandleLog(moduleName="\u4eba\u5458\u6863\u6848", requestMethod="\u540c\u6b65\u751f\u6210\u8d26\u6237")
    public ActionResult syncUser(@PathVariable(value="id") String id) throws Exception {
        HrmsEmployeArchiveEntity infoArchive = this.hrmsEmployeArchiveService.getInfo(id);
        HrmsEmployeArchiveCrForm entity = (HrmsEmployeArchiveCrForm)JsonUtil.getJsonToBean((Object)infoArchive, HrmsEmployeArchiveCrForm.class);
        this.hrmsEmployeArchiveService.syncUser(entity);
        return ActionResult.success((String)"\u751f\u6210\u6210\u529f");
    }

    @PostMapping
    @DSTransactional
    @HandleLog(moduleName="\u4eba\u5458\u6863\u6848", requestMethod="\u521b\u5efa\u4eba\u5458\u6863\u6848")
    public ActionResult create(@RequestBody @Valid HrmsEmployeArchiveCrForm hrmsEmployeArchiveCrForm) throws Exception {
        List jsonToList;
        List<Object> educateList;
        String mainId = RandomUtil.uuId();
        UserInfo userInfo = this.userProvider.get();
        if (ObjectUtil.isEmpty((Object)hrmsEmployeArchiveCrForm.getCode())) {
            hrmsEmployeArchiveCrForm.setCode(this.baseDataUtil.getBillNumber("RStaff", Boolean.valueOf(false)));
        }
        if (ObjectUtil.isNotEmpty(hrmsEmployeArchiveCrForm.getWorkCityList())) {
            String join = CollectionUtil.join(hrmsEmployeArchiveCrForm.getWorkCityList(), (CharSequence)",");
            hrmsEmployeArchiveCrForm.setWorkCity(join);
        }
        HrmsEmployeArchiveEntity entity = (HrmsEmployeArchiveEntity)JsonUtil.getJsonToBean((Object)hrmsEmployeArchiveCrForm, HrmsEmployeArchiveEntity.class);
        entity.setId(mainId);
        hrmsEmployeArchiveCrForm.setId(mainId);
        this.hrmsEmployeArchiveService.save(entity);
        if (!ObjectUtil.isEmpty(hrmsEmployeArchiveCrForm.getContactList())) {
            List<HrmsEmployeArchiveContactCrForm> contactList = hrmsEmployeArchiveCrForm.getContactList();
            contactList.stream().forEach(v -> {
                v.setArchiveId(mainId);
                v.setId(RandomUtil.uuId());
            });
            List listVO = JsonUtil.getJsonToList(contactList, HrmsEmployeArchiveContactEntity.class);
            this.hrmsEmployeArchiveContactService.saveBatch(listVO);
        }
        if (!ObjectUtil.isEmpty(hrmsEmployeArchiveCrForm.getEducateList())) {
            educateList = hrmsEmployeArchiveCrForm.getEducateList();
            educateList.stream().forEach(v -> {
                v.setArchiveId(mainId);
                v.setId(RandomUtil.uuId());
            });
            jsonToList = JsonUtil.getJsonToList(educateList, HrmsEmployeArchiveEducationEntity.class);
            this.hrmsEmployeArchiveEducationService.saveBatch(jsonToList);
        }
        if (!ObjectUtil.isEmpty(hrmsEmployeArchiveCrForm.getCertificateList())) {
            educateList = hrmsEmployeArchiveCrForm.getCertificateList();
            educateList.stream().forEach(v -> {
                v.setArchiveId(mainId);
                v.setId(RandomUtil.uuId());
            });
            jsonToList = JsonUtil.getJsonToList(educateList, HrmsEmployeArchiveCertificateEntity.class);
            this.oaArchiveCertificateService.saveOrUpdateBatch(jsonToList);
        }
        if (!ObjectUtil.isEmpty(hrmsEmployeArchiveCrForm.getWorkList())) {
            educateList = hrmsEmployeArchiveCrForm.getWorkList();
            educateList.stream().forEach(v -> {
                v.setArchiveId(mainId);
                v.setId(RandomUtil.uuId());
            });
            this.hrmsEmployeArchiveWorkService.saveOrUpdateBatch(educateList);
        }
        if ("0".equals(hrmsEmployeArchiveCrForm.getArchiveType())) {
            this.hrmsEmployeArchiveService.syncUser(hrmsEmployeArchiveCrForm);
            if (!ObjectUtil.isEmpty((Object)hrmsEmployeArchiveCrForm.getFlowStateEnable())) {
                HrmsManagerEntryCompanyEntity updateEntity = new HrmsManagerEntryCompanyEntity();
                updateEntity.setFlowStateEnable(5);
                this.hrmsManagerEntryCompanyService.update(hrmsEmployeArchiveCrForm.getEntryId(), updateEntity);
            }
        }
        this.oaRecordSubitemService.getAddUser(entity);
        return ActionResult.success((String)"\u521b\u5efa\u6210\u529f");
    }

    @ApiOperation(value="\u6a21\u677f\u4e0b\u8f7d")
    @GetMapping(value={"/templateDownload"})
    public ActionResult<DownloadVO> TemplateDownload() {
        UserInfo userInfo = this.userProvider.get();
        DownloadVO vo = DownloadVO.builder().build();
        try {
            vo.setName("\u804c\u5458\u4fe1\u606f.xlsx");
            vo.setUrl(UploaderUtil.uploaderFile((String)"/api/Common/DownloadModel?encryption=", (String)(userInfo.getId() + "#\u804c\u5458\u4fe1\u606f.xlsx#Temporary")));
        }
        catch (Exception e) {
            log.error("\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:{}", (Object)e.getMessage());
        }
        return ActionResult.success((Object)vo);
    }

    @ApiOperation(value="\u5bfc\u51faExcel")
    @GetMapping(value={"/Actions/Export"})
    public ActionResult Export(HrmsEmployeArchivePaginationExportModel hrmsEmployeArchivePaginationExportModel) throws IOException {
        if (StringUtils.isEmpty((String)hrmsEmployeArchivePaginationExportModel.getSelectKey())) {
            return ActionResult.fail((String)"\u8bf7\u9009\u62e9\u5bfc\u51fa\u5b57\u6bb5");
        }
        HrmsEmployeArchivePagination hrmsEmployeArchivePagination = (HrmsEmployeArchivePagination)((Object)JsonUtil.getJsonToBean((Object)((Object)hrmsEmployeArchivePaginationExportModel), HrmsEmployeArchivePagination.class));
        List<HrmsEmployeArchiveEntity> list = this.hrmsEmployeArchiveService.getTypeList(hrmsEmployeArchivePagination, hrmsEmployeArchivePaginationExportModel.getDataType());
        for (HrmsEmployeArchiveEntity hrmsEmployeArchiveEntity : list) {
            hrmsEmployeArchiveEntity.setGander(this.baseDataUtil.getDictName(hrmsEmployeArchiveEntity.getGander(), "sex"));
            hrmsEmployeArchiveEntity.setNativePlace(this.baseDataUtil.provinceData(hrmsEmployeArchiveEntity.getNativePlace()));
            hrmsEmployeArchiveEntity.setEntryType(this.baseDataUtil.getDictName(hrmsEmployeArchiveEntity.getEntryType(), "entryType"));
            hrmsEmployeArchiveEntity.setEntryCompany(this.baseDataUtil.comSelectValues(hrmsEmployeArchiveEntity.getEntryCompany()));
            hrmsEmployeArchiveEntity.setEntryNature(this.baseDataUtil.getDictName(hrmsEmployeArchiveEntity.getEntryNature(), "employNature"));
            hrmsEmployeArchiveEntity.setEntryDepartment(this.baseDataUtil.comSelectValues(hrmsEmployeArchiveEntity.getEntryDepartment()));
            hrmsEmployeArchiveEntity.setStation(this.baseDataUtil.posSelectValues(hrmsEmployeArchiveEntity.getStation()));
            hrmsEmployeArchiveEntity.setBandLevel(this.baseDataUtil.getDictName(hrmsEmployeArchiveEntity.getBandLevel(), "band"));
            hrmsEmployeArchiveEntity.setManagerId(this.baseDataUtil.userSelectValues(hrmsEmployeArchiveEntity.getManagerId()));
            hrmsEmployeArchiveEntity.setEmployeeType(this.baseDataUtil.getDictName(hrmsEmployeArchiveEntity.getEmployeeType(), "staffType"));
            hrmsEmployeArchiveEntity.setEmployeeState(this.baseDataUtil.getDictName(hrmsEmployeArchiveEntity.getEmployeeState(), "employState"));
            hrmsEmployeArchiveEntity.setWorkCity(this.baseDataUtil.provinceData(hrmsEmployeArchiveEntity.getWorkCity()));
        }
        List listVO = JsonUtil.getJsonToList(list, HrmsEmployeArchiveListVO.class);
        for (HrmsEmployeArchiveListVO hrmsEmployeArchiveListVO : listVO) {
        }
        List list2 = JsonUtil.getJsonToListMap((String)JsonUtil.getObjectToStringDateFormat((Object)listVO, (String)"yyyy-MM-dd HH:mm:ss"));
        String[] keys = !StringUtils.isEmpty((String)hrmsEmployeArchivePaginationExportModel.getSelectKey()) ? hrmsEmployeArchivePaginationExportModel.getSelectKey().split(",") : new String[]{};
        UserInfo userInfo = this.userProvider.get();
        DownloadVO vo = this.creatModelExcel(this.configValueUtil.getTemporaryFilePath(), list2, keys, userInfo);
        return ActionResult.success((Object)vo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DownloadVO creatModelExcel(String path, List<Map<String, Object>> list, String[] keys, UserInfo userInfo) {
        DownloadVO vo = DownloadVO.builder().build();
        ArrayList<ExcelExportEntity> entitys = new ArrayList<ExcelExportEntity>();
        if (keys.length > 0) {
            String[] stringArray = keys;
            int n = stringArray.length;
            block66: for (int i = 0; i < n; ++i) {
                String key;
                switch (key = stringArray[i]) {
                    case "code": {
                        entitys.add(new ExcelExportEntity("\u5458\u5de5\u7f16\u53f7", (Object)"code"));
                        continue block66;
                    }
                    case "name": {
                        entitys.add(new ExcelExportEntity("\u59d3\u540d", (Object)"name"));
                        continue block66;
                    }
                    case "cardType": {
                        entitys.add(new ExcelExportEntity("\u8bc1\u4ef6\u7c7b\u578b", (Object)"cardType"));
                        continue block66;
                    }
                    case "cardNumber": {
                        entitys.add(new ExcelExportEntity("\u8bc1\u4ef6\u53f7\u7801", (Object)"cardNumber"));
                        continue block66;
                    }
                    case "gander": {
                        entitys.add(new ExcelExportEntity("\u6027\u522b", (Object)"gander"));
                        continue block66;
                    }
                    case "birthday": {
                        entitys.add(new ExcelExportEntity("\u51fa\u751f\u65e5\u671f", (Object)"birthday"));
                        continue block66;
                    }
                    case "phone": {
                        entitys.add(new ExcelExportEntity("\u8054\u7cfb\u7535\u8bdd", (Object)"phone"));
                        continue block66;
                    }
                    case "nativePlace": {
                        entitys.add(new ExcelExportEntity("\u7c4d\u8d2f", (Object)"nativePlace"));
                        continue block66;
                    }
                    case "domicile": {
                        entitys.add(new ExcelExportEntity("\u6237\u7c4d", (Object)"domicile"));
                        continue block66;
                    }
                    case "currentAddress": {
                        entitys.add(new ExcelExportEntity("\u73b0\u5c45\u4f4f\u5730", (Object)"currentAddress"));
                        continue block66;
                    }
                    case "entryType": {
                        entitys.add(new ExcelExportEntity("\u5165\u804c\u7c7b\u578b", (Object)"entryType"));
                        continue block66;
                    }
                    case "entryCompany": {
                        entitys.add(new ExcelExportEntity("\u5165\u804c\u673a\u6784", (Object)"entryCompany"));
                        continue block66;
                    }
                    case "entryNature": {
                        entitys.add(new ExcelExportEntity("\u5f55\u7528\u6027\u8d28", (Object)"entryNature"));
                        continue block66;
                    }
                    case "entryDepartment": {
                        entitys.add(new ExcelExportEntity("\u5165\u804c\u90e8\u95e8", (Object)"entryDepartment"));
                        continue block66;
                    }
                    case "station": {
                        entitys.add(new ExcelExportEntity("\u5c97\u4f4d", (Object)"station"));
                        continue block66;
                    }
                    case "stationNature": {
                        entitys.add(new ExcelExportEntity("\u5c97\u4f4d\u6027\u8d28", (Object)"stationNature"));
                        continue block66;
                    }
                    case "bandLevel": {
                        entitys.add(new ExcelExportEntity("\u4efb\u804c\u7b49\u7ea7", (Object)"bandLevel"));
                        continue block66;
                    }
                    case "managerId": {
                        entitys.add(new ExcelExportEntity("\u76f4\u63a5\u4e0a\u7ea7", (Object)"managerId"));
                        continue block66;
                    }
                    case "organizeNumber": {
                        entitys.add(new ExcelExportEntity("\u90e8\u95e8\u73b0\u6709\u4eba\u6570", (Object)"organizeNumber"));
                        continue block66;
                    }
                    case "employeeType": {
                        entitys.add(new ExcelExportEntity("\u5458\u5de5\u7c7b\u578b", (Object)"employeeType"));
                        continue block66;
                    }
                    case "employeeState": {
                        entitys.add(new ExcelExportEntity("\u5458\u5de5\u72b6\u6001", (Object)"employeeState"));
                        continue block66;
                    }
                    case "organizeMadeNumber": {
                        entitys.add(new ExcelExportEntity("\u90e8\u95e8\u5b9a\u7f16\u4eba\u6570", (Object)"organizeMadeNumber"));
                        continue block66;
                    }
                    case "entryDate": {
                        entitys.add(new ExcelExportEntity("\u5165\u804c\u65e5\u671f", (Object)"entryDate"));
                        continue block66;
                    }
                    case "trialDate": {
                        entitys.add(new ExcelExportEntity("\u8bd5\u7528\u7ed3\u675f\u65e5\u671f", (Object)"trialDate"));
                        continue block66;
                    }
                    case "workCity": {
                        entitys.add(new ExcelExportEntity("\u5de5\u4f5c\u57ce\u5e02", (Object)"workCity"));
                        continue block66;
                    }
                    case "trialMoney": {
                        entitys.add(new ExcelExportEntity("\u8bd5\u7528\u671f\u85aa\u8d44", (Object)"trialMoney"));
                        continue block66;
                    }
                    case "formalMoney": {
                        entitys.add(new ExcelExportEntity("\u8f6c\u6b63\u85aa\u8d44", (Object)"formalMoney"));
                        continue block66;
                    }
                }
            }
        }
        ExportParams exportParams = new ExportParams(null, "\u8868\u5355\u4fe1\u606f");
        exportParams.setType(ExcelType.XSSF);
        try {
            HSSFWorkbook workbook = new HSSFWorkbook();
            try {
                if (entitys.size() > 0) {
                    workbook = ExcelExportUtil.exportExcel((ExportParams)exportParams, entitys, list);
                }
                String name = "\u8868\u5355\u4fe1\u606f" + DateUtil.dateNow((String)"yyyyMMdd") + "_" + RandomUtil.uuId() + ".xlsx";
                String fileName = this.configValueUtil.getTemporaryFilePath() + name;
                FileOutputStream output = new FileOutputStream(XSSEscape.escapePath((String)fileName));
                try {
                    workbook.write((OutputStream)output);
                    UploadUtil.uploadFile((String)this.configValueUtil.getFileType(), (String)fileName, (String)"temporary", (String)name);
                    vo.setName(name);
                    vo.setUrl(UploaderUtil.uploaderFile((String)(userInfo.getId() + "#" + name + "#Temporary")));
                }
                finally {
                    if (Collections.singletonList(output).get(0) != null) {
                        output.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(workbook).get(0) != null) {
                    workbook.close();
                }
            }
        }
        catch (Exception e) {
            log.error("\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:{}", (Object)e.getMessage());
            e.printStackTrace();
        }
        return vo;
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<HrmsEmployeArchiveCrForm> info(@PathVariable(value="id") String id) {
        HrmsEmployeArchiveEntity entity = this.hrmsEmployeArchiveService.getInfo(id);
        if (ObjectUtil.isEmpty((Object)entity)) {
            return ActionResult.success();
        }
        HrmsEmployeArchiveCrForm vo = (HrmsEmployeArchiveCrForm)JsonUtil.getJsonToBean((Object)entity, HrmsEmployeArchiveCrForm.class);
        ArrayList<HrmsEmployeArchiveCrForm> archiveCrForm = new ArrayList<HrmsEmployeArchiveCrForm>();
        archiveCrForm.add(vo);
        this.hrmsEmployeArchiveService.getNameByCode(archiveCrForm);
        List<HrmsEmployeArchiveContactEntity> listByContact = this.hrmsEmployeArchiveContactService.getListByArchive(id);
        List listVO = JsonUtil.getJsonToList(listByContact, HrmsEmployeArchiveContactCrForm.class);
        vo.setContactList(listVO);
        List<HrmsEmployeArchiveEducationEntity> listByEducate = this.hrmsEmployeArchiveEducationService.getListByArchive(id);
        List listByEducateVO = JsonUtil.getJsonToList(listByEducate, HrmsEmployeArchiveEducationCrForm.class);
        vo.setEducateList(listByEducateVO);
        List<HrmsEmployeArchiveCertificateEntity> listByCertificate = this.oaArchiveCertificateService.getListByArchive(id);
        List listByCertificateVO = JsonUtil.getJsonToList(listByCertificate, HrmsEmployeArchiveCertificateCrForm.class);
        vo.setCertificateList(listByCertificateVO);
        List<HrmsEmployeArchiveWorkEntity> listByWork = this.hrmsEmployeArchiveWorkService.getListByArchive(id);
        vo.setWorkList(listByWork);
        return ActionResult.success((Object)vo);
    }

    @GetMapping(value={"/getInfoByCode/{code}"})
    public ActionResult<HrmsEmployeArchiveCrForm> getInfoByCode(@PathVariable(value="code") String code) {
        List<HrmsEmployeArchiveEntity> infoByCode = this.hrmsEmployeArchiveService.getInfoByCode(code);
        HrmsEmployeArchiveEntity infoById = this.hrmsEmployeArchiveService.getInfo(code);
        if (!ObjectUtil.isEmpty(infoByCode)) {
            List vo = JsonUtil.getJsonToList(infoByCode, HrmsEmployeArchiveCrForm.class);
            this.hrmsEmployeArchiveService.getNameByCode(vo);
            return ActionResult.success(vo.get(0));
        }
        if (!ObjectUtil.isEmpty((Object)infoById)) {
            ArrayList<HrmsEmployeArchiveCrForm> list = new ArrayList<HrmsEmployeArchiveCrForm>();
            list.add((HrmsEmployeArchiveCrForm)JsonUtil.getJsonToBean((Object)infoById, HrmsEmployeArchiveCrForm.class));
            this.hrmsEmployeArchiveService.getNameByCode(list);
            return ActionResult.success(list.get(0));
        }
        return ActionResult.fail((String)"\u6682\u65e0\u4e2a\u4eba\u6863\u6848");
    }

    @GetMapping(value={"/detail/{id}"})
    public ActionResult<HrmsEmployeArchiveInfoVO> detailInfo(@PathVariable(value="id") String id) {
        HrmsEmployeArchiveEntity entity = this.hrmsEmployeArchiveService.getInfo(id);
        HrmsEmployeArchiveInfoVO vo = (HrmsEmployeArchiveInfoVO)JsonUtil.getJsonToBean((Object)entity, HrmsEmployeArchiveInfoVO.class);
        vo.setGander(this.baseDataUtil.getDictName(vo.getGander(), "sex"));
        vo.setNativePlace(this.baseDataUtil.provinceData(vo.getNativePlace()));
        vo.setEntryType(this.baseDataUtil.getDictName(vo.getEntryType(), "entryType"));
        vo.setEntryCompany(this.baseDataUtil.comSelectValues(vo.getEntryCompany()));
        vo.setEntryNature(this.baseDataUtil.getDictName(vo.getEntryNature(), "employNature"));
        vo.setEntryDepartment(this.baseDataUtil.comSelectValues(vo.getEntryDepartment()));
        vo.setStation(this.baseDataUtil.posSelectValues(vo.getStation()));
        vo.setBandLevel(this.baseDataUtil.getDictName(vo.getBandLevel(), "band"));
        vo.setManagerId(this.baseDataUtil.userSelectValues(vo.getManagerId()));
        vo.setEmployeeType(this.baseDataUtil.getDictName(vo.getEmployeeType(), "staffType"));
        vo.setEmployeeStateName(this.baseDataUtil.getDictName(vo.getEmployeeState(), "employState"));
        vo.setWorkCity(this.baseDataUtil.provinceData(vo.getWorkCity()));
        return ActionResult.success((Object)vo);
    }

    @PutMapping(value={"/{id}"})
    @DSTransactional
    @HandleLog(moduleName="\u4eba\u5458\u6863\u6848", requestMethod="\u66f4\u65b0\u4eba\u5458\u6863\u6848")
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid HrmsEmployeArchiveCrForm hrmsEmployeArchiveCrForm) throws PermissionException, DataException {
        UserInfo userInfo = this.userProvider.get();
        HrmsEmployeArchiveEntity entity = this.hrmsEmployeArchiveService.getInfo(id);
        HrmsEmployeArchiveEntity subentity = (HrmsEmployeArchiveEntity)JsonUtil.getJsonToBean((Object)hrmsEmployeArchiveCrForm, HrmsEmployeArchiveEntity.class);
        Map compare = ObjectComparator.compare((Object)entity, (Object)subentity);
        ArrayList keyList = new ArrayList();
        if (ObjectUtil.isNotEmpty((Object)compare)) {
            compare.keySet().stream().forEach(key -> keyList.add(key));
        }
        if (entity != null) {
            List jsonToList;
            List<Object> educateList;
            this.hrmsEmployeArchiveService.update(id, subentity);
            if (!ObjectUtil.isEmpty(hrmsEmployeArchiveCrForm.getContactList())) {
                List<HrmsEmployeArchiveContactCrForm> contactList = hrmsEmployeArchiveCrForm.getContactList();
                contactList.stream().forEach(v -> {
                    v.setArchiveId(id);
                    if (ObjectUtil.isEmpty((Object)v.getId())) {
                        v.setId(RandomUtil.uuId());
                    }
                });
                List listVO = JsonUtil.getJsonToList(contactList, HrmsEmployeArchiveContactEntity.class);
                this.hrmsEmployeArchiveContactService.saveOrUpdateBatch(listVO);
            }
            if (!ObjectUtil.isEmpty(hrmsEmployeArchiveCrForm.getEducateList())) {
                educateList = hrmsEmployeArchiveCrForm.getEducateList();
                educateList.stream().forEach(v -> {
                    v.setArchiveId(id);
                    if (ObjectUtil.isEmpty((Object)v.getId())) {
                        v.setId(RandomUtil.uuId());
                    }
                });
                jsonToList = JsonUtil.getJsonToList(educateList, HrmsEmployeArchiveEducationEntity.class);
                this.hrmsEmployeArchiveEducationService.saveOrUpdateBatch(jsonToList);
            }
            if (!ObjectUtil.isEmpty(hrmsEmployeArchiveCrForm.getCertificateList())) {
                educateList = hrmsEmployeArchiveCrForm.getCertificateList();
                educateList.stream().forEach(v -> {
                    v.setArchiveId(id);
                    if (ObjectUtil.isEmpty((Object)v.getId())) {
                        v.setId(RandomUtil.uuId());
                    }
                });
                jsonToList = JsonUtil.getJsonToList(educateList, HrmsEmployeArchiveCertificateEntity.class);
                this.oaArchiveCertificateService.saveOrUpdateBatch(jsonToList);
            }
            if (!ObjectUtil.isEmpty(hrmsEmployeArchiveCrForm.getWorkList())) {
                educateList = hrmsEmployeArchiveCrForm.getWorkList();
                educateList.stream().forEach(v -> {
                    v.setArchiveId(id);
                    if (ObjectUtil.isEmpty((Object)v.getId())) {
                        v.setId(RandomUtil.uuId());
                    }
                });
                this.hrmsEmployeArchiveWorkService.saveOrUpdateBatch(educateList);
            }
            if (!StrUtil.isBlank((CharSequence)subentity.getEmployeeState()) && keyList.contains("employeeState") && subentity.getEmployeeState().equals("leavingJob")) {
                hrmsEmployeArchiveCrForm.setName(hrmsEmployeArchiveCrForm.getName() + "(\u79bb\u804c\u4e2d)");
                this.hrmsEmployeArchiveService.syncUser(hrmsEmployeArchiveCrForm);
            }
            if (!StrUtil.isBlank((CharSequence)subentity.getEmployeeState()) && keyList.contains("employeeState") && entity.getEmployeeState().equals("leavingJob") && !subentity.getEmployeeState().equals("leavingJob")) {
                hrmsEmployeArchiveCrForm.setName(hrmsEmployeArchiveCrForm.getName());
                this.hrmsEmployeArchiveService.syncUser(hrmsEmployeArchiveCrForm);
            }
            if ("0".equals(hrmsEmployeArchiveCrForm.getArchiveType())) {
                this.hrmsEmployeArchiveService.syncUser(hrmsEmployeArchiveCrForm);
            }
            return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
        }
        return ActionResult.fail((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
    }

    @DeleteMapping(value={"/{id}"})
    @DSTransactional
    @HandleLog(moduleName="\u4eba\u5458\u6863\u6848", requestMethod="\u5220\u9664\u4eba\u5458\u6863\u6848")
    public ActionResult delete(@PathVariable(value="id") String id) throws PermissionException, DataException {
        HrmsEmployeArchiveEntity entity = this.hrmsEmployeArchiveService.getInfo(id);
        if (entity != null) {
            this.hrmsEmployeArchiveService.delete(entity);
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }
}

