/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.hrms.controller;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.enmus.ExcelType;
import cn.afterturn.easypoi.excel.entity.params.ExcelExportEntity;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.DownloadVO;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.config.ConfigValueUtil;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UploaderUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.common.util.XSSEscape;
import com.bringspring.common.util.file.UploadUtil;
import com.bringspring.hrms.entity.HrmsEmployeArchiveWorkEntity;
import com.bringspring.hrms.model.hrmsemployearchivework.HrmsEmployeArchiveWorkCrForm;
import com.bringspring.hrms.model.hrmsemployearchivework.HrmsEmployeArchiveWorkInfoVO;
import com.bringspring.hrms.model.hrmsemployearchivework.HrmsEmployeArchiveWorkListVO;
import com.bringspring.hrms.model.hrmsemployearchivework.HrmsEmployeArchiveWorkPagination;
import com.bringspring.hrms.model.hrmsemployearchivework.HrmsEmployeArchiveWorkPaginationExportModel;
import com.bringspring.hrms.model.hrmsemployearchivework.HrmsEmployeArchiveWorkUpForm;
import com.bringspring.hrms.service.HrmsEmployeArchiveWorkService;
import com.bringspring.system.permission.util.BaseDataUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u5458\u5de5\u6863\u6848\u5de5\u4f5c"}, value="hrms")
@RequestMapping(value={"/api/hrms/OaArchiveWork"})
public class HrmsEmployeArchiveWorkController {
    private static final Logger log = LoggerFactory.getLogger(HrmsEmployeArchiveWorkController.class);
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private ConfigValueUtil configValueUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private HrmsEmployeArchiveWorkService hrmsEmployeArchiveWorkService;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody HrmsEmployeArchiveWorkPagination hrmsEmployeArchiveWorkPagination) throws IOException {
        List<HrmsEmployeArchiveWorkEntity> list = this.hrmsEmployeArchiveWorkService.getList(hrmsEmployeArchiveWorkPagination);
        for (HrmsEmployeArchiveWorkEntity object : list) {
        }
        List listVO = JsonUtil.getJsonToList(list, HrmsEmployeArchiveWorkListVO.class);
        for (HrmsEmployeArchiveWorkListVO hrmsEmployeArchiveWorkListVO : listVO) {
        }
        PageListVO pageListVO = new PageListVO();
        pageListVO.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)hrmsEmployeArchiveWorkPagination), PaginationVO.class);
        pageListVO.setPagination(page);
        return ActionResult.success((Object)pageListVO);
    }

    @PostMapping
    @DSTransactional
    public ActionResult create(@RequestBody @Valid HrmsEmployeArchiveWorkCrForm hrmsEmployeArchiveWorkCrForm) throws DataException {
        String mainId = RandomUtil.uuId();
        UserInfo userInfo = this.userProvider.get();
        HrmsEmployeArchiveWorkEntity entity = (HrmsEmployeArchiveWorkEntity)JsonUtil.getJsonToBean((Object)hrmsEmployeArchiveWorkCrForm, HrmsEmployeArchiveWorkEntity.class);
        entity.setId(mainId);
        this.hrmsEmployeArchiveWorkService.save(entity);
        return ActionResult.success((String)"\u521b\u5efa\u6210\u529f");
    }

    @ApiOperation(value="\u6a21\u677f\u4e0b\u8f7d")
    @GetMapping(value={"/templateDownload"})
    public ActionResult<DownloadVO> TemplateDownload() {
        UserInfo userInfo = this.userProvider.get();
        DownloadVO vo = DownloadVO.builder().build();
        try {
            vo.setName("\u804c\u5458\u4fe1\u606f.xlsx");
            vo.setUrl(UploaderUtil.uploaderFile((String)"/api/Common/DownloadModel?encryption=", (String)(userInfo.getId() + "#\u804c\u5458\u4fe1\u606f.xlsx#Temporary")));
        }
        catch (Exception e) {
            log.error("\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:{}", (Object)e.getMessage());
        }
        return ActionResult.success((Object)vo);
    }

    @ApiOperation(value="\u5bfc\u51faExcel")
    @GetMapping(value={"/Actions/Export"})
    public ActionResult Export(HrmsEmployeArchiveWorkPaginationExportModel hrmsEmployeArchiveWorkPaginationExportModel) throws IOException {
        if (StringUtils.isEmpty((String)hrmsEmployeArchiveWorkPaginationExportModel.getSelectKey())) {
            return ActionResult.fail((String)"\u8bf7\u9009\u62e9\u5bfc\u51fa\u5b57\u6bb5");
        }
        HrmsEmployeArchiveWorkPagination hrmsEmployeArchiveWorkPagination = (HrmsEmployeArchiveWorkPagination)((Object)JsonUtil.getJsonToBean((Object)((Object)hrmsEmployeArchiveWorkPaginationExportModel), HrmsEmployeArchiveWorkPagination.class));
        List<HrmsEmployeArchiveWorkEntity> list = this.hrmsEmployeArchiveWorkService.getTypeList(hrmsEmployeArchiveWorkPagination, hrmsEmployeArchiveWorkPaginationExportModel.getDataType());
        for (HrmsEmployeArchiveWorkEntity object : list) {
        }
        List listVO = JsonUtil.getJsonToList(list, HrmsEmployeArchiveWorkListVO.class);
        for (HrmsEmployeArchiveWorkListVO hrmsEmployeArchiveWorkListVO : listVO) {
        }
        List list2 = JsonUtil.getJsonToListMap((String)JsonUtil.getObjectToStringDateFormat((Object)listVO, (String)"yyyy-MM-dd HH:mm:ss"));
        String[] keys = !StringUtils.isEmpty((String)hrmsEmployeArchiveWorkPaginationExportModel.getSelectKey()) ? hrmsEmployeArchiveWorkPaginationExportModel.getSelectKey().split(",") : new String[]{};
        UserInfo userInfo = this.userProvider.get();
        DownloadVO vo = this.creatModelExcel(this.configValueUtil.getTemporaryFilePath(), list2, keys, userInfo);
        return ActionResult.success((Object)vo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DownloadVO creatModelExcel(String path, List<Map<String, Object>> list, String[] keys, UserInfo userInfo) {
        DownloadVO vo = DownloadVO.builder().build();
        ArrayList<ExcelExportEntity> entitys = new ArrayList<ExcelExportEntity>();
        if (keys.length > 0) {
            String[] stringArray = keys;
            int n = stringArray.length;
            block14: for (int i = 0; i < n; ++i) {
                String key;
                switch (key = stringArray[i]) {
                    case "archiveId": {
                        entitys.add(new ExcelExportEntity("\u6863\u6848id", (Object)"archiveId"));
                        continue block14;
                    }
                }
            }
        }
        ExportParams exportParams = new ExportParams(null, "\u8868\u5355\u4fe1\u606f");
        exportParams.setType(ExcelType.XSSF);
        try {
            HSSFWorkbook workbook = new HSSFWorkbook();
            try {
                if (entitys.size() > 0) {
                    workbook = ExcelExportUtil.exportExcel((ExportParams)exportParams, entitys, list);
                }
                String name = "\u8868\u5355\u4fe1\u606f" + DateUtil.dateNow((String)"yyyyMMdd") + "_" + RandomUtil.uuId() + ".xlsx";
                String fileName = this.configValueUtil.getTemporaryFilePath() + name;
                FileOutputStream output = new FileOutputStream(XSSEscape.escapePath((String)fileName));
                try {
                    workbook.write((OutputStream)output);
                    UploadUtil.uploadFile((String)this.configValueUtil.getFileType(), (String)fileName, (String)"temporary", (String)name);
                    vo.setName(name);
                    vo.setUrl(UploaderUtil.uploaderFile((String)(userInfo.getId() + "#" + name + "#Temporary")));
                }
                finally {
                    if (Collections.singletonList(output).get(0) != null) {
                        output.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(workbook).get(0) != null) {
                    workbook.close();
                }
            }
        }
        catch (Exception e) {
            log.error("\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:{}", (Object)e.getMessage());
            e.printStackTrace();
        }
        return vo;
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<HrmsEmployeArchiveWorkInfoVO> info(@PathVariable(value="id") String id) {
        HrmsEmployeArchiveWorkEntity entity = this.hrmsEmployeArchiveWorkService.getInfo(id);
        HrmsEmployeArchiveWorkInfoVO vo = (HrmsEmployeArchiveWorkInfoVO)JsonUtil.getJsonToBean((Object)entity, HrmsEmployeArchiveWorkInfoVO.class);
        return ActionResult.success((Object)vo);
    }

    @GetMapping(value={"/detail/{id}"})
    public ActionResult<HrmsEmployeArchiveWorkInfoVO> detailInfo(@PathVariable(value="id") String id) {
        HrmsEmployeArchiveWorkEntity entity = this.hrmsEmployeArchiveWorkService.getInfo(id);
        HrmsEmployeArchiveWorkInfoVO vo = (HrmsEmployeArchiveWorkInfoVO)JsonUtil.getJsonToBean((Object)entity, HrmsEmployeArchiveWorkInfoVO.class);
        return ActionResult.success((Object)vo);
    }

    @PutMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid HrmsEmployeArchiveWorkUpForm hrmsEmployeArchiveWorkUpForm) throws DataException {
        UserInfo userInfo = this.userProvider.get();
        HrmsEmployeArchiveWorkEntity entity = this.hrmsEmployeArchiveWorkService.getInfo(id);
        if (entity != null) {
            HrmsEmployeArchiveWorkEntity subentity = (HrmsEmployeArchiveWorkEntity)JsonUtil.getJsonToBean((Object)hrmsEmployeArchiveWorkUpForm, HrmsEmployeArchiveWorkEntity.class);
            this.hrmsEmployeArchiveWorkService.update(id, subentity);
            return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
        }
        return ActionResult.fail((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
    }

    @DeleteMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult delete(@PathVariable(value="id") String id) {
        HrmsEmployeArchiveWorkEntity entity = this.hrmsEmployeArchiveWorkService.getInfo(id);
        if (entity != null) {
            this.hrmsEmployeArchiveWorkService.delete(entity);
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }
}

