/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.hrms.controller;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.enmus.ExcelType;
import cn.afterturn.easypoi.excel.entity.params.ExcelExportEntity;
import cn.hutool.core.util.ObjectUtil;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.DownloadVO;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.config.ConfigValueUtil;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UploaderUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.common.util.XSSEscape;
import com.bringspring.common.util.file.UploadUtil;
import com.bringspring.hrms.entity.HrmsManagerChangeRegularEntity;
import com.bringspring.hrms.entity.HrmsProbationAssessmentEntity;
import com.bringspring.hrms.model.hrmsmanagerchangeregular.HrmsManagerChangeRegularCrForm;
import com.bringspring.hrms.model.hrmsmanagerchangeregular.HrmsManagerChangeRegularListVO;
import com.bringspring.hrms.model.hrmsmanagerchangeregular.HrmsManagerChangeRegularPagination;
import com.bringspring.hrms.model.hrmsmanagerchangeregular.HrmsManagerChangeRegularPaginationExportModel;
import com.bringspring.hrms.model.hrmsmanagerchangeregular.HrmsManagerChangeRegularUpForm;
import com.bringspring.hrms.model.hrmsmanagerchangeregular.HrmsManagerchangeregularInfoVO;
import com.bringspring.hrms.service.HrmsManagerChangeRegularService;
import com.bringspring.hrms.service.HrmsProbationAssessmentService;
import com.bringspring.hrms.util.ChangeRegularStatusEnum;
import com.bringspring.system.base.exception.WorkFlowException;
import com.bringspring.system.permission.entity.OrganizeEntity;
import com.bringspring.system.permission.entity.PositionEntity;
import com.bringspring.system.permission.entity.UserEntity;
import com.bringspring.system.permission.service.OrganizeService;
import com.bringspring.system.permission.service.PositionService;
import com.bringspring.system.permission.service.UserService;
import com.bringspring.system.permission.util.BaseDataUtil;
import com.bringspring.workflow.engine.entity.FlowTaskEntity;
import com.bringspring.workflow.engine.util.FlowUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u8f6c\u6b63\u7533\u8bf7"}, value="hrms")
@RequestMapping(value={"/api/hrms/OaChangeRegular"})
public class HrmsManagerChangeRegularController {
    private static final Logger log = LoggerFactory.getLogger(HrmsManagerChangeRegularController.class);
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private ConfigValueUtil configValueUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private HrmsManagerChangeRegularService hrmsManagerChangeRegularService;
    @Autowired
    private UserService userService;
    @Autowired
    private PositionService positionService;
    @Autowired
    private OrganizeService organizeService;
    @Autowired
    private HrmsProbationAssessmentService hrmsProbationAssessmentService;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody HrmsManagerChangeRegularPagination hrmsManagerChangeRegularPagination) throws IOException {
        List<HrmsManagerChangeRegularEntity> list = this.hrmsManagerChangeRegularService.getList(hrmsManagerChangeRegularPagination);
        List listVO = JsonUtil.getJsonToList(list, HrmsManagerChangeRegularListVO.class);
        for (HrmsManagerChangeRegularListVO vo : listVO) {
            vo.setCreatorUserId(this.baseDataUtil.userSelectValue(vo.getCreatorUserId()));
            vo.setUserType(this.baseDataUtil.getDictName(vo.getUserType(), "staffType"));
            vo.setChangeType(this.baseDataUtil.getDictName(vo.getChangeType(), "changeType"));
            vo.setFlowStateEnableName(ChangeRegularStatusEnum.getNameByCode(vo.getFlowStateEnable()));
            FlowTaskEntity flowTaskEntity = FlowUtil.getFlowTaskSubmited((String)vo.getId(), (SFunction[])new SFunction[]{FlowTaskEntity::getStatus});
            if (flowTaskEntity != null) {
                vo.setFlowState(flowTaskEntity.getStatus());
                continue;
            }
            vo.setFlowState(null);
        }
        PageListVO vo = new PageListVO();
        vo.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)hrmsManagerChangeRegularPagination), PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success((Object)vo);
    }

    @PostMapping
    @DSTransactional
    public ActionResult create(@RequestBody @Valid Map<String, Object> crData) throws DataException, WorkFlowException {
        HrmsManagerChangeRegularCrForm hrmsManagerChangeRegularCrForm = (HrmsManagerChangeRegularCrForm)((Object)JsonUtil.getJsonToBean(crData, HrmsManagerChangeRegularCrForm.class));
        String flowEngineId = "509055399111145029";
        if (StringUtils.isNotEmpty((String)hrmsManagerChangeRegularCrForm.getFlowId())) {
            flowEngineId = hrmsManagerChangeRegularCrForm.getFlowId();
        }
        String mainId = RandomUtil.uuId();
        UserInfo userInfo = this.userProvider.get();
        hrmsManagerChangeRegularCrForm.setCode(this.baseDataUtil.getBillNumber("ChangeRegular", Boolean.valueOf(false)));
        hrmsManagerChangeRegularCrForm.setUserTeacherName(this.baseDataUtil.userSelectValue(hrmsManagerChangeRegularCrForm.getUserTeacher()));
        hrmsManagerChangeRegularCrForm.setUserLeaderName(this.baseDataUtil.userSelectValues(hrmsManagerChangeRegularCrForm.getUserLeader()));
        hrmsManagerChangeRegularCrForm.setAppraisalResultsName(this.baseDataUtil.getDictName(hrmsManagerChangeRegularCrForm.getAppraisalResults(), "615473334628461701"));
        HrmsManagerChangeRegularEntity entity = (HrmsManagerChangeRegularEntity)JsonUtil.getJsonToBean((Object)((Object)hrmsManagerChangeRegularCrForm), HrmsManagerChangeRegularEntity.class);
        entity.setEntryCompany(userInfo.getOrganizeId());
        entity.setId(mainId);
        if (StringUtils.isNotEmpty((Object[])hrmsManagerChangeRegularCrForm.getTrialDate())) {
            entity.setTrialStartDate(hrmsManagerChangeRegularCrForm.getTrialDate()[0]);
            entity.setTrialEndDate(hrmsManagerChangeRegularCrForm.getTrialDate()[1]);
        }
        this.hrmsManagerChangeRegularService.save(entity);
        String title = this.baseDataUtil.userSelectValue(hrmsManagerChangeRegularCrForm.getCreatorUserId());
        FlowUtil.saveOrSubmit((String)hrmsManagerChangeRegularCrForm.getTaskId(), (String)flowEngineId, (String)hrmsManagerChangeRegularCrForm.getTemplateId(), (String)mainId, (Object)((Object)hrmsManagerChangeRegularCrForm), (Integer)hrmsManagerChangeRegularCrForm.getStatus(), (String)title);
        return ActionResult.success((String)"\u4fdd\u5b58\u6210\u529f");
    }

    @ApiOperation(value="\u6a21\u677f\u4e0b\u8f7d")
    @GetMapping(value={"/templateDownload"})
    public ActionResult<DownloadVO> TemplateDownload() {
        UserInfo userInfo = this.userProvider.get();
        DownloadVO vo = DownloadVO.builder().build();
        try {
            vo.setName("\u804c\u5458\u4fe1\u606f.xlsx");
            vo.setUrl(UploaderUtil.uploaderFile((String)"/api/Common/DownloadModel?encryption=", (String)(userInfo.getId() + "#\u804c\u5458\u4fe1\u606f.xlsx#Temporary")));
        }
        catch (Exception e) {
            log.error("\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:{}", (Object)e.getMessage());
        }
        return ActionResult.success((Object)vo);
    }

    @ApiOperation(value="\u5bfc\u51faExcel")
    @GetMapping(value={"/Actions/Export"})
    public ActionResult Export(HrmsManagerChangeRegularPaginationExportModel hrmsManagerChangeRegularPaginationExportModel) throws IOException {
        if (StringUtils.isEmpty((String)hrmsManagerChangeRegularPaginationExportModel.getSelectKey())) {
            return ActionResult.fail((String)"\u8bf7\u9009\u62e9\u5bfc\u51fa\u5b57\u6bb5");
        }
        HrmsManagerChangeRegularPagination hrmsManagerChangeRegularPagination = (HrmsManagerChangeRegularPagination)((Object)JsonUtil.getJsonToBean((Object)((Object)hrmsManagerChangeRegularPaginationExportModel), HrmsManagerChangeRegularPagination.class));
        List<HrmsManagerChangeRegularEntity> list = this.hrmsManagerChangeRegularService.getTypeList(hrmsManagerChangeRegularPagination, hrmsManagerChangeRegularPaginationExportModel.getDataType());
        for (HrmsManagerChangeRegularEntity hrmsManagerChangeRegularEntity : list) {
            hrmsManagerChangeRegularEntity.setCreatorUserId(this.baseDataUtil.userSelectValue(hrmsManagerChangeRegularEntity.getCreatorUserId()));
            hrmsManagerChangeRegularEntity.setUserType(this.baseDataUtil.getDictName(hrmsManagerChangeRegularEntity.getUserType(), "509060614837220933"));
        }
        List listVO = JsonUtil.getJsonToList(list, HrmsManagerChangeRegularListVO.class);
        for (HrmsManagerChangeRegularListVO hrmsManagerChangeRegularListVO : listVO) {
        }
        List list2 = JsonUtil.getJsonToListMap((String)JsonUtil.getObjectToStringDateFormat((Object)listVO, (String)"yyyy-MM-dd HH:mm:ss"));
        String[] keys = !StringUtils.isEmpty((String)hrmsManagerChangeRegularPaginationExportModel.getSelectKey()) ? hrmsManagerChangeRegularPaginationExportModel.getSelectKey().split(",") : new String[]{};
        UserInfo userInfo = this.userProvider.get();
        DownloadVO vo = this.creatModelExcel(this.configValueUtil.getTemporaryFilePath(), list2, keys, userInfo);
        return ActionResult.success((Object)vo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DownloadVO creatModelExcel(String path, List<Map<String, Object>> list, String[] keys, UserInfo userInfo) {
        DownloadVO vo = DownloadVO.builder().build();
        ArrayList<ExcelExportEntity> entitys = new ArrayList<ExcelExportEntity>();
        if (keys.length > 0) {
            String[] stringArray = keys;
            int n = stringArray.length;
            block54: for (int i = 0; i < n; ++i) {
                String key;
                switch (key = stringArray[i]) {
                    case "code": {
                        entitys.add(new ExcelExportEntity("\u7f16\u53f7", (Object)"code"));
                        continue block54;
                    }
                    case "creatorTime": {
                        entitys.add(new ExcelExportEntity("\u7533\u8bf7\u65e5\u671f", (Object)"creatorTime"));
                        continue block54;
                    }
                    case "creatorUserId": {
                        entitys.add(new ExcelExportEntity("\u521b\u5efa\u7528\u6237", (Object)"creatorUserId"));
                        continue block54;
                    }
                    case "entryDate": {
                        entitys.add(new ExcelExportEntity("\u5165\u804c\u65e5\u671f", (Object)"entryDate"));
                        continue block54;
                    }
                    case "userType": {
                        entitys.add(new ExcelExportEntity("\u5458\u5de5\u7c7b\u522b", (Object)"userType"));
                        continue block54;
                    }
                    case "trialMoney": {
                        entitys.add(new ExcelExportEntity("\u8bd5\u7528\u5de5\u8d44", (Object)"trialMoney"));
                        continue block54;
                    }
                    case "formalMoney": {
                        entitys.add(new ExcelExportEntity("\u6b63\u5f0f\u5de5\u8d44", (Object)"formalMoney"));
                        continue block54;
                    }
                    case "changeDate": {
                        entitys.add(new ExcelExportEntity("\u5b9e\u9645\u8f6c\u6b63\u65e5\u671f", (Object)"changeDate"));
                        continue block54;
                    }
                    case "changeType": {
                        entitys.add(new ExcelExportEntity("\u8f6c\u6b63\u7c7b\u578b", (Object)"changeType"));
                        continue block54;
                    }
                    case "userApply": {
                        entitys.add(new ExcelExportEntity("\u4e2a\u4eba\u8f6c\u6b63\u7533\u8bf7", (Object)"userApply"));
                        continue block54;
                    }
                    case "userOne": {
                        entitys.add(new ExcelExportEntity("", (Object)"userOne"));
                        continue block54;
                    }
                    case "userTwo": {
                        entitys.add(new ExcelExportEntity("", (Object)"userTwo"));
                        continue block54;
                    }
                    case "userThree": {
                        entitys.add(new ExcelExportEntity("", (Object)"userThree"));
                        continue block54;
                    }
                    case "userFour": {
                        entitys.add(new ExcelExportEntity("", (Object)"userFour"));
                        continue block54;
                    }
                    case "userFive": {
                        entitys.add(new ExcelExportEntity("", (Object)"userFive"));
                        continue block54;
                    }
                    case "userSix": {
                        entitys.add(new ExcelExportEntity("", (Object)"userSix"));
                        continue block54;
                    }
                    case "userSeven": {
                        entitys.add(new ExcelExportEntity("", (Object)"userSeven"));
                        continue block54;
                    }
                    case "leaderNote": {
                        entitys.add(new ExcelExportEntity("", (Object)"leaderNote"));
                        continue block54;
                    }
                    case "hrbpNote": {
                        entitys.add(new ExcelExportEntity("", (Object)"hrbpNote"));
                        continue block54;
                    }
                    case "hrDirector": {
                        entitys.add(new ExcelExportEntity("", (Object)"hrDirector"));
                        continue block54;
                    }
                    case "userTeacherName": {
                        entitys.add(new ExcelExportEntity("\u5e26\u6559\u4eba", (Object)"userTeacherName"));
                        continue block54;
                    }
                }
            }
        }
        ExportParams exportParams = new ExportParams(null, "\u8868\u5355\u4fe1\u606f");
        exportParams.setType(ExcelType.XSSF);
        try {
            HSSFWorkbook workbook = new HSSFWorkbook();
            try {
                if (entitys.size() > 0) {
                    workbook = ExcelExportUtil.exportExcel((ExportParams)exportParams, entitys, list);
                }
                String name = "\u8868\u5355\u4fe1\u606f" + DateUtil.dateNow((String)"yyyyMMdd") + "_" + RandomUtil.uuId() + ".xlsx";
                String fileName = this.configValueUtil.getTemporaryFilePath() + name;
                FileOutputStream output = new FileOutputStream(XSSEscape.escapePath((String)fileName));
                try {
                    workbook.write((OutputStream)output);
                    UploadUtil.uploadFile((String)this.configValueUtil.getFileType(), (String)fileName, (String)"temporary", (String)name);
                    vo.setName(name);
                    vo.setUrl(UploaderUtil.uploaderFile((String)(userInfo.getId() + "#" + name + "#Temporary")));
                }
                finally {
                    if (Collections.singletonList(output).get(0) != null) {
                        output.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(workbook).get(0) != null) {
                    workbook.close();
                }
            }
        }
        catch (Exception e) {
            log.error("\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:{}", (Object)e.getMessage());
            e.printStackTrace();
        }
        return vo;
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<HrmsManagerchangeregularInfoVO> info(@PathVariable(value="id") String id) {
        HrmsProbationAssessmentEntity p;
        HrmsManagerChangeRegularEntity entity = this.hrmsManagerChangeRegularService.getInfo(id);
        HrmsManagerchangeregularInfoVO vo = (HrmsManagerchangeregularInfoVO)JsonUtil.getJsonToBean((Object)entity, HrmsManagerchangeregularInfoVO.class);
        vo.setCreatorUserName(this.baseDataUtil.userSelectValue(vo.getCreatorUserId()));
        UserEntity info = this.userService.getInfo(vo.getCreatorUserId());
        if (!ObjectUtil.isEmpty((Object)info)) {
            OrganizeEntity info1;
            OrganizeEntity info2;
            String depart;
            List infoPosition = this.positionService.getListByUserId(vo.getCreatorUserId());
            if (!ObjectUtil.isEmpty((Object)infoPosition)) {
                vo.setStationName(((PositionEntity)infoPosition.get(0)).getFullName());
            }
            if (!ObjectUtil.isEmpty((Object)(depart = this.baseDataUtil.comSelectValues(info.getOrganizeId())))) {
                vo.setDepartmentName(depart);
            }
            if (!ObjectUtil.isEmpty((Object)(info2 = this.organizeService.getInfo(this.organizeService.getDirectlyUnderCompanyById((info1 = this.organizeService.getInfo(info.getOrganizeId())).getId()).getId())))) {
                vo.setCompanyName(info2.getFullName());
            }
            if (ObjectUtil.isNotEmpty((Object)entity.getTrialStartDate()) && ObjectUtil.isNotEmpty((Object)entity.getTrialEndDate())) {
                Date[] res = new Date[]{entity.getTrialStartDate(), entity.getTrialEndDate()};
                vo.setTrialDate(res);
            }
        }
        if (ObjectUtil.isNotEmpty((Object)entity.getTrialStartDate()) && ObjectUtil.isNotEmpty((Object)entity.getTrialEndDate())) {
            String trialStart = DateUtil.dateFormatToDay((Date)entity.getTrialStartDate(), (String)"yyyy-MM-dd");
            String trialEnd = DateUtil.dateFormatToDay((Date)entity.getTrialEndDate(), (String)"yyyy-MM-dd");
            vo.setTrialDateName(trialStart + "\u81f3" + trialEnd);
        }
        if (StringUtils.isNotEmpty((String)vo.getAppraisalIds()) && ObjectUtil.isNotEmpty((Object)(p = this.hrmsProbationAssessmentService.getInfo(vo.getAppraisalIds())))) {
            vo.setAppraisalName(p.getStudentName() + "\u7efc\u5408\u5f97\u5206:" + p.getComprehensiveScore());
        }
        return ActionResult.success((Object)vo);
    }

    @PutMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid Map<String, Object> upData) throws DataException, WorkFlowException {
        HrmsManagerChangeRegularUpForm hrmsManagerChangeRegularUpForm = (HrmsManagerChangeRegularUpForm)((Object)JsonUtil.getJsonToBean(upData, HrmsManagerChangeRegularUpForm.class));
        String flowEngineId = "509055399111145029";
        if (StringUtils.isNotEmpty((String)hrmsManagerChangeRegularUpForm.getFlowId())) {
            flowEngineId = hrmsManagerChangeRegularUpForm.getFlowId();
        }
        UserInfo userInfo = this.userProvider.get();
        HrmsManagerChangeRegularEntity entity = this.hrmsManagerChangeRegularService.getInfo(id);
        if (entity != null) {
            hrmsManagerChangeRegularUpForm.setAppraisalResultsName(this.baseDataUtil.getDictName(hrmsManagerChangeRegularUpForm.getAppraisalResults(), "615473334628461701"));
            HrmsManagerChangeRegularEntity subentity = (HrmsManagerChangeRegularEntity)JsonUtil.getJsonToBean((Object)((Object)hrmsManagerChangeRegularUpForm), HrmsManagerChangeRegularEntity.class);
            subentity.setUserTeacherName(this.baseDataUtil.userSelectValue(subentity.getUserTeacher()));
            subentity.setUserLeaderName(this.baseDataUtil.userSelectValues(subentity.getUserLeader()));
            if (StringUtils.isNotEmpty((Object[])hrmsManagerChangeRegularUpForm.getTrialDate())) {
                subentity.setTrialStartDate(hrmsManagerChangeRegularUpForm.getTrialDate()[0]);
                subentity.setTrialEndDate(hrmsManagerChangeRegularUpForm.getTrialDate()[1]);
            }
            this.hrmsManagerChangeRegularService.update(id, subentity);
            String title = this.baseDataUtil.userSelectValue(subentity.getCreatorUserId());
            FlowUtil.saveOrSubmit((String)hrmsManagerChangeRegularUpForm.getTaskId(), (String)flowEngineId, (String)hrmsManagerChangeRegularUpForm.getTemplateId(), (String)id, (Object)((Object)hrmsManagerChangeRegularUpForm), (Integer)hrmsManagerChangeRegularUpForm.getStatus(), (String)title);
        }
        return ActionResult.success((String)"\u4fdd\u5b58\u6210\u529f");
    }

    @GetMapping(value={"/changeRegular/{id}"})
    @DSTransactional
    public ActionResult changeRegular(@PathVariable(value="id") String id) throws DataException {
        this.hrmsManagerChangeRegularService.changeRegular(id);
        return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
    }

    @DeleteMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult delete(@PathVariable(value="id") String id) {
        HrmsManagerChangeRegularEntity entity = this.hrmsManagerChangeRegularService.getInfo(id);
        if (entity != null) {
            FlowTaskEntity taskEntity = FlowUtil.getFlowTaskSubmited((String)id, (SFunction[])new SFunction[]{FlowTaskEntity::getId, FlowTaskEntity::getStatus});
            if (taskEntity != null) {
                try {
                    FlowUtil.deleteByProcessId((String)id);
                }
                catch (WorkFlowException e) {
                    e.printStackTrace();
                }
            }
            this.hrmsManagerChangeRegularService.delete(entity);
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }
}

