/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.hrms.controller;

import cn.hutool.core.util.ObjectUtil;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.hrms.entity.HrmsEmployeArchiveEntity;
import com.bringspring.hrms.entity.HrmsManagerDepartEntity;
import com.bringspring.hrms.model.hrmsemployearchive.HrmsEmployeArchiveCrForm;
import com.bringspring.hrms.model.hrmsmanagerdepart.HrmsManagerDepartCrForm;
import com.bringspring.hrms.model.hrmsmanagerdepart.HrmsManagerDepartPagination;
import com.bringspring.hrms.service.HrmsEmployeArchiveService;
import com.bringspring.hrms.service.HrmsManagerDepartService;
import com.bringspring.hrms.util.DepartStatusEnum;
import com.bringspring.system.base.exception.WorkFlowException;
import com.bringspring.system.permission.entity.OrganizeEntity;
import com.bringspring.system.permission.entity.UserEntity;
import com.bringspring.system.permission.service.OrganizeService;
import com.bringspring.system.permission.service.UserService;
import com.bringspring.system.permission.util.BaseDataUtil;
import com.bringspring.workflow.engine.entity.FlowTaskEntity;
import com.bringspring.workflow.engine.util.FlowUtil;
import io.swagger.annotations.Api;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u79bb\u804c\u7533\u8bf7"}, value="hrms")
@RequestMapping(value={"/api/hrms/OaDepart"})
public class HrmsManagerDepartController {
    private static final Logger log = LoggerFactory.getLogger(HrmsManagerDepartController.class);
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private HrmsManagerDepartService hrmsManagerDepartService;
    @Autowired
    private HrmsEmployeArchiveService hrmsEmployeArchiveService;
    @Autowired
    private UserService userService;
    @Autowired
    private OrganizeService organizeService;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody HrmsManagerDepartPagination hrmsManagerDepartPagination) throws IOException {
        List<HrmsManagerDepartEntity> list = this.hrmsManagerDepartService.getList(hrmsManagerDepartPagination);
        List listVO = JsonUtil.getJsonToList(list, HrmsManagerDepartCrForm.class);
        for (HrmsManagerDepartCrForm vo : listVO) {
            vo.setCreatorUserName(this.baseDataUtil.userSelectValues(vo.getCreatorUserId()));
            vo.setHandleUserName(this.baseDataUtil.userSelectValues(vo.getHandleUser()));
            FlowTaskEntity flowTaskEntity = FlowUtil.getFlowTaskSubmited((String)vo.getId(), (SFunction[])new SFunction[]{FlowTaskEntity::getStatus});
            vo.setFlowStateEnableName(DepartStatusEnum.getNameByCode(vo.getFlowStateEnable()));
            if (flowTaskEntity != null) {
                vo.setFlowState(flowTaskEntity.getStatus());
                continue;
            }
            vo.setFlowState(null);
        }
        PageListVO vo = new PageListVO();
        vo.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)hrmsManagerDepartPagination), PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success((Object)vo);
    }

    @PostMapping
    @DSTransactional
    public ActionResult create(@RequestBody @Valid Map<String, Object> crData) throws DataException, WorkFlowException {
        HrmsManagerDepartCrForm hrmsManagerDepartCrForm = (HrmsManagerDepartCrForm)((Object)JsonUtil.getJsonToBean(crData, HrmsManagerDepartCrForm.class));
        String flowEngineId = "509362305017036229";
        String mainId = RandomUtil.uuId();
        UserInfo userInfo = this.userProvider.get();
        HrmsManagerDepartEntity entity = (HrmsManagerDepartEntity)JsonUtil.getJsonToBean((Object)((Object)hrmsManagerDepartCrForm), HrmsManagerDepartEntity.class);
        entity.setId(mainId);
        entity.setEntryCompany(userInfo.getOrganizeId());
        entity.setCreatorDeptId(userInfo.getDepartmentId());
        OrganizeEntity organizeEntity = this.organizeService.getInfo(entity.getCreatorDeptId());
        if (null != organizeEntity) {
            String organizeIdTree = organizeEntity.getOrganizeIdTree();
            String[] organizeIdTreeArray = organizeIdTree.split(",");
            entity.setCreatorDeptOneId(organizeIdTreeArray[2]);
        }
        this.hrmsManagerDepartService.save(entity);
        BeanUtils.copyProperties((Object)entity, (Object)((Object)hrmsManagerDepartCrForm));
        FlowUtil.saveOrSubmit((String)hrmsManagerDepartCrForm.getTaskId(), (String)flowEngineId, (String)hrmsManagerDepartCrForm.getTemplateId(), (String)mainId, (Object)((Object)hrmsManagerDepartCrForm), (Integer)hrmsManagerDepartCrForm.getStatus());
        return ActionResult.success((String)"\u4fdd\u5b58\u6210\u529f");
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<HrmsManagerDepartCrForm> info(@PathVariable(value="id") String id) {
        List<HrmsEmployeArchiveEntity> infoByCode;
        HrmsManagerDepartEntity entity = this.hrmsManagerDepartService.getInfo(id);
        HrmsManagerDepartCrForm vo = (HrmsManagerDepartCrForm)((Object)JsonUtil.getJsonToBean((Object)entity, HrmsManagerDepartCrForm.class));
        vo.setLeaveTypeName(this.baseDataUtil.getDictName(entity.getLeaveType(), "leaveType"));
        ArrayList<HrmsManagerDepartCrForm> list = new ArrayList<HrmsManagerDepartCrForm>();
        list.add(vo);
        this.hrmsManagerDepartService.getNameByCode(list);
        UserEntity infoUser = this.userService.getInfo(vo.getCreatorUserId());
        if (!ObjectUtil.isEmpty((Object)infoUser) && !ObjectUtil.isEmpty(infoByCode = this.hrmsEmployeArchiveService.getInfoByCode(infoUser.getCode()))) {
            List voArchive = JsonUtil.getJsonToList(infoByCode, HrmsEmployeArchiveCrForm.class);
            this.hrmsEmployeArchiveService.getNameByCode(voArchive);
            HrmsEmployeArchiveCrForm hrmsEmployeArchiveCrForm = (HrmsEmployeArchiveCrForm)voArchive.get(0);
            vo.setName(hrmsEmployeArchiveCrForm.getName());
            vo.setUserCode(hrmsEmployeArchiveCrForm.getCode());
            vo.setEntryCompanyName(hrmsEmployeArchiveCrForm.getEntryCompanyName());
            vo.setEntryDepartmentName(hrmsEmployeArchiveCrForm.getEntryDepartmentName());
            vo.setStationName(hrmsEmployeArchiveCrForm.getStationName());
            vo.setCardNumber(hrmsEmployeArchiveCrForm.getCardNumber());
            vo.setCardTypeName(hrmsEmployeArchiveCrForm.getCardTypeName());
        }
        return ActionResult.success((Object)((Object)vo));
    }

    @PutMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid Map<String, Object> upData) throws DataException, WorkFlowException {
        HrmsManagerDepartCrForm oaDepartUpForm = (HrmsManagerDepartCrForm)((Object)JsonUtil.getJsonToBean(upData, HrmsManagerDepartCrForm.class));
        String flowEngineId = "509362305017036229";
        UserInfo userInfo = this.userProvider.get();
        HrmsManagerDepartEntity entity = this.hrmsManagerDepartService.getInfo(id);
        if (entity != null) {
            HrmsManagerDepartEntity subentity = (HrmsManagerDepartEntity)JsonUtil.getJsonToBean((Object)((Object)oaDepartUpForm), HrmsManagerDepartEntity.class);
            this.hrmsManagerDepartService.update(id, subentity);
            FlowUtil.saveOrSubmit((String)oaDepartUpForm.getTaskId(), (String)flowEngineId, (String)oaDepartUpForm.getTemplateId(), (String)id, (Object)((Object)oaDepartUpForm), (Integer)oaDepartUpForm.getStatus());
            return ActionResult.success((String)"\u4fdd\u5b58\u6210\u529f");
        }
        return ActionResult.fail((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
    }

    @PostMapping(value={"/confirmDepart"})
    @DSTransactional
    public ActionResult confirmDepart(@RequestBody @Valid HrmsManagerDepartEntity companyCrForm) throws Exception {
        this.hrmsManagerDepartService.confirmDepart(companyCrForm);
        return ActionResult.success((String)"\u79bb\u804c\u6210\u529f");
    }

    @DeleteMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult delete(@PathVariable(value="id") String id) {
        HrmsManagerDepartEntity entity = this.hrmsManagerDepartService.getInfo(id);
        if (entity != null) {
            FlowTaskEntity taskEntity = FlowUtil.getFlowTaskSubmited((String)id, (SFunction[])new SFunction[]{FlowTaskEntity::getId, FlowTaskEntity::getStatus});
            if (taskEntity != null) {
                try {
                    FlowUtil.deleteByProcessId((String)id);
                }
                catch (WorkFlowException e) {
                    e.printStackTrace();
                }
            }
            this.hrmsManagerDepartService.delete(entity);
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }
}

