/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.hrms.controller;

import cn.hutool.core.util.ObjectUtil;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.DownloadVO;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.hrms.entity.HrmsPerformanceApCbTxjSalEntity;
import com.bringspring.hrms.model.hrmsperformanceapcbtxjsal.HrmsPerformanceApCbTxjSalCrForm;
import com.bringspring.hrms.model.hrmsperformanceapcbtxjsal.HrmsPerformanceApCbTxjSalInfoVO;
import com.bringspring.hrms.model.hrmsperformanceapcbtxjsal.HrmsPerformanceApCbTxjSalPagination;
import com.bringspring.hrms.model.hrmsperformanceapcbtxjsal.HrmsPerformanceApCbTxjSalPaginationExportModel;
import com.bringspring.hrms.model.hrmsperformanceapcbtxjsal.HrmsPerformanceApCbTxjSalUpForm;
import com.bringspring.hrms.service.HrmsPerformanceApCbTxjSalService;
import com.bringspring.hrms.service.HrmsPerformanceHolidayBalancePService;
import com.bringspring.system.message.entity.SynThirdInfoEntity;
import com.bringspring.system.message.service.SynThirdInfoService;
import com.bringspring.system.permission.entity.UserEntity;
import com.bringspring.system.permission.service.UserRelationService;
import com.bringspring.system.permission.service.UserService;
import com.bringspring.system.permission.util.BaseDataUtil;
import com.github.pagehelper.util.StringUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u52a0\u73ed\u8865\u52a9"}, value="hrms")
@RequestMapping(value={"/api/hrms/HrmsPerformanceApCbTxjSal"})
public class HrmsPerformanceApCbTxjSalController {
    private static final Logger log = LoggerFactory.getLogger(HrmsPerformanceApCbTxjSalController.class);
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private SynThirdInfoService synThirdInfoService;
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private UserService userService;
    @Autowired
    private UserRelationService userRelationService;
    @Autowired
    private HrmsPerformanceApCbTxjSalService hrmsPerformanceApCbTxjSalService;
    @Autowired
    private HrmsPerformanceHolidayBalancePService hrmsPerformanceHolidayBalancePService;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody HrmsPerformanceApCbTxjSalPagination hrmsPerformanceApCbTxjSalPagination) throws IOException {
        if (!ObjectUtil.isEmpty((Object)hrmsPerformanceApCbTxjSalPagination.getApplyUserId())) {
            List infoBySysObjIds = this.synThirdInfoService.getInfoBySysObjIds("1", "2", hrmsPerformanceApCbTxjSalPagination.getApplyUserId());
            if (!ObjectUtil.isEmpty((Object)infoBySysObjIds)) {
                String[] split = ((SynThirdInfoEntity)infoBySysObjIds.get(0)).getThirdObjectId().split("/");
                hrmsPerformanceApCbTxjSalPagination.setApplyUserId(split.length > 1 ? split[1] : split[0]);
            } else {
                return ActionResult.fail((String)"\u672a\u67e5\u8be2\u5230\u4f01\u4e1a\u5fae\u4fe1\u5bf9\u5e94\u8d26\u53f7");
            }
        }
        List<HrmsPerformanceApCbTxjSalEntity> list = this.hrmsPerformanceApCbTxjSalService.getList(hrmsPerformanceApCbTxjSalPagination);
        List listVO = JsonUtil.getJsonToList(list, HrmsPerformanceApCbTxjSalInfoVO.class);
        Map<String, String> thirdMap = this.synThirdInfoService.getList("1", "2").stream().filter(v -> !ObjectUtil.isEmpty((Object)v.getSystemObjectId()) && !ObjectUtil.isEmpty((Object)v.getThirdObjectId())).collect(Collectors.toMap(SynThirdInfoEntity::getThirdObjectId, SynThirdInfoEntity::getSystemObjectId, (item1, item2) -> item1));
        listVO.stream().forEach(v -> {
            UserEntity infoUSer = this.userService.getInfo((String)thirdMap.get(v.getApplyUserId()));
            if (!ObjectUtil.isEmpty((Object)infoUSer) && !ObjectUtil.isEmpty((Object)infoUSer.getOrganizeId())) {
                v.setOrgName(this.baseDataUtil.comSelectValues(infoUSer.getOrganizeId()));
            }
        });
        PageListVO vo = new PageListVO();
        vo.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)hrmsPerformanceApCbTxjSalPagination), PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success((Object)vo);
    }

    @PostMapping(value={"/insertTxjSal"})
    public ActionResult insertTxjSal(@RequestBody HrmsPerformanceApCbTxjSalPagination entity) throws IOException {
        if (ObjectUtil.isNotEmpty(entity.getCdateList())) {
            this.hrmsPerformanceApCbTxjSalService.insertTxjSal(entity.getCdateList().get(0), entity.getCdateList().get(1));
        } else {
            Date date = DateUtil.dateAddMonths((Date)DateUtil.getNowDate(), (int)-1);
            this.hrmsPerformanceApCbTxjSalService.insertTxjSal(date, DateUtil.getNowDate());
        }
        return ActionResult.success(null);
    }

    @PostMapping(value={"/updateHoliday"})
    public ActionResult updateHoliday(@RequestBody HrmsPerformanceApCbTxjSalPagination entity) throws IOException {
        if (ObjectUtil.isNotEmpty(entity.getCdateList())) {
            this.hrmsPerformanceApCbTxjSalService.insertTxjSal(entity.getCdateList().get(0), entity.getCdateList().get(1));
            this.hrmsPerformanceHolidayBalancePService.testAddBalance(entity.getCdateList().get(0), entity.getCdateList().get(1));
        } else {
            Date date = DateUtil.dateAddDays((Date)DateUtil.getNowDate(), (int)-40);
            this.hrmsPerformanceApCbTxjSalService.insertTxjSal(date, DateUtil.getNowDate());
            this.hrmsPerformanceHolidayBalancePService.testAddBalance(date, DateUtil.getNowDate());
        }
        return ActionResult.success(null);
    }

    @PostMapping(value={"/testAddBalance"})
    public ActionResult testAddBalance(@RequestBody HrmsPerformanceApCbTxjSalPagination entity) throws IOException {
        Date date = DateUtil.dateAddDays((Date)DateUtil.getNowDate(), (int)-1);
        if (ObjectUtil.isNotEmpty(entity.getCdateList())) {
            this.hrmsPerformanceHolidayBalancePService.testAddBalance(entity.getCdateList().get(0), entity.getCdateList().get(1));
        } else {
            this.hrmsPerformanceHolidayBalancePService.testAddBalance(DateUtil.getBeginDayOfYesterday(), DateUtil.getEndDayOfYesterday());
        }
        return ActionResult.success(null);
    }

    @PostMapping
    @Transactional
    public ActionResult create(@RequestBody @Valid HrmsPerformanceApCbTxjSalCrForm hrmsPerformanceApCbTxjSalCrForm) throws DataException {
        String mainId = RandomUtil.uuId();
        UserInfo userInfo = this.userProvider.get();
        HrmsPerformanceApCbTxjSalEntity entity = (HrmsPerformanceApCbTxjSalEntity)JsonUtil.getJsonToBean((Object)hrmsPerformanceApCbTxjSalCrForm, HrmsPerformanceApCbTxjSalEntity.class);
        this.hrmsPerformanceApCbTxjSalService.save(entity);
        return ActionResult.success((String)"\u521b\u5efa\u6210\u529f");
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<HrmsPerformanceApCbTxjSalInfoVO> info(@PathVariable(value="id") String id) {
        HrmsPerformanceApCbTxjSalEntity entity = this.hrmsPerformanceApCbTxjSalService.getInfo(id);
        HrmsPerformanceApCbTxjSalInfoVO vo = (HrmsPerformanceApCbTxjSalInfoVO)JsonUtil.getJsonToBean((Object)entity, HrmsPerformanceApCbTxjSalInfoVO.class);
        return ActionResult.success((Object)vo);
    }

    @GetMapping(value={"/detail/{id}"})
    public ActionResult<HrmsPerformanceApCbTxjSalInfoVO> detailInfo(@PathVariable(value="id") String id) {
        HrmsPerformanceApCbTxjSalEntity entity = this.hrmsPerformanceApCbTxjSalService.getInfo(id);
        HrmsPerformanceApCbTxjSalInfoVO vo = (HrmsPerformanceApCbTxjSalInfoVO)JsonUtil.getJsonToBean((Object)entity, HrmsPerformanceApCbTxjSalInfoVO.class);
        return ActionResult.success((Object)vo);
    }

    @PutMapping(value={"/{id}"})
    @Transactional
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid HrmsPerformanceApCbTxjSalUpForm hrmsPerformanceApCbTxjSalUpForm) throws DataException {
        UserInfo userInfo = this.userProvider.get();
        HrmsPerformanceApCbTxjSalEntity entity = this.hrmsPerformanceApCbTxjSalService.getInfo(id);
        if (entity != null) {
            HrmsPerformanceApCbTxjSalEntity subentity = (HrmsPerformanceApCbTxjSalEntity)JsonUtil.getJsonToBean((Object)hrmsPerformanceApCbTxjSalUpForm, HrmsPerformanceApCbTxjSalEntity.class);
            this.hrmsPerformanceApCbTxjSalService.update(id, subentity);
            return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
        }
        return ActionResult.fail((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
    }

    @DeleteMapping(value={"/{id}"})
    @Transactional
    public ActionResult delete(@PathVariable(value="id") String id) {
        HrmsPerformanceApCbTxjSalEntity entity = this.hrmsPerformanceApCbTxjSalService.getInfo(id);
        if (entity != null) {
            this.hrmsPerformanceApCbTxjSalService.delete(entity);
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }

    @ApiOperation(value="\u5bfc\u51faExcel")
    @GetMapping(value={"/Actions/Export"})
    public ActionResult Export(HrmsPerformanceApCbTxjSalPaginationExportModel hrmsPerformanceCheckinPaginationExportModel) throws IOException {
        if (StringUtil.isEmpty((String)hrmsPerformanceCheckinPaginationExportModel.getSelectKey())) {
            return ActionResult.fail((String)"\u8bf7\u9009\u62e9\u5bfc\u51fa\u5b57\u6bb5");
        }
        if (!ObjectUtil.isEmpty((Object)hrmsPerformanceCheckinPaginationExportModel.getUserid())) {
            List infoBySysObjIds = this.synThirdInfoService.getInfoBySysObjIds("1", "2", hrmsPerformanceCheckinPaginationExportModel.getUserid());
            if (!ObjectUtil.isEmpty((Object)infoBySysObjIds)) {
                String[] split = ((SynThirdInfoEntity)infoBySysObjIds.get(0)).getThirdObjectId().split("/");
                hrmsPerformanceCheckinPaginationExportModel.setUserid(split.length > 1 ? split[1] : split[0]);
            } else {
                return ActionResult.fail((String)"\u672a\u67e5\u8be2\u5230\u4f01\u4e1a\u5fae\u4fe1\u5bf9\u5e94\u8d26\u53f7");
            }
        }
        DownloadVO vo = this.hrmsPerformanceApCbTxjSalService.exportData(hrmsPerformanceCheckinPaginationExportModel);
        return ActionResult.success((Object)vo);
    }
}

