/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.hrms.controller;

import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.hrms.entity.HrmsPerformanceDepAnnualEvaluateEntity;
import com.bringspring.hrms.entity.HrmsPerformancePointsEntity;
import com.bringspring.hrms.entity.HrmsPerformanceTotalPointEntity;
import com.bringspring.hrms.model.hrmsperformancetotalpoint.HrmsPerformanceTotalPointCrForm;
import com.bringspring.hrms.model.hrmsperformancetotalpoint.HrmsPerformanceTotalPointInfoVO;
import com.bringspring.hrms.model.hrmsperformancetotalpoint.HrmsPerformanceTotalPointListVO;
import com.bringspring.hrms.model.hrmsperformancetotalpoint.HrmsPerformanceTotalPointPagination;
import com.bringspring.hrms.model.hrmsperformancetotalpoint.HrmsPerformanceTotalPointUpForm;
import com.bringspring.hrms.service.HrmsPerformanceDepAnnualvaluateService;
import com.bringspring.hrms.service.HrmsPerformanceDepQuarterEvaluateService;
import com.bringspring.hrms.service.HrmsPerformancePointsService;
import com.bringspring.hrms.service.HrmsPerformanceTotalPointService;
import com.bringspring.system.base.exception.WorkFlowException;
import com.bringspring.system.permission.util.BaseDataUtil;
import com.bringspring.workflow.engine.entity.FlowTaskEntity;
import com.bringspring.workflow.engine.util.FlowUtil;
import io.swagger.annotations.Api;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u90e8\u95e8\u5b63\u5ea6\u7ee9\u6548\u8bc4\u5206"}, value="hrms")
@RequestMapping(value={"/api/hrms/OaHrDepQuarterEvaluate"})
public class HrmsPerformanceDepQuarterEvaluateController {
    private static final Logger log = LoggerFactory.getLogger(HrmsPerformanceDepQuarterEvaluateController.class);
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private HrmsPerformanceDepQuarterEvaluateService hrmsPerformanceDepQuarterEvaluateService;
    @Autowired
    private HrmsPerformanceTotalPointService hrmsPerformanceTotalPointService;
    @Autowired
    private HrmsPerformanceDepAnnualvaluateService hrmsPerformanceDepAnnualvaluateService;
    @Autowired
    private HrmsPerformancePointsService hrmsPerformancePointsService;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody HrmsPerformanceTotalPointPagination hrmsPerformanceTotalPointPagination) throws IOException {
        List<HrmsPerformanceTotalPointEntity> list = this.hrmsPerformanceDepQuarterEvaluateService.getList(hrmsPerformanceTotalPointPagination);
        for (HrmsPerformanceTotalPointEntity hrmsPerformanceTotalPointEntity : list) {
            hrmsPerformanceTotalPointEntity.setType(this.baseDataUtil.getDictName(hrmsPerformanceTotalPointEntity.getType(), "510104426388901317"));
        }
        List listVO = JsonUtil.getJsonToList(list, HrmsPerformanceTotalPointListVO.class);
        for (HrmsPerformanceTotalPointListVO vo : listVO) {
            FlowTaskEntity flowTaskEntity = FlowUtil.getFlowTaskSubmited((String)vo.getId(), (SFunction[])new SFunction[]{FlowTaskEntity::getStatus});
            if (flowTaskEntity != null) {
                vo.setFlowState(flowTaskEntity.getStatus());
            } else {
                vo.setFlowState(null);
            }
            vo.setApplyPersonName(this.baseDataUtil.userSelectValue(vo.getApplyPerson()));
            vo.setApplyDepartmentName(this.baseDataUtil.comSelectValues(vo.getApplyDepartment()));
        }
        PageListVO pageListVO = new PageListVO();
        pageListVO.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)hrmsPerformanceTotalPointPagination), PaginationVO.class);
        pageListVO.setPagination(page);
        return ActionResult.success((Object)pageListVO);
    }

    @PostMapping
    @DSTransactional
    public ActionResult create(@RequestBody @Valid Map<String, Object> crData) throws DataException, WorkFlowException {
        HrmsPerformanceTotalPointCrForm hrmsPerformanceTotalPointCrForm = (HrmsPerformanceTotalPointCrForm)((Object)JsonUtil.getJsonToBean(crData, HrmsPerformanceTotalPointCrForm.class));
        String flowEngineId = "511814674912893317";
        String mainId = RandomUtil.uuId();
        UserInfo userInfo = this.userProvider.get();
        HrmsPerformanceTotalPointEntity entity = (HrmsPerformanceTotalPointEntity)JsonUtil.getJsonToBean((Object)((Object)hrmsPerformanceTotalPointCrForm), HrmsPerformanceTotalPointEntity.class);
        entity.setId(mainId);
        entity.setDocumentationMark(0);
        Boolean repeat = this.hrmsPerformanceTotalPointService.judgeSubmitPerformanceRepeat(hrmsPerformanceTotalPointCrForm);
        if (repeat.booleanValue()) {
            return ActionResult.success((String)"duplication");
        }
        this.hrmsPerformanceDepQuarterEvaluateService.save(entity);
        List jsonToList = JsonUtil.getJsonToList(hrmsPerformanceTotalPointCrForm.getOaHrDepAnnualPerformanceEvaluatelist(), HrmsPerformanceDepAnnualEvaluateEntity.class);
        List hrmsPerformancePointsEntityList = JsonUtil.getJsonToList(hrmsPerformanceTotalPointCrForm.getOaHrPerformancePointsList(), HrmsPerformancePointsEntity.class);
        for (Object entitys : jsonToList) {
            ((HrmsPerformanceDepAnnualEvaluateEntity)entitys).setId(RandomUtil.uuId());
            ((HrmsPerformanceDepAnnualEvaluateEntity)entitys).setPrimaryId(entity.getId());
            this.hrmsPerformanceDepAnnualvaluateService.save(entitys);
        }
        for (Object entitys : hrmsPerformancePointsEntityList) {
            ((HrmsPerformancePointsEntity)entitys).setId(RandomUtil.uuId());
            ((HrmsPerformancePointsEntity)entitys).setPrimaryId(entity.getId());
            this.hrmsPerformancePointsService.save(entitys);
        }
        hrmsPerformanceTotalPointCrForm.setApplyDepartment(this.baseDataUtil.comSelectValues(entity.getApplyDepartment()));
        FlowUtil.saveOrSubmit((String)hrmsPerformanceTotalPointCrForm.getTaskId(), (String)flowEngineId, (String)hrmsPerformanceTotalPointCrForm.getTemplateId(), (String)mainId, (Object)((Object)hrmsPerformanceTotalPointCrForm), (Integer)hrmsPerformanceTotalPointCrForm.getStatus());
        return ActionResult.success((String)"\u4fdd\u5b58\u6210\u529f");
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<HrmsPerformanceTotalPointInfoVO> info(@PathVariable(value="id") String id) {
        HrmsPerformanceTotalPointEntity entity = this.hrmsPerformanceDepQuarterEvaluateService.getInfo(id);
        HrmsPerformanceTotalPointInfoVO vo = (HrmsPerformanceTotalPointInfoVO)JsonUtil.getJsonToBean((Object)entity, HrmsPerformanceTotalPointInfoVO.class);
        List<HrmsPerformanceDepAnnualEvaluateEntity> Oa_hr_dep_annual_performance_evaluateList = this.hrmsPerformanceDepQuarterEvaluateService.getAnnualPerformanceEvaluateList(id);
        List<HrmsPerformancePointsEntity> quarterPerformancePointList = this.hrmsPerformanceDepQuarterEvaluateService.getQuarterPerformancePointList(id);
        vo.setOaHrDepAnnualPerformanceEvaluateEntities(JsonUtil.getJsonToList(Oa_hr_dep_annual_performance_evaluateList, HrmsPerformanceDepAnnualEvaluateEntity.class));
        vo.setOaHrPerformancePointsList(JsonUtil.getJsonToList(quarterPerformancePointList, HrmsPerformancePointsEntity.class));
        vo.setApplyPersonName(this.baseDataUtil.userSelectValue(vo.getApplyPerson()));
        vo.setApplyDepartmentName(this.baseDataUtil.comSelectValues(vo.getApplyDepartment()));
        List<HrmsPerformancePointsEntity> hrmsPerformancePointsEntityList = this.hrmsPerformancePointsService.getoaHrPerformancePointsList(id);
        vo.setOaHrPerformancePointsList(hrmsPerformancePointsEntityList);
        return ActionResult.success((Object)vo);
    }

    @PutMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid Map<String, Object> upData) throws DataException, WorkFlowException {
        HrmsPerformanceTotalPointUpForm hrmsPerformanceTotalPointUpForm = (HrmsPerformanceTotalPointUpForm)((Object)JsonUtil.getJsonToBean(upData, HrmsPerformanceTotalPointUpForm.class));
        String flowEngineId = "511814674912893317";
        UserInfo userInfo = this.userProvider.get();
        HrmsPerformanceTotalPointEntity entity = this.hrmsPerformanceDepQuarterEvaluateService.getInfo(id);
        if (entity != null) {
            HrmsPerformanceTotalPointEntity subentity = (HrmsPerformanceTotalPointEntity)JsonUtil.getJsonToBean((Object)((Object)hrmsPerformanceTotalPointUpForm), HrmsPerformanceTotalPointEntity.class);
            this.hrmsPerformanceDepQuarterEvaluateService.update(id, subentity);
            QueryWrapper Oa_hr_dep_annual_performance_evaluatequeryWrapper = new QueryWrapper();
            Oa_hr_dep_annual_performance_evaluatequeryWrapper.lambda().eq(HrmsPerformanceDepAnnualEvaluateEntity::getPrimaryId, (Object)entity.getId());
            this.hrmsPerformanceDepAnnualvaluateService.remove((Wrapper)Oa_hr_dep_annual_performance_evaluatequeryWrapper);
            QueryWrapper oaHrPerformancePointsEntityQueryWrapper = new QueryWrapper();
            oaHrPerformancePointsEntityQueryWrapper.lambda().eq(HrmsPerformancePointsEntity::getPrimaryId, (Object)entity.getId());
            this.hrmsPerformancePointsService.remove((Wrapper)oaHrPerformancePointsEntityQueryWrapper);
            List Oa_hr_dep_annual_performance_evaluateList = JsonUtil.getJsonToList(hrmsPerformanceTotalPointUpForm.getOaHrDepAnnualPerformanceEvaluatelist(), HrmsPerformanceDepAnnualEvaluateEntity.class);
            for (HrmsPerformanceDepAnnualEvaluateEntity entitys : Oa_hr_dep_annual_performance_evaluateList) {
                entitys.setId(RandomUtil.uuId());
                entitys.setPrimaryId(entity.getId());
                this.hrmsPerformanceDepAnnualvaluateService.save(entitys);
            }
            List hrmsPerformancePointsEntityList = JsonUtil.getJsonToList(hrmsPerformanceTotalPointUpForm.getOaHrPerformancePointsList(), HrmsPerformancePointsEntity.class);
            for (HrmsPerformancePointsEntity entitys : hrmsPerformancePointsEntityList) {
                entitys.setId(RandomUtil.uuId());
                entitys.setPrimaryId(entity.getId());
                this.hrmsPerformancePointsService.save(entitys);
            }
            FlowUtil.saveOrSubmit((String)hrmsPerformanceTotalPointUpForm.getTaskId(), (String)flowEngineId, (String)hrmsPerformanceTotalPointUpForm.getTemplateId(), (String)id, (Object)((Object)hrmsPerformanceTotalPointUpForm), (Integer)hrmsPerformanceTotalPointUpForm.getStatus());
            return ActionResult.success((String)"\u4fdd\u5b58\u6210\u529f");
        }
        return ActionResult.fail((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
    }

    @DeleteMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult delete(@PathVariable(value="id") String id) {
        HrmsPerformanceTotalPointEntity entity = this.hrmsPerformanceDepQuarterEvaluateService.getInfo(id);
        if (entity != null) {
            FlowTaskEntity taskEntity = FlowUtil.getFlowTaskSubmited((String)id, (SFunction[])new SFunction[]{FlowTaskEntity::getId, FlowTaskEntity::getStatus});
            if (taskEntity != null) {
                try {
                    FlowUtil.deleteByProcessId((String)id);
                }
                catch (WorkFlowException e) {
                    e.printStackTrace();
                }
            }
            this.hrmsPerformanceDepQuarterEvaluateService.delete(entity);
            QueryWrapper queryWrapperOa_hr_dep_annual_performance_evaluate = new QueryWrapper();
            queryWrapperOa_hr_dep_annual_performance_evaluate.lambda().eq(HrmsPerformanceDepAnnualEvaluateEntity::getPrimaryId, (Object)entity.getId());
            this.hrmsPerformanceDepAnnualvaluateService.remove((Wrapper)queryWrapperOa_hr_dep_annual_performance_evaluate);
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }
}

