/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.hrms.controller;

import cn.hutool.core.util.ObjectUtil;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.hrms.entity.HrmsPerformanceHolidayBalanceEntity;
import com.bringspring.hrms.model.hrmsperformanceholidaybalance.HrmsPerformanceHolidayBalanceCrForm;
import com.bringspring.hrms.model.hrmsperformanceholidaybalance.HrmsPerformanceHolidayBalanceInfoVO;
import com.bringspring.hrms.model.hrmsperformanceholidaybalance.HrmsPerformanceHolidayBalanceListVO;
import com.bringspring.hrms.model.hrmsperformanceholidaybalance.HrmsPerformanceHolidayBalancePagination;
import com.bringspring.hrms.model.hrmsperformanceholidaybalance.HrmsPerformanceHolidayBalanceUpForm;
import com.bringspring.hrms.service.HrmsPerformanceHolidayBalanceService;
import com.bringspring.system.message.entity.SynThirdInfoEntity;
import com.bringspring.system.message.service.SynThirdInfoService;
import io.swagger.annotations.Api;
import java.io.IOException;
import java.util.List;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u8003\u52e4\u5047\u671f"}, value="hrms")
@RequestMapping(value={"/api/hrms/HrmsPerformanceHolidayBalance"})
public class HrmsPerformanceHolidayBalanceController {
    private static final Logger log = LoggerFactory.getLogger(HrmsPerformanceHolidayBalanceController.class);
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private HrmsPerformanceHolidayBalanceService hrmsPerformanceHolidayBalanceService;
    @Autowired
    private SynThirdInfoService synThirdInfoService;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody HrmsPerformanceHolidayBalancePagination hrmsPerformanceHolidayBalancePagination) throws IOException {
        List infoBySysObjIds;
        if (!ObjectUtil.isEmpty((Object)hrmsPerformanceHolidayBalancePagination.getUserid()) && !ObjectUtil.isEmpty((Object)(infoBySysObjIds = this.synThirdInfoService.getInfoBySysObjIds("1", "2", hrmsPerformanceHolidayBalancePagination.getUserid())))) {
            String[] split = ((SynThirdInfoEntity)infoBySysObjIds.get(0)).getThirdObjectId().split("/");
            hrmsPerformanceHolidayBalancePagination.setUserid(split.length > 1 ? split[1] : split[0]);
        }
        List<HrmsPerformanceHolidayBalanceEntity> list = this.hrmsPerformanceHolidayBalanceService.getList(hrmsPerformanceHolidayBalancePagination);
        List listVO = JsonUtil.getJsonToList(list, HrmsPerformanceHolidayBalanceListVO.class);
        PageListVO vo = new PageListVO();
        vo.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)hrmsPerformanceHolidayBalancePagination), PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success((Object)vo);
    }

    @PostMapping
    @Transactional
    public ActionResult create(@RequestBody @Valid HrmsPerformanceHolidayBalanceCrForm hrmsPerformanceHolidayBalanceCrForm) throws DataException {
        String mainId = RandomUtil.uuId();
        UserInfo userInfo = this.userProvider.get();
        HrmsPerformanceHolidayBalanceEntity entity = (HrmsPerformanceHolidayBalanceEntity)JsonUtil.getJsonToBean((Object)hrmsPerformanceHolidayBalanceCrForm, HrmsPerformanceHolidayBalanceEntity.class);
        this.hrmsPerformanceHolidayBalanceService.save(entity);
        return ActionResult.success((String)"\u521b\u5efa\u6210\u529f");
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<HrmsPerformanceHolidayBalanceInfoVO> info(@PathVariable(value="id") String id) {
        HrmsPerformanceHolidayBalanceEntity entity = this.hrmsPerformanceHolidayBalanceService.getInfo(id);
        HrmsPerformanceHolidayBalanceInfoVO vo = (HrmsPerformanceHolidayBalanceInfoVO)JsonUtil.getJsonToBean((Object)entity, HrmsPerformanceHolidayBalanceInfoVO.class);
        return ActionResult.success((Object)vo);
    }

    @GetMapping(value={"/detail/{id}"})
    public ActionResult<HrmsPerformanceHolidayBalanceInfoVO> detailInfo(@PathVariable(value="id") String id) {
        HrmsPerformanceHolidayBalanceEntity entity = this.hrmsPerformanceHolidayBalanceService.getInfo(id);
        HrmsPerformanceHolidayBalanceInfoVO vo = (HrmsPerformanceHolidayBalanceInfoVO)JsonUtil.getJsonToBean((Object)entity, HrmsPerformanceHolidayBalanceInfoVO.class);
        return ActionResult.success((Object)vo);
    }

    @PutMapping(value={"/{id}"})
    @Transactional
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid HrmsPerformanceHolidayBalanceUpForm hrmsPerformanceHolidayBalanceUpForm) throws DataException {
        UserInfo userInfo = this.userProvider.get();
        HrmsPerformanceHolidayBalanceEntity entity = this.hrmsPerformanceHolidayBalanceService.getInfo(id);
        if (entity != null) {
            HrmsPerformanceHolidayBalanceEntity subentity = (HrmsPerformanceHolidayBalanceEntity)JsonUtil.getJsonToBean((Object)hrmsPerformanceHolidayBalanceUpForm, HrmsPerformanceHolidayBalanceEntity.class);
            this.hrmsPerformanceHolidayBalanceService.update(id, subentity);
            return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
        }
        return ActionResult.fail((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
    }

    @DeleteMapping(value={"/{id}"})
    @Transactional
    public ActionResult delete(@PathVariable(value="id") String id) {
        HrmsPerformanceHolidayBalanceEntity entity = this.hrmsPerformanceHolidayBalanceService.getInfo(id);
        if (entity != null) {
            this.hrmsPerformanceHolidayBalanceService.delete(entity);
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }
}

