/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.hrms.controller;

import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UserProvider;
import com.bringspring.hrms.entity.HrmsPerformancePerformanceQuarterDetailEntity;
import com.bringspring.hrms.entity.HrmsPerformanceQuarterEntity;
import com.bringspring.hrms.model.hrmsperformancequarter.HrmsPerformanceQuarterCrForm;
import com.bringspring.hrms.model.hrmsperformancequarter.HrmsPerformanceQuarterDetailModel;
import com.bringspring.hrms.model.hrmsperformancequarter.HrmsPerformanceQuarterInfoVO;
import com.bringspring.hrms.model.hrmsperformancequarter.HrmsPerformanceQuarterListVO;
import com.bringspring.hrms.model.hrmsperformancequarter.HrmsPerformanceQuarterPagination;
import com.bringspring.hrms.model.hrmsperformancequarter.HrmsPerformanceQuarterUpForm;
import com.bringspring.hrms.service.HrmsPerformanceQuarterDetailService;
import com.bringspring.hrms.service.HrmsPerformanceQuarterService;
import com.bringspring.oa.entity.OaAnnualPerformanceFormAttachmentEntity;
import com.bringspring.oa.service.OaAnnualPerformanceFormAttachmentService;
import com.bringspring.system.base.exception.WorkFlowException;
import com.bringspring.system.permission.util.BaseDataUtil;
import com.bringspring.workflow.engine.entity.FlowTaskEntity;
import com.bringspring.workflow.engine.util.FlowUtil;
import io.swagger.annotations.Api;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u5b63\u5ea6\u8003\u6838\u8868"}, value="hrms")
@RequestMapping(value={"/api/hrms/OaHrPerformanceQuarter"})
public class HrmsPerformanceQuarterController {
    private static final Logger log = LoggerFactory.getLogger(HrmsPerformanceQuarterController.class);
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private HrmsPerformanceQuarterService oahrperformancequarterService;
    @Autowired
    private HrmsPerformanceQuarterDetailService hrmsPerformanceQuarterDetailService;
    @Autowired
    private OaAnnualPerformanceFormAttachmentService oaAnnualPerformanceFormAttachmentService;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody HrmsPerformanceQuarterPagination oahrperformancequarterPagination) throws IOException {
        List<HrmsPerformanceQuarterEntity> list = this.oahrperformancequarterService.getList(oahrperformancequarterPagination);
        for (HrmsPerformanceQuarterEntity hrmsPerformanceQuarterEntity : list) {
            hrmsPerformanceQuarterEntity.setDeptId(this.baseDataUtil.comSelectValues(hrmsPerformanceQuarterEntity.getDeptId()));
            hrmsPerformanceQuarterEntity.setCreatorUserId(this.baseDataUtil.userSelectValue(hrmsPerformanceQuarterEntity.getCreatorUserId()));
        }
        List listVO = JsonUtil.getJsonToList(list, HrmsPerformanceQuarterListVO.class);
        for (HrmsPerformanceQuarterListVO vo : listVO) {
            FlowTaskEntity flowTaskEntity = FlowUtil.getFlowTaskSubmited((String)vo.getId(), (SFunction[])new SFunction[]{FlowTaskEntity::getStatus});
            if (flowTaskEntity != null) {
                vo.setFlowState(flowTaskEntity.getStatus());
                continue;
            }
            vo.setFlowState(null);
        }
        PageListVO pageListVO = new PageListVO();
        pageListVO.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)oahrperformancequarterPagination), PaginationVO.class);
        pageListVO.setPagination(page);
        return ActionResult.success((Object)pageListVO);
    }

    @PostMapping
    @DSTransactional
    public ActionResult create(@RequestBody @Valid Map<String, Object> crData) throws DataException, WorkFlowException {
        HrmsPerformanceQuarterCrForm oahrperformancequarterCrForm = (HrmsPerformanceQuarterCrForm)((Object)JsonUtil.getJsonToBean(crData, HrmsPerformanceQuarterCrForm.class));
        String flowEngineId = "503922883844637445";
        String mainId = RandomUtil.uuId();
        UserInfo userInfo = this.userProvider.get();
        oahrperformancequarterCrForm.setCreatorUserId(userInfo.getUserId());
        oahrperformancequarterCrForm.setCreatorTime(DateUtil.getNow());
        HrmsPerformanceQuarterEntity entity = (HrmsPerformanceQuarterEntity)JsonUtil.getJsonToBean((Object)((Object)oahrperformancequarterCrForm), HrmsPerformanceQuarterEntity.class);
        entity.setId(mainId);
        this.oahrperformancequarterService.save(entity);
        List OaHrPerformanceQuarterDetailList = JsonUtil.getJsonToList(oahrperformancequarterCrForm.getOahrperformancequarterList(), HrmsPerformancePerformanceQuarterDetailEntity.class);
        for (HrmsPerformancePerformanceQuarterDetailEntity entitys : OaHrPerformanceQuarterDetailList) {
            entitys.setId(RandomUtil.uuId());
            entitys.setParentId(entity.getId());
            this.hrmsPerformanceQuarterDetailService.save(entitys);
        }
        FlowUtil.saveOrSubmit((String)oahrperformancequarterCrForm.getTaskId(), (String)flowEngineId, (String)oahrperformancequarterCrForm.getTemplateId(), (String)mainId, (Object)((Object)oahrperformancequarterCrForm), (Integer)oahrperformancequarterCrForm.getStatus());
        return ActionResult.success((String)"\u4fdd\u5b58\u6210\u529f");
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<HrmsPerformanceQuarterInfoVO> info(@PathVariable(value="id") String id) {
        HrmsPerformanceQuarterEntity entity = this.oahrperformancequarterService.getInfo(id);
        HrmsPerformanceQuarterInfoVO vo = (HrmsPerformanceQuarterInfoVO)JsonUtil.getJsonToBean((Object)entity, HrmsPerformanceQuarterInfoVO.class);
        vo.setCreatorUserId(this.baseDataUtil.userSelectValue(vo.getCreatorUserId()));
        if (vo.getCreatorTime() != null) {
            vo.setCreatorTime(vo.getCreatorTime());
        }
        List<HrmsPerformancePerformanceQuarterDetailEntity> OaHrPerformanceQuarterDetailList = this.oahrperformancequarterService.GetOaHrPerformanceQuarterDetailList(id);
        List hrmsPerformanceQuarterDetailModelList = JsonUtil.getJsonToList(OaHrPerformanceQuarterDetailList, HrmsPerformanceQuarterDetailModel.class);
        for (HrmsPerformanceQuarterDetailModel hrmsPerformanceQuarterDetailModel : hrmsPerformanceQuarterDetailModelList) {
            String yearId = hrmsPerformanceQuarterDetailModel.getYearId();
            if (!StringUtils.isNotEmpty((String)yearId)) continue;
            OaAnnualPerformanceFormAttachmentEntity oa1 = (OaAnnualPerformanceFormAttachmentEntity)this.oaAnnualPerformanceFormAttachmentService.getById((Serializable)((Object)yearId));
            hrmsPerformanceQuarterDetailModel.setYearTarget(oa1.getAnnualTarget());
            hrmsPerformanceQuarterDetailModel.setYearPercent(oa1.getTargetWeight() == null ? "" : oa1.getTargetWeight().toString());
            hrmsPerformanceQuarterDetailModel.setYearDataProvision(oa1.getDataProvision());
            hrmsPerformanceQuarterDetailModel.setYearKeyDescription(oa1.getKeyResultDescription());
        }
        vo.setOahrperformancequarterList(hrmsPerformanceQuarterDetailModelList);
        return ActionResult.success((Object)vo);
    }

    @PutMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid Map<String, Object> upData) throws DataException, WorkFlowException {
        HrmsPerformanceQuarterUpForm oahrperformancequarterUpForm = (HrmsPerformanceQuarterUpForm)((Object)JsonUtil.getJsonToBean(upData, HrmsPerformanceQuarterUpForm.class));
        String flowEngineId = "503922883844637445";
        UserInfo userInfo = this.userProvider.get();
        HrmsPerformanceQuarterEntity entity = this.oahrperformancequarterService.getInfo(id);
        if (entity != null) {
            HrmsPerformanceQuarterEntity subentity = (HrmsPerformanceQuarterEntity)JsonUtil.getJsonToBean((Object)((Object)oahrperformancequarterUpForm), HrmsPerformanceQuarterEntity.class);
            subentity.setCreatorUserId(entity.getCreatorUserId());
            subentity.setCreatorTime(entity.getCreatorTime());
            this.oahrperformancequarterService.update(id, subentity);
            QueryWrapper OaHrPerformanceQuarterDetailqueryWrapper = new QueryWrapper();
            OaHrPerformanceQuarterDetailqueryWrapper.lambda().eq(HrmsPerformancePerformanceQuarterDetailEntity::getParentId, (Object)entity.getId());
            this.hrmsPerformanceQuarterDetailService.remove((Wrapper)OaHrPerformanceQuarterDetailqueryWrapper);
            List OaHrPerformanceQuarterDetailList = JsonUtil.getJsonToList(oahrperformancequarterUpForm.getOahrperformancequarterList(), HrmsPerformancePerformanceQuarterDetailEntity.class);
            for (HrmsPerformancePerformanceQuarterDetailEntity entitys : OaHrPerformanceQuarterDetailList) {
                entitys.setId(RandomUtil.uuId());
                entitys.setParentId(entity.getId());
                this.hrmsPerformanceQuarterDetailService.save(entitys);
            }
            FlowUtil.saveOrSubmit((String)oahrperformancequarterUpForm.getTaskId(), (String)flowEngineId, (String)oahrperformancequarterUpForm.getTemplateId(), (String)id, (Object)((Object)oahrperformancequarterUpForm), (Integer)oahrperformancequarterUpForm.getStatus());
            return ActionResult.success((String)"\u4fdd\u5b58\u6210\u529f");
        }
        return ActionResult.fail((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
    }

    @DeleteMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult delete(@PathVariable(value="id") String id) {
        HrmsPerformanceQuarterEntity entity = this.oahrperformancequarterService.getInfo(id);
        if (entity != null) {
            FlowTaskEntity taskEntity = FlowUtil.getFlowTaskSubmited((String)id, (SFunction[])new SFunction[]{FlowTaskEntity::getId, FlowTaskEntity::getStatus});
            if (taskEntity != null) {
                try {
                    FlowUtil.deleteByProcessId((String)id);
                }
                catch (WorkFlowException e) {
                    e.printStackTrace();
                }
            }
            this.oahrperformancequarterService.delete(entity);
            QueryWrapper queryWrapperOaHrPerformanceQuarterDetail = new QueryWrapper();
            queryWrapperOaHrPerformanceQuarterDetail.lambda().eq(HrmsPerformancePerformanceQuarterDetailEntity::getParentId, (Object)entity.getId());
            this.hrmsPerformanceQuarterDetailService.remove((Wrapper)queryWrapperOaHrPerformanceQuarterDetail);
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }
}

