/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.hrms.service.impl;

import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.util.ServletUtils;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UserProvider;
import com.bringspring.hrms.entity.HrmsEmployeArchiveEducationEntity;
import com.bringspring.hrms.mapper.HrmsEmployeArchiveEducationMapper;
import com.bringspring.hrms.model.hrmsemployearchiveeducation.HrmsEmployeArchiveEducationCrForm;
import com.bringspring.hrms.model.hrmsemployearchiveeducation.HrmsEmployeArchiveEducationPagination;
import com.bringspring.hrms.model.hrmsmanagerentrycompany.HrmsManagerEntryCompanyCrForm;
import com.bringspring.hrms.service.HrmsEmployeArchiveEducationService;
import com.bringspring.system.permission.entity.OrganizeEntity;
import com.bringspring.system.permission.entity.PositionEntity;
import com.bringspring.system.permission.model.authorize.AuthorizeConditionModel;
import com.bringspring.system.permission.service.AuthorizeService;
import com.bringspring.system.permission.service.OrganizeService;
import com.bringspring.system.permission.service.PositionService;
import com.bringspring.system.permission.util.BaseDataUtil;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class HrmsEmployeArchiveEducationServiceImpl
extends ServiceImpl<HrmsEmployeArchiveEducationMapper, HrmsEmployeArchiveEducationEntity>
implements HrmsEmployeArchiveEducationService {
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private AuthorizeService authorizeService;
    @Autowired
    private OrganizeService organizeService;
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private PositionService positionService;

    @Override
    public List<HrmsEmployeArchiveEducationEntity> getList(HrmsEmployeArchiveEducationPagination hrmsEmployeArchiveEducationPagination) {
        Object oaArchiveEducationObj;
        String userId = this.userProvider.get().getUserId();
        ArrayList AllIdList = new ArrayList();
        int total = 0;
        int oaArchiveEducationNum = 0;
        QueryWrapper oaArchiveEducationQueryWrapper = new QueryWrapper();
        boolean pcPermission = false;
        boolean appPermission = false;
        boolean isPc = ServletUtils.getHeader((String)"jsbos-origin").equals("pc");
        if (isPc && pcPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            oaArchiveEducationObj = this.authorizeService.getCondition(new AuthorizeConditionModel(oaArchiveEducationQueryWrapper, hrmsEmployeArchiveEducationPagination.getMenuId(), "oaArchiveEducation"));
            if (ObjectUtil.isEmpty((Object)oaArchiveEducationObj)) {
                return new ArrayList<HrmsEmployeArchiveEducationEntity>();
            }
            oaArchiveEducationQueryWrapper = (QueryWrapper)oaArchiveEducationObj;
            ++oaArchiveEducationNum;
        }
        if (!isPc && appPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            oaArchiveEducationObj = this.authorizeService.getCondition(new AuthorizeConditionModel(oaArchiveEducationQueryWrapper, hrmsEmployeArchiveEducationPagination.getMenuId(), "oaArchiveEducation"));
            if (ObjectUtil.isEmpty((Object)oaArchiveEducationObj)) {
                return new ArrayList<HrmsEmployeArchiveEducationEntity>();
            }
            oaArchiveEducationQueryWrapper = (QueryWrapper)oaArchiveEducationObj;
            ++oaArchiveEducationNum;
        }
        if (StringUtils.isNotEmpty((String)hrmsEmployeArchiveEducationPagination.getArchiveId())) {
            ++oaArchiveEducationNum;
            oaArchiveEducationQueryWrapper.lambda().like(HrmsEmployeArchiveEducationEntity::getArchiveId, (Object)hrmsEmployeArchiveEducationPagination.getArchiveId());
        }
        if (StringUtils.isNotEmpty((String)hrmsEmployeArchiveEducationPagination.getEducation())) {
            ++oaArchiveEducationNum;
            oaArchiveEducationQueryWrapper.lambda().like(HrmsEmployeArchiveEducationEntity::getEducation, (Object)hrmsEmployeArchiveEducationPagination.getEducation());
        }
        if (AllIdList.size() > 0) {
            oaArchiveEducationQueryWrapper.lambda().in(HrmsEmployeArchiveEducationEntity::getId, AllIdList);
        }
        if (StringUtils.isEmpty((String)hrmsEmployeArchiveEducationPagination.getSidx())) {
            oaArchiveEducationQueryWrapper.lambda().orderByDesc(HrmsEmployeArchiveEducationEntity::getId);
        } else {
            try {
                String sidx = hrmsEmployeArchiveEducationPagination.getSidx();
                HrmsEmployeArchiveEducationEntity oaArchiveEducationEntity = new HrmsEmployeArchiveEducationEntity();
                Field declaredField = oaArchiveEducationEntity.getClass().getDeclaredField(sidx);
                declaredField.setAccessible(true);
                String value = declaredField.getAnnotation(TableField.class).value();
                oaArchiveEducationQueryWrapper = "asc".equals(hrmsEmployeArchiveEducationPagination.getSort().toLowerCase()) ? (QueryWrapper)oaArchiveEducationQueryWrapper.orderByAsc((Object)value) : (QueryWrapper)oaArchiveEducationQueryWrapper.orderByDesc((Object)value);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if (total > 0 && AllIdList.size() > 0 || total == 0) {
            Page page = new Page(hrmsEmployeArchiveEducationPagination.getCurrentPage(), hrmsEmployeArchiveEducationPagination.getPageSize());
            IPage userIPage = this.page((IPage)page, (Wrapper)oaArchiveEducationQueryWrapper);
            return hrmsEmployeArchiveEducationPagination.setData(userIPage.getRecords(), userIPage.getTotal());
        }
        ArrayList list = new ArrayList();
        return hrmsEmployeArchiveEducationPagination.setData(list, list.size());
    }

    @Override
    public List<HrmsEmployeArchiveEducationEntity> getTypeList(HrmsEmployeArchiveEducationPagination hrmsEmployeArchiveEducationPagination, String dataType) {
        Object oaArchiveEducationObj;
        String userId = this.userProvider.get().getUserId();
        ArrayList AllIdList = new ArrayList();
        int total = 0;
        int oaArchiveEducationNum = 0;
        QueryWrapper oaArchiveEducationQueryWrapper = new QueryWrapper();
        boolean pcPermission = false;
        boolean appPermission = false;
        boolean isPc = ServletUtils.getHeader((String)"jsbos-origin").equals("pc");
        if (isPc && pcPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            oaArchiveEducationObj = this.authorizeService.getCondition(new AuthorizeConditionModel(oaArchiveEducationQueryWrapper, hrmsEmployeArchiveEducationPagination.getMenuId(), "oaArchiveEducation"));
            if (ObjectUtil.isEmpty((Object)oaArchiveEducationObj)) {
                return new ArrayList<HrmsEmployeArchiveEducationEntity>();
            }
            oaArchiveEducationQueryWrapper = (QueryWrapper)oaArchiveEducationObj;
            ++oaArchiveEducationNum;
        }
        if (!isPc && appPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            oaArchiveEducationObj = this.authorizeService.getCondition(new AuthorizeConditionModel(oaArchiveEducationQueryWrapper, hrmsEmployeArchiveEducationPagination.getMenuId(), "oaArchiveEducation"));
            if (ObjectUtil.isEmpty((Object)oaArchiveEducationObj)) {
                return new ArrayList<HrmsEmployeArchiveEducationEntity>();
            }
            oaArchiveEducationQueryWrapper = (QueryWrapper)oaArchiveEducationObj;
            ++oaArchiveEducationNum;
        }
        if (StringUtils.isNotEmpty((String)hrmsEmployeArchiveEducationPagination.getArchiveId())) {
            ++oaArchiveEducationNum;
            oaArchiveEducationQueryWrapper.lambda().like(HrmsEmployeArchiveEducationEntity::getArchiveId, (Object)hrmsEmployeArchiveEducationPagination.getArchiveId());
        }
        if (StringUtils.isNotEmpty((String)hrmsEmployeArchiveEducationPagination.getEducation())) {
            ++oaArchiveEducationNum;
            oaArchiveEducationQueryWrapper.lambda().like(HrmsEmployeArchiveEducationEntity::getEducation, (Object)hrmsEmployeArchiveEducationPagination.getEducation());
        }
        if (AllIdList.size() > 0) {
            oaArchiveEducationQueryWrapper.lambda().in(HrmsEmployeArchiveEducationEntity::getId, AllIdList);
        }
        if (StringUtils.isEmpty((String)hrmsEmployeArchiveEducationPagination.getSidx())) {
            oaArchiveEducationQueryWrapper.lambda().orderByDesc(HrmsEmployeArchiveEducationEntity::getId);
        } else {
            try {
                String sidx = hrmsEmployeArchiveEducationPagination.getSidx();
                HrmsEmployeArchiveEducationEntity oaArchiveEducationEntity = new HrmsEmployeArchiveEducationEntity();
                Field declaredField = oaArchiveEducationEntity.getClass().getDeclaredField(sidx);
                declaredField.setAccessible(true);
                String value = declaredField.getAnnotation(TableField.class).value();
                oaArchiveEducationQueryWrapper = "asc".equals(hrmsEmployeArchiveEducationPagination.getSort().toLowerCase()) ? (QueryWrapper)oaArchiveEducationQueryWrapper.orderByAsc((Object)value) : (QueryWrapper)oaArchiveEducationQueryWrapper.orderByDesc((Object)value);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if ("0".equals(dataType)) {
            if (total > 0 && AllIdList.size() > 0 || total == 0) {
                Page page = new Page(hrmsEmployeArchiveEducationPagination.getCurrentPage(), hrmsEmployeArchiveEducationPagination.getPageSize());
                IPage userIPage = this.page((IPage)page, (Wrapper)oaArchiveEducationQueryWrapper);
                return hrmsEmployeArchiveEducationPagination.setData(userIPage.getRecords(), userIPage.getTotal());
            }
            ArrayList list = new ArrayList();
            return hrmsEmployeArchiveEducationPagination.setData(list, list.size());
        }
        return this.list((Wrapper)oaArchiveEducationQueryWrapper);
    }

    @Override
    public List<HrmsEmployeArchiveEducationEntity> getListByArchive(String archiveId) {
        QueryWrapper oaArchiveContactQueryWrapper = new QueryWrapper();
        oaArchiveContactQueryWrapper.lambda().eq(HrmsEmployeArchiveEducationEntity::getArchiveId, (Object)archiveId);
        return this.list((Wrapper)oaArchiveContactQueryWrapper);
    }

    @Override
    public HrmsEmployeArchiveEducationEntity getInfo(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(HrmsEmployeArchiveEducationEntity::getId, (Object)id);
        return (HrmsEmployeArchiveEducationEntity)this.getOne((Wrapper)queryWrapper);
    }

    @Override
    public void create(HrmsEmployeArchiveEducationEntity entity) {
        this.save(entity);
    }

    @Override
    public boolean update(String id, HrmsEmployeArchiveEducationEntity entity) {
        entity.setId(id);
        return this.updateById(entity);
    }

    @Override
    public void delete(HrmsEmployeArchiveEducationEntity entity) {
        if (entity != null) {
            this.removeById((Serializable)((Object)entity.getId()));
        }
    }

    @Override
    public void getNameByCode(List<HrmsManagerEntryCompanyCrForm> archiveCrForm) {
        archiveCrForm.stream().forEach(v -> {
            PositionEntity infoPosi;
            v.setBandLevelName(this.baseDataUtil.getDictName(v.getBandLevel(), "band"));
            v.setOutLevelName(this.baseDataUtil.getDictName(v.getOutLevel(), "outLevel"));
            v.setEntryTypeName(this.baseDataUtil.getDictName(v.getEntryType(), "employNature"));
            v.setEntryCompanyName(this.baseDataUtil.comSelectValues(v.getEntryCompany()));
            OrganizeEntity infoOrg = this.organizeService.getInfo(v.getOrganizeId());
            if (!ObjectUtil.isEmpty((Object)infoOrg)) {
                v.setOrganizeName(infoOrg.getFullName());
            }
            if (!ObjectUtil.isEmpty((Object)(infoPosi = this.positionService.getInfo(v.getPositionId())))) {
                v.setPositionName(infoPosi.getFullName());
            }
            if (!ObjectUtil.isEmpty((Object)v.getApproveLeader())) {
                v.setApproveLeaderName(this.baseDataUtil.userSelectValue(v.getApproveLeader()));
            }
            if (!ObjectUtil.isEmpty((Object)v.getFirstTryUser())) {
                v.setFirstTryUserName(this.baseDataUtil.userSelectValue(v.getFirstTryUser()));
            }
            if (!ObjectUtil.isEmpty((Object)v.getSecondTryUser())) {
                v.setSecondTryUserName(this.baseDataUtil.userSelectValue(v.getSecondTryUser()));
            }
            if (!ObjectUtil.isEmpty((Object)v.getWorkCity())) {
                v.setWorkCityName(this.baseDataUtil.provinceData(v.getWorkCity()));
            }
        });
    }

    @Override
    public void getNameByCodeEdu(List<HrmsEmployeArchiveEducationCrForm> archiveCrForm) {
        archiveCrForm.stream().forEach(v -> {
            v.setEducationName(this.baseDataUtil.getDictName(v.getEducation(), "Education"));
            v.setEducationTypeName(this.baseDataUtil.getDictName(v.getEducationType(), "educationType"));
        });
    }
}

