/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.hrms.service.impl;

import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.ServletUtils;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UserProvider;
import com.bringspring.hrms.entity.HrmsEmployeArchiveEntity;
import com.bringspring.hrms.mapper.HrmsEmployeArchiveMapper;
import com.bringspring.hrms.model.hrmsemployearchive.HrmsEmployeArchiveCrForm;
import com.bringspring.hrms.model.hrmsemployearchive.HrmsEmployeArchiveOverviewCount;
import com.bringspring.hrms.model.hrmsemployearchive.HrmsEmployeArchivePagination;
import com.bringspring.hrms.model.hrmsemployearchive.HrmsEmployeeArchiveApplyViewCount;
import com.bringspring.hrms.model.hrmsmanagerchangeregular.HrmsManagerChangeRegularPagination;
import com.bringspring.hrms.model.hrmsmanagerdepart.HrmsManagerDepartPagination;
import com.bringspring.hrms.model.hrmsmanagerentrycompany.HrmsManagerEntryCompanyPagination;
import com.bringspring.hrms.model.hrmsmanagertransfer.HrmsManagerTransferPagination;
import com.bringspring.hrms.service.HrmsEmployeArchiveService;
import com.bringspring.hrms.service.HrmsManagerChangeRegularService;
import com.bringspring.hrms.service.HrmsManagerDepartService;
import com.bringspring.hrms.service.HrmsManagerEntryCompanyService;
import com.bringspring.hrms.service.HrmsManagerSignApplicationService;
import com.bringspring.hrms.service.HrmsManagerTransferService;
import com.bringspring.hrms.util.SumTreeToList;
import com.bringspring.system.permission.entity.OrganizeEntity;
import com.bringspring.system.permission.entity.PositionEntity;
import com.bringspring.system.permission.entity.UserEntity;
import com.bringspring.system.permission.entity.UserRelationEntity;
import com.bringspring.system.permission.exception.PermissionException;
import com.bringspring.system.permission.mapper.UserRelationMapper;
import com.bringspring.system.permission.model.authorize.AuthorizeConditionModel;
import com.bringspring.system.permission.model.user.vo.UserInfoVO;
import com.bringspring.system.permission.service.AuthorizeService;
import com.bringspring.system.permission.service.BasePositionRelationService;
import com.bringspring.system.permission.service.OrganizeService;
import com.bringspring.system.permission.service.PositionService;
import com.bringspring.system.permission.service.UserRelationService;
import com.bringspring.system.permission.service.UserService;
import com.bringspring.system.permission.util.BaseDataUtil;
import com.bringspring.system.permission.util.PermissionUtil;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class HrmsEmployeArchiveServiceImpl
extends ServiceImpl<HrmsEmployeArchiveMapper, HrmsEmployeArchiveEntity>
implements HrmsEmployeArchiveService {
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private AuthorizeService authorizeService;
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private OrganizeService organizeService;
    @Autowired
    private PositionService positionService;
    @Autowired
    private UserService userService;
    @Autowired
    private UserRelationService userRelationService;
    @Autowired
    private UserRelationMapper userRelationMapper;
    @Autowired
    private BasePositionRelationService basePositionRelationService;
    @Autowired
    private HrmsManagerDepartService hrmsManagerDepartService;
    @Autowired
    private HrmsManagerChangeRegularService hrmsManagerChangeRegularService;
    @Autowired
    private HrmsManagerEntryCompanyService hrmsManagerEntryCompanyService;
    @Autowired
    private HrmsManagerTransferService hrmsManagerTransferService;
    @Autowired
    private HrmsEmployeArchiveMapper hrmsEmployeArchiveMapper;
    @Autowired
    private HrmsManagerSignApplicationService hrmsManagerSignApplicationService;

    @Override
    public List<HrmsEmployeArchiveEntity> getList(HrmsEmployeArchivePagination hrmsEmployeArchivePagination) {
        Object oaArchiveObj;
        String userId = this.userProvider.get().getUserId();
        ArrayList AllIdList = new ArrayList();
        int total = 0;
        int oaArchiveNum = 0;
        QueryWrapper oaArchiveQueryWrapper = new QueryWrapper();
        boolean pcPermission = true;
        boolean appPermission = true;
        boolean isPc = ServletUtils.getHeader((String)"jsbos-origin").equals("pc");
        if (isPc && pcPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            oaArchiveObj = this.authorizeService.getCondition(new AuthorizeConditionModel(oaArchiveQueryWrapper, hrmsEmployeArchivePagination.getMenuId(), "hrms_employe_archive"));
            if (ObjectUtil.isEmpty((Object)oaArchiveObj)) {
                return new ArrayList<HrmsEmployeArchiveEntity>();
            }
            oaArchiveQueryWrapper = (QueryWrapper)oaArchiveObj;
            ++oaArchiveNum;
        }
        if (!isPc && appPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            oaArchiveObj = this.authorizeService.getCondition(new AuthorizeConditionModel(oaArchiveQueryWrapper, hrmsEmployeArchivePagination.getMenuId(), "hrms_employe_archive"));
            if (ObjectUtil.isEmpty((Object)oaArchiveObj)) {
                return new ArrayList<HrmsEmployeArchiveEntity>();
            }
            oaArchiveQueryWrapper = (QueryWrapper)oaArchiveObj;
            ++oaArchiveNum;
        }
        if (!this.userProvider.get().getIsAdministrator().booleanValue()) {
            Object companyAuth = this.authorizeService.getCondition(new AuthorizeConditionModel(oaArchiveQueryWrapper, hrmsEmployeArchivePagination.getMenuId(), "hrms_employe_archive"));
            if (ObjectUtil.isEmpty((Object)companyAuth)) {
                return new ArrayList<HrmsEmployeArchiveEntity>();
            }
            oaArchiveQueryWrapper = (QueryWrapper)companyAuth;
        }
        if (!ObjectUtil.isEmpty(hrmsEmployeArchivePagination.getTreeOrgData())) {
            ArrayList<String> listId = new ArrayList<String>();
            SumTreeToList.treeToList(hrmsEmployeArchivePagination.getTreeOrgData(), listId);
            QueryWrapper queryWrapper = new QueryWrapper();
            String orderSql = this.makeOrderByFieldSql("object_id", listId);
            ((LambdaQueryWrapper)queryWrapper.lambda().in(UserRelationEntity::getObjectId, listId)).last(orderSql);
            List<String> relationEntityList = this.userRelationMapper.selectList((Wrapper)queryWrapper).stream().map(v -> v.getUserId()).distinct().collect(Collectors.toList());
            if (!ObjectUtil.isEmpty(relationEntityList)) {
                String orderArchiveSql = this.makeOrderByFieldSql("id", relationEntityList);
                ((LambdaQueryWrapper)oaArchiveQueryWrapper.lambda().in(HrmsEmployeArchiveEntity::getId, relationEntityList)).last(orderArchiveSql);
            } else {
                return hrmsEmployeArchivePagination.setData(null, 0L);
            }
        }
        if (StringUtils.isNotEmpty((String)hrmsEmployeArchivePagination.getArchiveType())) {
            ++oaArchiveNum;
            oaArchiveQueryWrapper.lambda().like(HrmsEmployeArchiveEntity::getArchiveType, (Object)hrmsEmployeArchivePagination.getArchiveType());
        }
        if (StringUtils.isNotEmpty((String)hrmsEmployeArchivePagination.getName())) {
            ++oaArchiveNum;
            oaArchiveQueryWrapper.lambda().and(wq -> ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wq.like(HrmsEmployeArchiveEntity::getName, (Object)hrmsEmployeArchivePagination.getName())).or()).like(HrmsEmployeArchiveEntity::getPhone, (Object)hrmsEmployeArchivePagination.getName())).or()).like(HrmsEmployeArchiveEntity::getCode, (Object)hrmsEmployeArchivePagination.getName()));
        }
        if (StringUtils.isNotEmpty((String)hrmsEmployeArchivePagination.getPhone())) {
            ++oaArchiveNum;
            oaArchiveQueryWrapper.lambda().eq(HrmsEmployeArchiveEntity::getPhone, (Object)hrmsEmployeArchivePagination.getPhone());
        }
        if (StringUtils.isNotEmpty((String)hrmsEmployeArchivePagination.getCardNumber())) {
            ++oaArchiveNum;
            oaArchiveQueryWrapper.lambda().eq(HrmsEmployeArchiveEntity::getCardNumber, (Object)hrmsEmployeArchivePagination.getCardNumber());
        }
        if (StringUtils.isNotEmpty((String)hrmsEmployeArchivePagination.getEmployeeType())) {
            ++oaArchiveNum;
            oaArchiveQueryWrapper.lambda().eq(HrmsEmployeArchiveEntity::getEmployeeType, (Object)hrmsEmployeArchivePagination.getEmployeeType());
        }
        if (StringUtils.isNotEmpty((String)hrmsEmployeArchivePagination.getEmployeeState())) {
            ++oaArchiveNum;
            oaArchiveQueryWrapper.lambda().eq(HrmsEmployeArchiveEntity::getEmployeeState, (Object)hrmsEmployeArchivePagination.getEmployeeState());
        }
        if (StringUtils.isNotEmpty((String)hrmsEmployeArchivePagination.getEntryDepartment())) {
            ++oaArchiveNum;
            oaArchiveQueryWrapper.lambda().and(wq -> ((LambdaQueryWrapper)((LambdaQueryWrapper)wq.eq(HrmsEmployeArchiveEntity::getEntryDepartment, (Object)hrmsEmployeArchivePagination.getEntryDepartment())).or()).eq(HrmsEmployeArchiveEntity::getEntryCompany, (Object)hrmsEmployeArchivePagination.getEntryDepartment()));
        }
        if (StringUtils.isNotEmpty((String)hrmsEmployeArchivePagination.getStation())) {
            ++oaArchiveNum;
            oaArchiveQueryWrapper.lambda().eq(HrmsEmployeArchiveEntity::getStation, (Object)hrmsEmployeArchivePagination.getStation());
        }
        if (StringUtils.isNotEmpty((String)hrmsEmployeArchivePagination.getGander())) {
            ++oaArchiveNum;
            oaArchiveQueryWrapper.lambda().eq(HrmsEmployeArchiveEntity::getGander, (Object)hrmsEmployeArchivePagination.getGander());
        }
        if (AllIdList.size() > 0) {
            oaArchiveQueryWrapper.lambda().in(HrmsEmployeArchiveEntity::getId, AllIdList);
        }
        if (total > 0 && AllIdList.size() > 0 || total == 0) {
            Page page = new Page(hrmsEmployeArchivePagination.getCurrentPage(), hrmsEmployeArchivePagination.getPageSize());
            IPage userIPage = this.page((IPage)page, (Wrapper)oaArchiveQueryWrapper);
            return hrmsEmployeArchivePagination.setData(userIPage.getRecords(), userIPage.getTotal());
        }
        ArrayList list = new ArrayList();
        return hrmsEmployeArchivePagination.setData(list, list.size());
    }

    @Override
    public List<HrmsEmployeArchiveEntity> getTypeList(HrmsEmployeArchivePagination hrmsEmployeArchivePagination, String dataType) {
        Object oaArchiveObj;
        String userId = this.userProvider.get().getUserId();
        ArrayList AllIdList = new ArrayList();
        int total = 0;
        int oaArchiveNum = 0;
        QueryWrapper oaArchiveQueryWrapper = new QueryWrapper();
        boolean pcPermission = false;
        boolean appPermission = false;
        boolean isPc = ServletUtils.getHeader((String)"jsbos-origin").equals("pc");
        if (isPc && pcPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            oaArchiveObj = this.authorizeService.getCondition(new AuthorizeConditionModel(oaArchiveQueryWrapper, hrmsEmployeArchivePagination.getMenuId(), "hrms_employe_archive"));
            if (ObjectUtil.isEmpty((Object)oaArchiveObj)) {
                return new ArrayList<HrmsEmployeArchiveEntity>();
            }
            oaArchiveQueryWrapper = (QueryWrapper)oaArchiveObj;
            ++oaArchiveNum;
        }
        if (!isPc && appPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            oaArchiveObj = this.authorizeService.getCondition(new AuthorizeConditionModel(oaArchiveQueryWrapper, hrmsEmployeArchivePagination.getMenuId(), "hrms_employe_archive"));
            if (ObjectUtil.isEmpty((Object)oaArchiveObj)) {
                return new ArrayList<HrmsEmployeArchiveEntity>();
            }
            oaArchiveQueryWrapper = (QueryWrapper)oaArchiveObj;
            ++oaArchiveNum;
        }
        if (StringUtils.isNotEmpty((String)hrmsEmployeArchivePagination.getEmployeeType())) {
            ++oaArchiveNum;
            oaArchiveQueryWrapper.lambda().eq(HrmsEmployeArchiveEntity::getEmployeeType, (Object)hrmsEmployeArchivePagination.getEmployeeType());
        }
        if (StringUtils.isNotEmpty((String)hrmsEmployeArchivePagination.getEmployeeState())) {
            ++oaArchiveNum;
            oaArchiveQueryWrapper.lambda().eq(HrmsEmployeArchiveEntity::getEmployeeState, (Object)hrmsEmployeArchivePagination.getEmployeeState());
        }
        if (StringUtils.isNotEmpty((String)hrmsEmployeArchivePagination.getEntryDepartment())) {
            ++oaArchiveNum;
            oaArchiveQueryWrapper.lambda().eq(HrmsEmployeArchiveEntity::getEntryDepartment, (Object)hrmsEmployeArchivePagination.getEntryDepartment());
        }
        if (StringUtils.isNotEmpty((String)hrmsEmployeArchivePagination.getStation())) {
            ++oaArchiveNum;
            oaArchiveQueryWrapper.lambda().eq(HrmsEmployeArchiveEntity::getStation, (Object)hrmsEmployeArchivePagination.getStation());
        }
        if (StringUtils.isNotEmpty((String)hrmsEmployeArchivePagination.getGander())) {
            ++oaArchiveNum;
            oaArchiveQueryWrapper.lambda().eq(HrmsEmployeArchiveEntity::getGander, (Object)hrmsEmployeArchivePagination.getGander());
        }
        if (AllIdList.size() > 0) {
            oaArchiveQueryWrapper.lambda().in(HrmsEmployeArchiveEntity::getId, AllIdList);
        }
        if (StringUtils.isEmpty((String)hrmsEmployeArchivePagination.getSidx())) {
            oaArchiveQueryWrapper.lambda().orderByDesc(HrmsEmployeArchiveEntity::getId);
        } else {
            try {
                String sidx = hrmsEmployeArchivePagination.getSidx();
                HrmsEmployeArchiveEntity hrmsEmployeArchiveEntity = new HrmsEmployeArchiveEntity();
                Field declaredField = hrmsEmployeArchiveEntity.getClass().getDeclaredField(sidx);
                declaredField.setAccessible(true);
                String value = declaredField.getAnnotation(TableField.class).value();
                oaArchiveQueryWrapper = "asc".equals(hrmsEmployeArchivePagination.getSort().toLowerCase()) ? (QueryWrapper)oaArchiveQueryWrapper.orderByAsc((Object)value) : (QueryWrapper)oaArchiveQueryWrapper.orderByDesc((Object)value);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if ("0".equals(dataType)) {
            if (total > 0 && AllIdList.size() > 0 || total == 0) {
                Page page = new Page(hrmsEmployeArchivePagination.getCurrentPage(), hrmsEmployeArchivePagination.getPageSize());
                IPage userIPage = this.page((IPage)page, (Wrapper)oaArchiveQueryWrapper);
                return hrmsEmployeArchivePagination.setData(userIPage.getRecords(), userIPage.getTotal());
            }
            ArrayList list = new ArrayList();
            return hrmsEmployeArchivePagination.setData(list, list.size());
        }
        return this.list((Wrapper)oaArchiveQueryWrapper);
    }

    @Override
    public HrmsEmployeArchiveEntity getInfo(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(HrmsEmployeArchiveEntity::getId, (Object)id);
        return (HrmsEmployeArchiveEntity)this.getOne((Wrapper)queryWrapper);
    }

    @Override
    public List<HrmsEmployeArchiveEntity> getInfoById(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(HrmsEmployeArchiveEntity::getId, (Object)id);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public List<HrmsEmployeArchiveEntity> getInfoByCode(String code) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(HrmsEmployeArchiveEntity::getCode, (Object)code);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public HrmsEmployeArchiveOverviewCount getCount(String menuId) {
        ArrayList<Integer> flowStateEnableList = new ArrayList<Integer>();
        flowStateEnableList.add(4);
        flowStateEnableList.add(5);
        flowStateEnableList.add(6);
        HrmsManagerDepartPagination hrmsManagerDepartPagination = new HrmsManagerDepartPagination();
        hrmsManagerDepartPagination.setFlowStateEnableList(flowStateEnableList);
        hrmsManagerDepartPagination.setMenuId(menuId);
        long countDepart = this.hrmsManagerDepartService.getCount(hrmsManagerDepartPagination);
        HrmsManagerChangeRegularPagination hrmsManagerChangeRegularPagination = new HrmsManagerChangeRegularPagination();
        hrmsManagerChangeRegularPagination.setFlowStateEnableList(flowStateEnableList);
        hrmsManagerChangeRegularPagination.setMenuId(menuId);
        long countRegular = this.hrmsManagerChangeRegularService.getCount(hrmsManagerChangeRegularPagination);
        HrmsManagerEntryCompanyPagination hrmsManagerEntryCompanyPagination = new HrmsManagerEntryCompanyPagination();
        hrmsManagerEntryCompanyPagination.setFlowStateList(flowStateEnableList);
        hrmsManagerEntryCompanyPagination.setMenuId(menuId);
        long countEntry = this.hrmsManagerEntryCompanyService.getCount(hrmsManagerEntryCompanyPagination);
        HrmsManagerTransferPagination hrmsManagerTransferPagination = new HrmsManagerTransferPagination();
        hrmsManagerTransferPagination.setFlowStateEnableList(flowStateEnableList);
        hrmsManagerTransferPagination.setMenuId(menuId);
        long countTransfer = this.hrmsManagerTransferService.getCount(hrmsManagerTransferPagination);
        HrmsEmployeArchiveOverviewCount overviewCount = new HrmsEmployeArchiveOverviewCount();
        overviewCount.setDepartCount(countDepart);
        overviewCount.setRegularCount(countRegular);
        overviewCount.setEntryCount(countEntry);
        overviewCount.setTransferCount(countTransfer);
        return overviewCount;
    }

    @Override
    public HrmsEmployeeArchiveApplyViewCount getApplyCount(String menuId, List<Integer> flowStateEnableList) {
        HrmsManagerDepartPagination hrmsManagerDepartPagination = new HrmsManagerDepartPagination();
        hrmsManagerDepartPagination.setFlowStateEnableList(flowStateEnableList);
        hrmsManagerDepartPagination.setMenuId(menuId);
        long countDepart = this.hrmsManagerDepartService.getCount(hrmsManagerDepartPagination);
        HrmsManagerChangeRegularPagination hrmsManagerChangeRegularPagination = new HrmsManagerChangeRegularPagination();
        hrmsManagerChangeRegularPagination.setFlowStateEnableList(flowStateEnableList);
        hrmsManagerChangeRegularPagination.setMenuId(menuId);
        long countRegular = this.hrmsManagerChangeRegularService.getCount(hrmsManagerChangeRegularPagination);
        HrmsManagerEntryCompanyPagination hrmsManagerEntryCompanyPagination = new HrmsManagerEntryCompanyPagination();
        hrmsManagerEntryCompanyPagination.setFlowStateList(flowStateEnableList);
        hrmsManagerEntryCompanyPagination.setMenuId(menuId);
        long countEntry = this.hrmsManagerEntryCompanyService.getCount(hrmsManagerEntryCompanyPagination);
        HrmsManagerTransferPagination hrmsManagerTransferPagination = new HrmsManagerTransferPagination();
        hrmsManagerTransferPagination.setFlowStateEnableList(flowStateEnableList);
        hrmsManagerTransferPagination.setMenuId(menuId);
        long countTransfer = this.hrmsManagerTransferService.getCount(hrmsManagerTransferPagination);
        long countSpecial = this.hrmsManagerSignApplicationService.getCount(hrmsManagerTransferPagination);
        HrmsEmployeeArchiveApplyViewCount overviewCount = new HrmsEmployeeArchiveApplyViewCount();
        overviewCount.setDepartCount(countDepart);
        overviewCount.setRegularCount(countRegular);
        overviewCount.setEntryCount(countEntry);
        overviewCount.setTransferCount(countTransfer);
        overviewCount.setSpecialCount(countSpecial);
        return overviewCount;
    }

    @Override
    public void create(HrmsEmployeArchiveEntity entity) {
        this.save(entity);
    }

    @Override
    public boolean update(String id, HrmsEmployeArchiveEntity entity) {
        entity.setId(id);
        return this.updateById(entity);
    }

    @Override
    public void delete(HrmsEmployeArchiveEntity entity) throws DataException, PermissionException {
        if (entity != null) {
            this.removeById((Serializable)((Object)entity.getId()));
            UserInfoVO infoByCode = this.userService.getInfoDetail(entity.getId());
            if (!ObjectUtil.isEmpty((Object)infoByCode)) {
                UserEntity userEntity = (UserEntity)JsonUtil.getJsonToBean((Object)infoByCode, UserEntity.class);
                this.userService.deleteByLogical(userEntity);
            }
        }
    }

    @Override
    public void getNameByCode(List<HrmsEmployeArchiveCrForm> archiveCrForm) {
        archiveCrForm.stream().forEach(v -> {
            PositionEntity infoPosi;
            List organize;
            v.setEmployeeStateName(this.baseDataUtil.getDictName(v.getEmployeeState(), "archiveEmployeeState"));
            List position = this.userRelationService.getListByUserIdAndObjType(v.getId(), "Position");
            if (!ObjectUtil.isEmpty((Object)position)) {
                v.setStationList(position.stream().map(a -> a.getObjectId()).collect(Collectors.toList()));
                v.setStation(v.getStationList().stream().collect(Collectors.joining(",")));
                v.setStationName(this.baseDataUtil.posSelectValues(v.getStation()));
            }
            if (!ObjectUtil.isEmpty((Object)(organize = this.userRelationService.getListByUserIdAndObjType(v.getId(), "Organize")))) {
                v.setEntryDepartmentName(this.baseDataUtil.comSelectValues(v.getEntryDepartment()));
            }
            v.setEntryCompanyName(this.baseDataUtil.comSelectValues(v.getEntryCompany()));
            if (!ObjectUtil.isEmpty((Object)v.getStation())) {
                v.setStationNatureName(this.baseDataUtil.getDictName(v.getStationNature(), "PositionType"));
            }
            OrganizeEntity infoOrg = this.organizeService.getInfo(v.getEntryDepartment());
            if (!ObjectUtil.isEmpty((Object)v.getEntryDepartment())) {
                v.setEntryDepartmentList(PermissionUtil.getOrgIdsTree(Arrays.asList(v.getEntryDepartment().split(",")), (Integer)1, (OrganizeService)this.organizeService));
            }
            if (!ObjectUtil.isEmpty((Object)infoOrg)) {
                v.setEntryDepartmentName(infoOrg.getFullName());
            }
            if (!ObjectUtil.isEmpty((Object)(infoPosi = this.positionService.getInfo(v.getStation())))) {
                v.setStationNatureName(this.baseDataUtil.getDictName(infoPosi.getType(), "PositionType"));
            }
            v.setCardTypeName(this.baseDataUtil.getDictName(v.getCardType(), "certificateType"));
            if (!ObjectUtil.isEmpty((Object)v.getBandLevel())) {
                v.setBandLevelName(this.baseDataUtil.getDictName(v.getBandLevel(), "band"));
            }
            if (!ObjectUtil.isEmpty((Object)v.getManagerId())) {
                v.setManagerName(this.baseDataUtil.userSelectValue(v.getManagerId()));
            }
        });
    }

    @Override
    public void syncUser(HrmsEmployeArchiveCrForm hrmsEmployeArchiveCrForm) throws PermissionException, DataException {
        UserInfoVO infoByCode = this.userService.getInfoDetail(hrmsEmployeArchiveCrForm.getId());
        UserEntity userEntity = new UserEntity();
        if (!ObjectUtil.isEmpty((Object)infoByCode)) {
            userEntity = (UserEntity)JsonUtil.getJsonToBean((Object)infoByCode, UserEntity.class);
        }
        if ("leaveJob".equals(hrmsEmployeArchiveCrForm.getEmployeeState())) {
            this.userService.deleteByLogical(userEntity);
            return;
        }
        HrmsEmployeArchiveEntity hrmsEmployeArchiveEntity = this.getInfo(hrmsEmployeArchiveCrForm.getId());
        if (!"leaveJob".equals(hrmsEmployeArchiveEntity.getEmployeeState())) {
            userEntity.setEnabledMark(Integer.valueOf(1));
            userEntity.setDeleteMark(Integer.valueOf(0));
        }
        userEntity.setRealName(hrmsEmployeArchiveCrForm.getName());
        userEntity.setGender(Integer.valueOf(hrmsEmployeArchiveCrForm.getGander()));
        userEntity.setOrganizeId(hrmsEmployeArchiveCrForm.getEntryDepartment());
        userEntity.setPositionId(hrmsEmployeArchiveCrForm.getStation());
        userEntity.setManagerId(hrmsEmployeArchiveCrForm.getManagerId());
        userEntity.setEntryDate(hrmsEmployeArchiveCrForm.getEntryDate());
        userEntity.setId(hrmsEmployeArchiveCrForm.getId());
        userEntity.setEmail(hrmsEmployeArchiveCrForm.getCEmail());
        userEntity.setCode(hrmsEmployeArchiveCrForm.getCode());
        userEntity.setAccount(hrmsEmployeArchiveCrForm.getPhone());
        userEntity.setMobilePhone(hrmsEmployeArchiveCrForm.getPhone());
        if (!ObjectUtil.isEmpty((Object)hrmsEmployeArchiveCrForm.getAvatar())) {
            userEntity.setHeadIcon(hrmsEmployeArchiveCrForm.getAvatar());
        }
        if (!ObjectUtil.isEmpty((Object)hrmsEmployeArchiveCrForm.getSortCode())) {
            userEntity.setSortCode(hrmsEmployeArchiveCrForm.getSortCode());
        }
        String role = "393332333610065861";
        if (ObjectUtil.isEmpty((Object)infoByCode)) {
            if (!ObjectUtil.isEmpty((Object)userEntity.getPositionId())) {
                List listByTypeAndPosId = this.basePositionRelationService.getListByTypeAndPosId("Role", Arrays.asList(userEntity.getPositionId().split(","))).stream().map(v -> v.getObjectId()).distinct().collect(Collectors.toList());
                if (!ObjectUtil.isEmpty((Object)userEntity.getRoleId())) {
                    listByTypeAndPosId.addAll(Arrays.asList(userEntity.getRoleId().split(",")));
                }
                listByTypeAndPosId.add(role);
                String collectRole = listByTypeAndPosId.stream().distinct().collect(Collectors.joining(","));
                userEntity.setRoleId(collectRole);
            }
            userEntity.setEnabledMark(Integer.valueOf(1));
            UserEntity userEntityisExis = this.userService.getUserEntity(userEntity.getAccount(), null, userEntity.getMobilePhone());
            if (!ObjectUtil.isEmpty((Object)userEntityisExis)) {
                this.userService.update(userEntityisExis.getId(), userEntity);
                HrmsEmployeArchiveCrForm updateIdCr = new HrmsEmployeArchiveCrForm();
                updateIdCr.setId(hrmsEmployeArchiveCrForm.getId());
                updateIdCr.setEntryId(userEntityisExis.getId());
                this.hrmsEmployeArchiveMapper.updateId(updateIdCr);
                this.hrmsEmployeArchiveMapper.updateEduId(updateIdCr);
                this.hrmsEmployeArchiveMapper.updateWorkId(updateIdCr);
                this.hrmsEmployeArchiveMapper.updateConId(updateIdCr);
                this.hrmsEmployeArchiveMapper.updateCerId(updateIdCr);
            } else {
                userEntity.setSortCode(Long.valueOf(0L));
                this.userService.create(userEntity);
            }
        } else {
            if (!ObjectUtil.isEmpty((Object)userEntity.getPositionId())) {
                ArrayList<Object> listByTypeAndPosId = new ArrayList<Object>();
                List listByTypeAndPosIds = this.basePositionRelationService.getListByTypeAndPosId("Role", Arrays.asList(userEntity.getPositionId().split(","))).stream().map(v -> v.getObjectId()).distinct().collect(Collectors.toList());
                listByTypeAndPosId.addAll(listByTypeAndPosIds);
                if (!ObjectUtil.isEmpty((Object)userEntity.getRoleId())) {
                    listByTypeAndPosId.addAll(Arrays.asList(userEntity.getRoleId().split(",")));
                }
                String collectRole = listByTypeAndPosId.stream().distinct().collect(Collectors.joining(","));
                userEntity.setRoleId(collectRole);
            }
            this.userService.update(userEntity.getId(), userEntity);
        }
    }

    @Override
    public List<HrmsEmployeArchiveEntity> getArchiveByDate(String startDate) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().like(HrmsEmployeArchiveEntity::getTrialDate, (Object)startDate);
        return this.list((Wrapper)queryWrapper);
    }

    private String makeOrderByFieldSql(String fieldName, List<String> fields) {
        StringBuilder orderSql = new StringBuilder();
        orderSql.append("ORDER BY SORT_CODE ASC , FIELD(").append(fieldName).append(",");
        for (String field : fields) {
            orderSql.append("\"").append(field).append("\"").append(",");
        }
        orderSql.deleteCharAt(orderSql.length() - 1).append(")");
        return orderSql.toString();
    }
}

