/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.oa.annotation;

import com.bringspring.oa.annotation.FieldMeta;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.apache.http.client.utils.DateUtils;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.stereotype.Component;

@Component
public class CompareObjectUtils {
    private static CompareObjectUtils compareObjectUtils;

    @PostConstruct
    public void init() {
        compareObjectUtils = this;
    }

    public static List<Map<String, Object>> compareTwoClass(Object class1, Object class2) throws ClassNotFoundException, IllegalAccessException {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        Class<?> clazz1 = class1.getClass();
        Class<?> clazz2 = class2.getClass();
        Field[] field1 = clazz1.getDeclaredFields();
        Field[] field2 = clazz2.getDeclaredFields();
        block0: for (int i = 0; i < field1.length; ++i) {
            if (!field1[i].isAnnotationPresent(FieldMeta.class)) continue;
            for (int j = 0; j < field2.length; ++j) {
                if (!field1[i].getName().equals(field2[j].getName())) continue;
                field1[i].setAccessible(true);
                field2[j].setAccessible(true);
                if (CompareObjectUtils.compareTwo(field1[i].get(class1), field2[j].get(class2)) || !field1[i].isAnnotationPresent(FieldMeta.class) || !field2[j].isAnnotationPresent(FieldMeta.class)) continue block0;
                FieldMeta metaAnnotation = field1[i].getAnnotation(FieldMeta.class);
                HashMap<String, Object> map2 = new HashMap<String, Object>();
                map2.put("name", metaAnnotation.name());
                map2.put("old", field1[i].get(class1) == null ? "" : field1[i].get(class1));
                map2.put("new", field2[j].get(class2));
                if (field1[i].isAnnotationPresent(DateTimeFormat.class) && field2[j].isAnnotationPresent(DateTimeFormat.class)) {
                    String old = DateUtils.formatDate((Date)((java.sql.Date)field1[i].get(class1)), (String)field1[i].getAnnotation(DateTimeFormat.class).pattern());
                    map2.put("old", old == null ? "" : old);
                    map2.put("new", DateUtils.formatDate((Date)((java.sql.Date)field2[j].get(class2)), (String)field2[j].getAnnotation(DateTimeFormat.class).pattern()));
                }
                list.add(map2);
                continue block0;
            }
        }
        return list;
    }

    public static boolean compareTwo(Object object1, Object object2) {
        if (object1 == null && object2 == null) {
            return true;
        }
        if (object1 == null && object2 != null) {
            return false;
        }
        return object1.equals(object2);
    }
}

