/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.oa.controller;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.enmus.ExcelType;
import cn.afterturn.easypoi.excel.entity.params.ExcelExportEntity;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.DownloadVO;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.config.ConfigValueUtil;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UploaderUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.common.util.XSSEscape;
import com.bringspring.common.util.file.UploadUtil;
import com.bringspring.oa.entity.MjOaCdBorrowEntity;
import com.bringspring.oa.model.mjoacdborrow.MjOaCdBorrowCrForm;
import com.bringspring.oa.model.mjoacdborrow.MjOaCdBorrowInfoVO;
import com.bringspring.oa.model.mjoacdborrow.MjOaCdBorrowListVO;
import com.bringspring.oa.model.mjoacdborrow.MjOaCdBorrowPagination;
import com.bringspring.oa.model.mjoacdborrow.MjOaCdBorrowPaginationExportModel;
import com.bringspring.oa.model.mjoacdborrow.MjOaCdBorrowUpForm;
import com.bringspring.oa.service.MjOaCdBorrowService;
import com.bringspring.oa.service.OaSealCompanyService;
import com.bringspring.system.base.exception.WorkFlowException;
import com.bringspring.system.base.service.DictionaryDataService;
import com.bringspring.system.permission.util.BaseDataUtil;
import com.bringspring.workflow.engine.entity.FlowTaskEntity;
import com.bringspring.workflow.engine.util.FlowUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u5370\u7167\u7ae0\u5916\u501f"}, value="oa")
@RequestMapping(value={"/api/oa/MjOaCdBorrow"})
public class MjOaCdBorrowController {
    private static final Logger log = LoggerFactory.getLogger(MjOaCdBorrowController.class);
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private ConfigValueUtil configValueUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private MjOaCdBorrowService mjOaCdBorrowService;
    @Autowired
    private OaSealCompanyService oaSealCompanyService;
    @Autowired
    private DictionaryDataService dictionaryDataService;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody MjOaCdBorrowPagination mjOaCdBorrowPagination) throws IOException {
        List<MjOaCdBorrowEntity> list = this.mjOaCdBorrowService.getList(mjOaCdBorrowPagination);
        for (MjOaCdBorrowEntity mjOaCdBorrowEntity : list) {
            mjOaCdBorrowEntity.setCreatorUserId(this.baseDataUtil.userSelectValues(mjOaCdBorrowEntity.getCreatorUserId()));
            mjOaCdBorrowEntity.setPostId(this.baseDataUtil.posSelectValues(mjOaCdBorrowEntity.getPostId()));
            mjOaCdBorrowEntity.setDeptId(this.baseDataUtil.comSelectValues(mjOaCdBorrowEntity.getDeptId()));
        }
        List listVO = JsonUtil.getJsonToList(list, MjOaCdBorrowListVO.class);
        for (MjOaCdBorrowListVO mjOaCdBorrowVO : listVO) {
            mjOaCdBorrowVO.setSealBase(this.baseDataUtil.getDictName(mjOaCdBorrowVO.getSealBase()));
        }
        for (MjOaCdBorrowListVO vo : listVO) {
            FlowTaskEntity flowTaskEntity = FlowUtil.getFlowTaskSubmited((String)vo.getId(), (SFunction[])new SFunction[]{FlowTaskEntity::getStatus});
            if (flowTaskEntity != null) {
                vo.setFlowState(flowTaskEntity.getStatus());
                continue;
            }
            vo.setFlowState(null);
        }
        PageListVO pageListVO = new PageListVO();
        pageListVO.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)mjOaCdBorrowPagination), PaginationVO.class);
        pageListVO.setPagination(page);
        return ActionResult.success((Object)pageListVO);
    }

    @PostMapping
    @Transactional
    public ActionResult create(@RequestBody @Valid Map<String, Object> crData) throws DataException, WorkFlowException {
        MjOaCdBorrowCrForm mjOaCdBorrowCrForm = (MjOaCdBorrowCrForm)JsonUtil.getJsonToBean(crData, MjOaCdBorrowCrForm.class);
        String visualId = "606543996205952005";
        String mainId = RandomUtil.uuId();
        UserInfo userInfo = this.userProvider.get();
        MjOaCdBorrowEntity entity = (MjOaCdBorrowEntity)JsonUtil.getJsonToBean((Object)mjOaCdBorrowCrForm, MjOaCdBorrowEntity.class);
        entity.setId(mainId);
        entity.setCompanyId(userInfo.getOrganizeId());
        entity.setPostName(this.baseDataUtil.posSelectValue(entity.getPostId()));
        entity.setCreatorUserName(this.baseDataUtil.userSelectValue(entity.getCreatorUserId()));
        entity.setDeptName(this.baseDataUtil.posSelectValue(entity.getDeptId()));
        entity.setSealTypeName(this.baseDataUtil.getDictName(entity.getSealType(), "MjSealBorrow"));
        entity.setApplyCompanyName(this.oaSealCompanyService.getInfo(entity.getApplyCompany()).getCompanyName());
        entity.setSealBaseName(this.baseDataUtil.getDictName(entity.getSealBase(), "sealBaseOptions"));
        this.mjOaCdBorrowService.save(entity);
        FlowUtil.saveOrSubmit((String)mjOaCdBorrowCrForm.getTaskId(), (String)visualId, (String)mjOaCdBorrowCrForm.getTemplateId(), (String)mainId, (Object)mjOaCdBorrowCrForm, (Integer)mjOaCdBorrowCrForm.getStatus(), (String)mjOaCdBorrowCrForm.getApplyTitle());
        return ActionResult.success((String)"\u4fdd\u5b58\u6210\u529f");
    }

    @ApiOperation(value="\u6a21\u677f\u4e0b\u8f7d")
    @GetMapping(value={"/templateDownload"})
    public ActionResult<DownloadVO> TemplateDownload() {
        UserInfo userInfo = this.userProvider.get();
        DownloadVO vo = DownloadVO.builder().build();
        try {
            vo.setName("\u804c\u5458\u4fe1\u606f.xlsx");
            vo.setUrl(UploaderUtil.uploaderFile((String)"/api/Common/DownloadModel?encryption=", (String)(userInfo.getId() + "#\u804c\u5458\u4fe1\u606f.xlsx#Temporary")));
        }
        catch (Exception e) {
            log.error("\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:{}", (Object)e.getMessage());
        }
        return ActionResult.success((Object)vo);
    }

    @ApiOperation(value="\u5bfc\u51faExcel")
    @GetMapping(value={"/Actions/Export"})
    public ActionResult Export(MjOaCdBorrowPaginationExportModel mjOaCdBorrowPaginationExportModel) throws IOException {
        if (StringUtils.isEmpty((String)mjOaCdBorrowPaginationExportModel.getSelectKey())) {
            return ActionResult.fail((String)"\u8bf7\u9009\u62e9\u5bfc\u51fa\u5b57\u6bb5");
        }
        MjOaCdBorrowPagination mjOaCdBorrowPagination = (MjOaCdBorrowPagination)((Object)JsonUtil.getJsonToBean((Object)((Object)mjOaCdBorrowPaginationExportModel), MjOaCdBorrowPagination.class));
        List<MjOaCdBorrowEntity> list = this.mjOaCdBorrowService.getTypeList(mjOaCdBorrowPagination, mjOaCdBorrowPaginationExportModel.getDataType());
        for (MjOaCdBorrowEntity mjOaCdBorrowEntity : list) {
            mjOaCdBorrowEntity.setCreatorUserId(this.baseDataUtil.userSelectValues(mjOaCdBorrowEntity.getCreatorUserId()));
            mjOaCdBorrowEntity.setPostId(this.baseDataUtil.posSelectValues(mjOaCdBorrowEntity.getPostId()));
            mjOaCdBorrowEntity.setDeptId(this.baseDataUtil.comSelectValues(mjOaCdBorrowEntity.getDeptId()));
            mjOaCdBorrowEntity.setSealBase(mjOaCdBorrowEntity.getSealBaseName());
            mjOaCdBorrowEntity.setApplyCompany(mjOaCdBorrowEntity.getApplyCompanyName());
            mjOaCdBorrowEntity.setSealType(mjOaCdBorrowEntity.getSealTypeName());
            mjOaCdBorrowEntity.setBorrowEnabledMark(this.baseDataUtil.getDictName(mjOaCdBorrowEntity.getBorrowEnabledMark(), "MjSealOptions"));
        }
        List listVO = JsonUtil.getJsonToList(list, MjOaCdBorrowListVO.class);
        for (MjOaCdBorrowListVO vo : listVO) {
            vo.setEnabledMark(this.getEnableMark(vo.getEnabledMark()));
        }
        List list2 = JsonUtil.getJsonToListMap((String)JsonUtil.getObjectToStringDateFormat((Object)listVO, (String)"yyyy-MM-dd HH:mm:ss"));
        String[] keys = !StringUtils.isEmpty((String)mjOaCdBorrowPaginationExportModel.getSelectKey()) ? mjOaCdBorrowPaginationExportModel.getSelectKey().split(",") : new String[]{};
        UserInfo userInfo = this.userProvider.get();
        DownloadVO vo = this.creatModelExcel(this.configValueUtil.getTemporaryFilePath(), list2, keys, userInfo);
        return ActionResult.success((Object)vo);
    }

    private String getEnableMark(String status) {
        HashMap<String, String> temp = new HashMap<String, String>();
        temp.put("1", "\u7b49\u5f85\u5ba1\u6838");
        temp.put("2", "\u5ba1\u6838\u901a\u8fc7");
        temp.put("4", "\u7b49\u5f85\u5ba1\u6838");
        temp.put("3", "\u6d41\u7a0b\u64a4\u56de");
        temp.put("6", "\u6d41\u7a0b\u64a4\u56de");
        temp.put("5", "\u5ba1\u6838\u7ec8\u6b62");
        return (String)temp.get(status);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DownloadVO creatModelExcel(String path, List<Map<String, Object>> list, String[] keys, UserInfo userInfo) {
        DownloadVO vo = DownloadVO.builder().build();
        ArrayList<ExcelExportEntity> entitys = new ArrayList<ExcelExportEntity>();
        if (keys.length > 0) {
            String[] stringArray = keys;
            int n = stringArray.length;
            block42: for (int i = 0; i < n; ++i) {
                String key;
                switch (key = stringArray[i]) {
                    case "applyTitle": {
                        entitys.add(new ExcelExportEntity("\u7533\u8bf7\u4e3b\u9898", (Object)"applyTitle"));
                        continue block42;
                    }
                    case "applyContent": {
                        entitys.add(new ExcelExportEntity("\u5185\u5bb9", (Object)"applyContent"));
                        continue block42;
                    }
                    case "sealBase": {
                        entitys.add(new ExcelExportEntity("\u516c\u7ae0\u6240\u5728\u5730", (Object)"sealBase"));
                        continue block42;
                    }
                    case "applyCompany": {
                        entitys.add(new ExcelExportEntity("\u7528\u7ae0\u516c\u53f8\u540d\u79f0", (Object)"applyCompany"));
                        continue block42;
                    }
                    case "sealType": {
                        entitys.add(new ExcelExportEntity("\u5370\u7167\u7c7b\u522b", (Object)"sealType"));
                        continue block42;
                    }
                    case "borrowDate": {
                        entitys.add(new ExcelExportEntity("\u9884\u8ba1\u5916\u501f\u65f6\u95f4", (Object)"borrowDate"));
                        continue block42;
                    }
                    case "backDate": {
                        entitys.add(new ExcelExportEntity("\u9884\u8ba1\u5f52\u8fd8\u65f6\u95f4", (Object)"backDate"));
                        continue block42;
                    }
                    case "creatorTime": {
                        entitys.add(new ExcelExportEntity("\u65e5\u671f", (Object)"creatorTime"));
                        continue block42;
                    }
                    case "creatorUserId": {
                        entitys.add(new ExcelExportEntity("\u7533\u8bf7\u4eba", (Object)"creatorUserId"));
                        continue block42;
                    }
                    case "postId": {
                        entitys.add(new ExcelExportEntity("\u7533\u8bf7\u5c97\u4f4d", (Object)"postId"));
                        continue block42;
                    }
                    case "deptId": {
                        entitys.add(new ExcelExportEntity("\u7533\u8bf7\u90e8\u95e8", (Object)"deptId"));
                        continue block42;
                    }
                    case "actualBorrowDate": {
                        entitys.add(new ExcelExportEntity("\u5df2\u5916\u501f\u65f6\u95f4", (Object)"actualBorrowDate"));
                        continue block42;
                    }
                    case "actualBackDate": {
                        entitys.add(new ExcelExportEntity("\u5df2\u5f52\u8fd8\u65f6\u95f4", (Object)"actualBackDate"));
                        continue block42;
                    }
                    case "borrowEnabledMark": {
                        entitys.add(new ExcelExportEntity("\u5370\u7ae0\u72b6\u6001", (Object)"borrowEnabledMark"));
                        continue block42;
                    }
                    case "enabledMark": {
                        entitys.add(new ExcelExportEntity("\u5ba1\u6279\u72b6\u6001", (Object)"enabledMark"));
                        continue block42;
                    }
                }
            }
        }
        ExportParams exportParams = new ExportParams(null, "\u8868\u5355\u4fe1\u606f");
        exportParams.setType(ExcelType.XSSF);
        try {
            HSSFWorkbook workbook = new HSSFWorkbook();
            try {
                if (entitys.size() > 0) {
                    workbook = ExcelExportUtil.exportExcel((ExportParams)exportParams, entitys, list);
                }
                String name = "\u8868\u5355\u4fe1\u606f" + DateUtil.dateNow((String)"yyyyMMdd") + "_" + RandomUtil.uuId() + ".xlsx";
                String fileName = this.configValueUtil.getTemporaryFilePath() + name;
                FileOutputStream output = new FileOutputStream(XSSEscape.escapePath((String)fileName));
                try {
                    workbook.write((OutputStream)output);
                    UploadUtil.uploadFile((String)this.configValueUtil.getFileType(), (String)fileName, (String)"temporary", (String)name);
                    vo.setName(name);
                    vo.setUrl(UploaderUtil.uploaderFile((String)(userInfo.getId() + "#" + name + "#Temporary")));
                }
                finally {
                    if (Collections.singletonList(output).get(0) != null) {
                        output.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(workbook).get(0) != null) {
                    workbook.close();
                }
            }
        }
        catch (Exception e) {
            log.error("\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:{}", (Object)e.getMessage());
            e.printStackTrace();
        }
        return vo;
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<MjOaCdBorrowInfoVO> info(@PathVariable(value="id") String id) {
        MjOaCdBorrowEntity entity = this.mjOaCdBorrowService.getInfo(id);
        MjOaCdBorrowInfoVO vo = (MjOaCdBorrowInfoVO)JsonUtil.getJsonToBean((Object)entity, MjOaCdBorrowInfoVO.class);
        return ActionResult.success((Object)vo);
    }

    @PutMapping(value={"/{id}"})
    @Transactional
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid Map<String, Object> upData) throws DataException, WorkFlowException {
        MjOaCdBorrowUpForm mjOaCdBorrowUpForm = (MjOaCdBorrowUpForm)JsonUtil.getJsonToBean(upData, MjOaCdBorrowUpForm.class);
        String visualId = "606543996205952005";
        UserInfo userInfo = this.userProvider.get();
        MjOaCdBorrowEntity entity = this.mjOaCdBorrowService.getInfo(id);
        if (entity != null) {
            MjOaCdBorrowEntity subentity = (MjOaCdBorrowEntity)JsonUtil.getJsonToBean((Object)mjOaCdBorrowUpForm, MjOaCdBorrowEntity.class);
            subentity.setPostName(this.baseDataUtil.posSelectValue(subentity.getPostId()));
            subentity.setCreatorUserName(this.baseDataUtil.userSelectValue(subentity.getCreatorUserId()));
            subentity.setDeptName(this.baseDataUtil.posSelectValue(subentity.getDeptId()));
            subentity.setSealTypeName(this.baseDataUtil.getDictName(entity.getSealType(), "MjSealBorrow"));
            subentity.setApplyCompanyName(this.oaSealCompanyService.getInfo(subentity.getApplyCompany()).getCompanyName());
            subentity.setSealBaseName(this.baseDataUtil.getDictName(subentity.getSealBase(), "sealBaseOptions"));
            this.mjOaCdBorrowService.update(id, subentity);
            FlowUtil.saveOrSubmit((String)mjOaCdBorrowUpForm.getTaskId(), (String)visualId, (String)mjOaCdBorrowUpForm.getTemplateId(), (String)id, (Object)mjOaCdBorrowUpForm, (Integer)mjOaCdBorrowUpForm.getStatus(), (String)mjOaCdBorrowUpForm.getApplyTitle());
            return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
        }
        return ActionResult.fail((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
    }

    @DeleteMapping(value={"/{id}"})
    @Transactional
    public ActionResult delete(@PathVariable(value="id") String id) {
        MjOaCdBorrowEntity entity = this.mjOaCdBorrowService.getInfo(id);
        if (entity != null) {
            FlowTaskEntity taskEntity = FlowUtil.getFlowTaskSubmited((String)id, (SFunction[])new SFunction[]{FlowTaskEntity::getId, FlowTaskEntity::getStatus});
            if (taskEntity != null) {
                try {
                    FlowUtil.delete((String)id);
                }
                catch (WorkFlowException e) {
                    e.printStackTrace();
                }
            }
            this.mjOaCdBorrowService.delete(entity);
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }

    @PostMapping(value={"/outBorrowEnabledMark/{code}/{id}"})
    @Transactional
    public ActionResult outBorrowEnabledMark(@PathVariable(value="id") String id, @PathVariable(value="code") String code) {
        if (StringUtils.isNotEmpty((String)id)) {
            if (StringUtils.isNotEmpty((String)code)) {
                MjOaCdBorrowEntity entity = this.mjOaCdBorrowService.getInfo(id);
                entity.setBorrowEnabledMark(code);
                entity.setBackUserId(this.userProvider.get().getUserId());
                entity.setActualBorrowDate(DateUtil.getNowDate());
                this.mjOaCdBorrowService.updateById(entity);
                return ActionResult.success((String)"\u5916\u501f\u66f4\u65b0\u6210\u529f");
            }
            return ActionResult.success((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        return ActionResult.success((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u8054\u7cfb\u7ba1\u7406\u5458");
    }

    @PostMapping(value={"/inBorrowEnabledMark/{code}/{id}"})
    @Transactional
    public ActionResult inBorrowEnabledMark(@PathVariable(value="id") String id, @PathVariable(value="code") String code) {
        if (StringUtils.isNotEmpty((String)id)) {
            if (StringUtils.isNotEmpty((String)code)) {
                MjOaCdBorrowEntity entity = this.mjOaCdBorrowService.getInfo(id);
                entity.setBorrowEnabledMark(code);
                entity.setBackUserId(this.userProvider.get().getUserId());
                entity.setActualBackDate(DateUtil.getNowDate());
                this.mjOaCdBorrowService.updateById(entity);
                return ActionResult.success((String)"\u5f52\u8fd8\u66f4\u65b0\u6210\u529f");
            }
            return ActionResult.success((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        return ActionResult.success((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u8054\u7cfb\u7ba1\u7406\u5458");
    }
}

