/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.oa.controller;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.config.ConfigValueUtil;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UserProvider;
import com.bringspring.contract.entity.RkContractProjectEntity;
import com.bringspring.contract.service.RkContractProjectService;
import com.bringspring.contract.utils.AttachmentTypeEnum;
import com.bringspring.oa.annotation.OaReminderEnum;
import com.bringspring.oa.entity.OaAttachmentEntity;
import com.bringspring.oa.entity.OaProjectAuthorizationEntity;
import com.bringspring.oa.model.oaProjectAuthorization.OaProjectAuthorizationCrForm;
import com.bringspring.oa.model.oaProjectAuthorization.OaProjectAuthorizationListVO;
import com.bringspring.oa.model.oaProjectAuthorization.OaProjectAuthorizationPagination;
import com.bringspring.oa.service.OaAttachmentService;
import com.bringspring.oa.service.OaProjectAuthorizationService;
import com.bringspring.system.base.exception.WorkFlowException;
import com.bringspring.system.permission.util.BaseDataUtil;
import com.bringspring.workflow.engine.util.FlowUtil;
import io.swagger.annotations.Api;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u9879\u76ee\u6388\u6743\u4fe1\u606f"}, value="oa")
@RequestMapping(value={"/api/contract/RkProjectAuthorization"})
public class OAProjectAuthorizationController {
    private static final Logger log = LoggerFactory.getLogger(OAProjectAuthorizationController.class);
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private ConfigValueUtil configValueUtil;
    @Autowired
    private OaAttachmentService oaAttachmentService;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private OaProjectAuthorizationService oaProjectAuthorizationService;
    @Autowired
    private RkContractProjectService rkContractProjectService;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody OaProjectAuthorizationPagination oaProjectAuthorizationPagination) throws IOException {
        List<OaProjectAuthorizationEntity> list = this.oaProjectAuthorizationService.getList(oaProjectAuthorizationPagination);
        List<OaProjectAuthorizationListVO> listVO = JsonUtil.getJsonToList(list, OaProjectAuthorizationListVO.class);
        listVO = this.oaProjectAuthorizationService.setAllNameById(listVO);
        PageListVO vo = new PageListVO();
        vo.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)oaProjectAuthorizationPagination), PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success((Object)vo);
    }

    @PostMapping(value={"/selectAuthorizationByDate"})
    public ActionResult selectAuthorizationByDate(@RequestBody OaProjectAuthorizationPagination oaProjectAuthorizationPagination) throws IOException {
        List<OaProjectAuthorizationEntity> list = this.oaProjectAuthorizationService.selectAuthorizationByDate(oaProjectAuthorizationPagination);
        return ActionResult.success(list);
    }

    @PostMapping(value={"countByAuthorizationResult"})
    public ActionResult countByAuthorizationResult(@RequestBody OaProjectAuthorizationPagination oaProjectAuthorizationPagination) {
        List<Map<String, Object>> maps = this.oaProjectAuthorizationService.countByAuthorizationResult(oaProjectAuthorizationPagination);
        return ActionResult.success(maps);
    }

    @PostMapping
    @DSTransactional
    public ActionResult create(@RequestBody @Valid OaProjectAuthorizationCrForm oaProjectAuthorizationCrForm) throws DataException, WorkFlowException {
        RkContractProjectEntity project;
        String flowEngineId = "581480104639611141";
        String mainId = RandomUtil.uuId();
        oaProjectAuthorizationCrForm.setCreatorTime(DateUtil.getNow());
        OaProjectAuthorizationEntity entity = (OaProjectAuthorizationEntity)JsonUtil.getJsonToBean((Object)((Object)oaProjectAuthorizationCrForm), OaProjectAuthorizationEntity.class);
        entity = this.oaProjectAuthorizationService.getOaProjectAuthorizationEntityInfo(entity);
        entity.setId(mainId);
        this.oaProjectAuthorizationService.save(entity);
        if (CollectionUtil.isNotEmpty(oaProjectAuthorizationCrForm.getAttachmentList())) {
            List oaAttachmentEntityList = JsonUtil.getJsonToList(oaProjectAuthorizationCrForm.getAttachmentList(), OaAttachmentEntity.class);
            for (OaAttachmentEntity entitys : oaAttachmentEntityList) {
                entitys.setId(RandomUtil.uuId());
                entitys.setObjId(entity.getId());
                entitys.setFileType(AttachmentTypeEnum.PROJECT_AUTHORIZATION_TYPE.getType());
                this.oaAttachmentService.save(entitys);
            }
        }
        if (StrUtil.isNotBlank((CharSequence)oaProjectAuthorizationCrForm.getFlowId())) {
            flowEngineId = oaProjectAuthorizationCrForm.getFlowId();
        }
        if (StringUtils.isNotEmpty((String)entity.getProjectId()) && ObjectUtils.isNotEmpty((Object)(project = (RkContractProjectEntity)this.rkContractProjectService.getById((Serializable)((Object)entity.getProjectId()))))) {
            project.setAuthorizationApplyId(entity.getId());
            this.rkContractProjectService.updateById((Object)project);
        }
        FlowUtil.saveOrSubmit((String)oaProjectAuthorizationCrForm.getTaskId(), (String)flowEngineId, (String)oaProjectAuthorizationCrForm.getTemplateId(), (String)mainId, (Object)((Object)oaProjectAuthorizationCrForm), (Integer)oaProjectAuthorizationCrForm.getStatus(), (String)entity.getProjectName());
        if (oaProjectAuthorizationCrForm.getStatus() == 0) {
            return ActionResult.success((String)OaReminderEnum.TS.getType());
        }
        return ActionResult.success((String)OaReminderEnum.SUCCEED.getType());
    }

    @PutMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid OaProjectAuthorizationCrForm oaProjectAuthorizationCrForm) throws DataException, WorkFlowException {
        OaProjectAuthorizationEntity entity = this.oaProjectAuthorizationService.getInfo(id);
        if (entity != null) {
            RkContractProjectEntity project;
            OaProjectAuthorizationEntity subentity = (OaProjectAuthorizationEntity)JsonUtil.getJsonToBean((Object)((Object)oaProjectAuthorizationCrForm), OaProjectAuthorizationEntity.class);
            UserInfo userInfo = this.userProvider.get();
            subentity.setLastModifyTime(new Date());
            subentity.setLastModifyUserId(userInfo.getUserId());
            this.oaProjectAuthorizationService.update(id, subentity);
            String flowEngineId = "581480104639611141";
            if (StrUtil.isNotBlank((CharSequence)oaProjectAuthorizationCrForm.getFlowId())) {
                flowEngineId = oaProjectAuthorizationCrForm.getFlowId();
            }
            this.oaAttachmentService.deleteByObjId(subentity.getId());
            if (CollectionUtil.isNotEmpty(oaProjectAuthorizationCrForm.getAttachmentList())) {
                List oaAttachmentEntityList = JsonUtil.getJsonToList(oaProjectAuthorizationCrForm.getAttachmentList(), OaAttachmentEntity.class);
                for (OaAttachmentEntity entitys : oaAttachmentEntityList) {
                    entitys.setId(RandomUtil.uuId());
                    entitys.setObjId(entity.getId());
                    entitys.setFileType(AttachmentTypeEnum.PROJECT_AUTHORIZATION_TYPE.getType());
                    this.oaAttachmentService.save(entitys);
                }
            }
            if (StringUtils.isNotEmpty((String)subentity.getProjectId()) && ObjectUtils.isNotEmpty((Object)(project = (RkContractProjectEntity)this.rkContractProjectService.getById((Serializable)((Object)subentity.getProjectId()))))) {
                project.setAuthorizationApplyId(entity.getId());
                this.rkContractProjectService.updateById((Object)project);
            }
            FlowUtil.saveOrSubmit((String)oaProjectAuthorizationCrForm.getTaskId(), (String)flowEngineId, (String)oaProjectAuthorizationCrForm.getTemplateId(), (String)entity.getId(), (Object)((Object)oaProjectAuthorizationCrForm), (Integer)oaProjectAuthorizationCrForm.getStatus(), (String)entity.getProjectName());
            if (oaProjectAuthorizationCrForm.getStatus() == 0) {
                return ActionResult.success((String)OaReminderEnum.TS.getType());
            }
            return ActionResult.success((String)OaReminderEnum.SUCCEED.getType());
        }
        return ActionResult.fail((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<OaProjectAuthorizationListVO> info(@PathVariable(value="id") String id) {
        OaProjectAuthorizationListVO vo = this.oaProjectAuthorizationService.getOaProjectAuthorizationListVOInfoById(id);
        if (null != vo) {
            List<OaAttachmentEntity> listByProjectTypeId = this.oaAttachmentService.listByBussinessObjId(id);
            ArrayList<OaAttachmentEntity> infoVOArrayList = new ArrayList<OaAttachmentEntity>();
            listByProjectTypeId.stream().forEach(attachmentEntity -> {
                OaAttachmentEntity jsonToBean = (OaAttachmentEntity)JsonUtil.getJsonToBean((Object)attachmentEntity, OaAttachmentEntity.class);
                infoVOArrayList.add(jsonToBean);
            });
            if (StrUtil.isNotEmpty((CharSequence)vo.getCompanyId())) {
                vo.setCompanyName(this.baseDataUtil.comSelectValues(vo.getCompanyId()));
            }
            vo.setAttachmentList(infoVOArrayList);
        } else {
            vo = new OaProjectAuthorizationListVO();
            vo.setAttachmentList(new ArrayList<OaAttachmentEntity>());
        }
        return ActionResult.success((Object)vo);
    }

    @GetMapping(value={"projectInfo/{projectId}"})
    public ActionResult<OaProjectAuthorizationListVO> infoProject(@PathVariable(value="projectId") String projectId) {
        OaProjectAuthorizationListVO vo = this.oaProjectAuthorizationService.getOaProjectAuthorizationListVOInfoByProjectId(projectId);
        if (StrUtil.isNotEmpty((CharSequence)vo.getCompanyId())) {
            vo.setCompanyName(this.baseDataUtil.comSelectValues(vo.getCompanyId()));
        }
        return ActionResult.success((Object)vo);
    }

    @DeleteMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult delete(@PathVariable(value="id") String id) {
        OaProjectAuthorizationEntity entity = this.oaProjectAuthorizationService.getInfo(id);
        this.oaProjectAuthorizationService.delete(entity);
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }
}

