/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.oa.controller;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.extra.pinyin.PinyinUtil;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UserProvider;
import com.bringspring.contract.service.RkAgentService;
import com.bringspring.crm.entity.CrmProductCategoryEntity;
import com.bringspring.crm.service.CrmProductCategoryService;
import com.bringspring.oa.annotation.OaReminderEnum;
import com.bringspring.oa.entity.OaAgentPreEntity;
import com.bringspring.oa.model.oaagent.OaAgentInfoVO;
import com.bringspring.oa.model.oaagent.OaAgentListVO;
import com.bringspring.oa.model.oaagentpre.OaAgentPreCrForm;
import com.bringspring.oa.model.oaagentpre.OaAgentPrePagination;
import com.bringspring.oa.model.oaagentpre.OaAgentPreUpForm;
import com.bringspring.oa.service.OaAgentPreService;
import com.bringspring.system.base.exception.WorkFlowException;
import com.bringspring.system.permission.util.BaseDataUtil;
import com.bringspring.workflow.engine.entity.FlowTaskEntity;
import com.bringspring.workflow.engine.util.FlowUtil;
import io.swagger.annotations.Api;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u51c6\u666e\u901a\u5408\u4f5c\u5546\u5e93"}, value="OaAgentPre")
@RequestMapping(value={"/api/oa/OaAgentPre"})
public class OaAgentPreController {
    private static final Logger log = LoggerFactory.getLogger(OaAgentPreController.class);
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private OaAgentPreService oaAgentPreService;
    @Autowired
    private RkAgentService rkAgentService;
    @Autowired
    private CrmProductCategoryService crmProductCategoryService;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody OaAgentPrePagination oaAgentPrePagination) throws IOException {
        List<OaAgentPreEntity> list = this.oaAgentPreService.getList(oaAgentPrePagination);
        for (OaAgentPreEntity oaAgentPreEntity : list) {
            oaAgentPreEntity.setType(this.baseDataUtil.getDictName(oaAgentPreEntity.getType(), "agentType"));
            oaAgentPreEntity.setEnterpriseScale(this.baseDataUtil.getDictName(oaAgentPreEntity.getEnterpriseScale(), "enterpriseSize"));
            oaAgentPreEntity.setFilePath(this.baseDataUtil.getFileNameInJson(oaAgentPreEntity.getFilePath()));
        }
        List listVO = JsonUtil.getJsonToList(list, OaAgentListVO.class);
        for (OaAgentListVO vo : listVO) {
            FlowTaskEntity flowTaskEntity = FlowUtil.getFlowTaskSubmited((String)vo.getId(), (SFunction[])new SFunction[]{FlowTaskEntity::getStatus});
            if (flowTaskEntity != null) {
                vo.setFlowState(flowTaskEntity.getStatus());
                continue;
            }
            vo.setFlowState(null);
        }
        PageListVO pageListVO = new PageListVO();
        pageListVO.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)oaAgentPrePagination), PaginationVO.class);
        pageListVO.setPagination(page);
        return ActionResult.success((Object)pageListVO);
    }

    @PostMapping
    @DSTransactional
    public ActionResult create(@RequestBody @Valid Map<String, Object> crData) throws DataException, WorkFlowException {
        OaAgentPreCrForm oaAgentCrForm = (OaAgentPreCrForm)((Object)JsonUtil.getJsonToBean(crData, OaAgentPreCrForm.class));
        UserInfo userInfo = this.userProvider.get();
        String flowEngineId = oaAgentCrForm.getFlowId();
        String mainId = RandomUtil.uuId();
        if (this.rkAgentService.checkExistNameAndCompanyId(oaAgentCrForm.getName(), userInfo.getOrganizeId())) {
            return ActionResult.fail((String)"\u4f01\u4e1a\u5728\u5408\u4f5c\u4f19\u4f34\u5e93\u4e2d\u5df2\u5b58\u5728\uff0c\u8bf7\u786e\u8ba4");
        }
        if (this.oaAgentPreService.checkExistNameAndCompanyId(oaAgentCrForm.getName(), userInfo.getOrganizeId())) {
            return ActionResult.fail((String)"\u5728\u51c6\u666e\u901a\u5408\u4f5c\u5546\u5e93\u4e2d\u5df2\u5b58\u5728\uff0c\u8bf7\u786e\u8ba4");
        }
        if (StringUtils.isNotEmpty((String)oaAgentCrForm.getAgentProduct())) {
            oaAgentCrForm.setAgentProduct(oaAgentCrForm.getAgentProduct().replaceAll("\"", "").replaceAll("]", "").replace("[", ""));
        }
        if (!ObjectUtil.isEmpty((Object)oaAgentCrForm.getName())) {
            oaAgentCrForm.setPinyin(PinyinUtil.getFirstLetter((String)oaAgentCrForm.getName(), (String)"").toUpperCase());
        }
        OaAgentPreEntity entity = (OaAgentPreEntity)JsonUtil.getJsonToBean((Object)((Object)oaAgentCrForm), OaAgentPreEntity.class);
        entity.setEnabledMark(oaAgentCrForm.getStatus());
        entity.setId(mainId);
        this.oaAgentPreService.save(entity);
        FlowUtil.saveOrSubmit((String)oaAgentCrForm.getTaskId(), (String)flowEngineId, (String)oaAgentCrForm.getTemplateId(), (String)mainId, (Object)((Object)oaAgentCrForm), (Integer)oaAgentCrForm.getStatus(), (String)oaAgentCrForm.getName());
        if (oaAgentCrForm.getStatus() == 0) {
            return ActionResult.success((String)OaReminderEnum.TS.getType());
        }
        return ActionResult.success((String)OaReminderEnum.SUCCEED.getType());
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<OaAgentInfoVO> info(@PathVariable(value="id") String id) {
        OaAgentPreEntity entity = this.oaAgentPreService.getInfoHandleRegionDate(id);
        OaAgentInfoVO vo = (OaAgentInfoVO)JsonUtil.getJsonToBean((Object)entity, OaAgentInfoVO.class);
        if (!StrUtil.isBlank((CharSequence)vo.getAgentProduct())) {
            List ids = JsonUtil.getJsonToList((String)vo.getAgentProduct(), String.class);
            List categoryList = this.crmProductCategoryService.getInfoByIdList(ids);
            vo.setAgentProductName(categoryList.stream().map(CrmProductCategoryEntity::getName).collect(Collectors.joining(",")));
        }
        return ActionResult.success((Object)vo);
    }

    @PutMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid Map<String, Object> upData) throws DataException, WorkFlowException {
        OaAgentPreUpForm oaAgentUpForm = (OaAgentPreUpForm)((Object)JsonUtil.getJsonToBean(upData, OaAgentPreUpForm.class));
        if (StringUtils.isNotEmpty((String)oaAgentUpForm.getAgentProduct())) {
            oaAgentUpForm.setAgentProduct(oaAgentUpForm.getAgentProduct().replaceAll("\"", "").replaceAll("]", "").replace("[", ""));
        }
        String flowEngineId = oaAgentUpForm.getFlowId();
        UserInfo userInfo = this.userProvider.get();
        OaAgentPreEntity entity = this.oaAgentPreService.getInfo(id);
        if (entity != null) {
            if (this.rkAgentService.checkExistNameAndCompanyId(oaAgentUpForm.getName(), userInfo.getOrganizeId(), id)) {
                return ActionResult.fail((String)"\u5df2\u5b58\u5728\uff0c\u8bf7\u8054\u7cfb\u6e20\u9053\u5c0f\u7ec4");
            }
            if (this.oaAgentPreService.checkExistNameAndCompanyId(oaAgentUpForm.getName(), userInfo.getOrganizeId())) {
                return ActionResult.fail((String)"\u5728\u51c6\u666e\u901a\u5408\u4f5c\u5546\u5e93\u4e2d\u5df2\u5b58\u5728\uff0c\u8bf7\u786e\u8ba4");
            }
            OaAgentPreEntity subentity = (OaAgentPreEntity)JsonUtil.getJsonToBean((Object)((Object)oaAgentUpForm), OaAgentPreEntity.class);
            subentity.setEnabledMark(oaAgentUpForm.getStatus());
            this.oaAgentPreService.update(id, subentity);
            FlowUtil.saveOrSubmit((String)oaAgentUpForm.getTaskId(), (String)flowEngineId, (String)oaAgentUpForm.getTemplateId(), (String)id, (Object)((Object)oaAgentUpForm), (Integer)oaAgentUpForm.getStatus(), (String)oaAgentUpForm.getName());
            if (oaAgentUpForm.getStatus() == 0) {
                return ActionResult.success((String)OaReminderEnum.TS.getType());
            }
            return ActionResult.success((String)OaReminderEnum.SUCCEED.getType());
        }
        return ActionResult.fail((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
    }

    @DeleteMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult delete(@PathVariable(value="id") String id) {
        OaAgentPreEntity entity = this.oaAgentPreService.getInfo(id);
        if (entity != null) {
            FlowTaskEntity taskEntity = FlowUtil.getFlowTaskSubmited((String)id, (SFunction[])new SFunction[]{FlowTaskEntity::getId, FlowTaskEntity::getStatus});
            if (taskEntity != null) {
                try {
                    FlowUtil.delete((String)id);
                }
                catch (WorkFlowException e) {
                    e.printStackTrace();
                }
            }
            this.oaAgentPreService.delete(entity);
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }
}

