/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.oa.controller;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.extra.pinyin.PinyinUtil;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UserProvider;
import com.bringspring.contract.service.RkAgentService;
import com.bringspring.crm.entity.CrmProductCategoryEntity;
import com.bringspring.crm.service.CrmProductCategoryService;
import com.bringspring.oa.annotation.OaReminderEnum;
import com.bringspring.oa.entity.OaAgentUpgradeEntity;
import com.bringspring.oa.model.oaagent.OaAgentListVO;
import com.bringspring.oa.model.oaagentupgrade.OaAgentUpgradeCrForm;
import com.bringspring.oa.model.oaagentupgrade.OaAgentUpgradeInfoVO;
import com.bringspring.oa.model.oaagentupgrade.OaAgentUpgradePagination;
import com.bringspring.oa.model.oaagentupgrade.OaAgentUpgradeUpForm;
import com.bringspring.oa.service.OaAgentUpgradeService;
import com.bringspring.system.base.exception.WorkFlowException;
import com.bringspring.system.permission.util.BaseDataUtil;
import com.bringspring.workflow.engine.entity.FlowTaskEntity;
import com.bringspring.workflow.engine.util.FlowUtil;
import io.swagger.annotations.Api;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u5347\u7ea7\u51c6\u666e\u901a\u5408\u4f5c\u5546\u5e93"}, value="OaAgentUpgrade")
@RequestMapping(value={"/api/oa/OaAgentUpgrade"})
public class OaAgentUpgradeController {
    private static final Logger log = LoggerFactory.getLogger(OaAgentUpgradeController.class);
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private OaAgentUpgradeService oaAgentUpgradeService;
    @Autowired
    private RkAgentService rkAgentService;
    @Autowired
    private CrmProductCategoryService crmProductCategoryService;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody OaAgentUpgradePagination oaAgentUpgradePagination) throws IOException {
        List<OaAgentUpgradeEntity> list = this.oaAgentUpgradeService.getList(oaAgentUpgradePagination);
        for (OaAgentUpgradeEntity oaAgentUpgradeEntity : list) {
            oaAgentUpgradeEntity.setType(this.baseDataUtil.getDictName(oaAgentUpgradeEntity.getType(), "agentType"));
            oaAgentUpgradeEntity.setEnterpriseScale(this.baseDataUtil.getDictName(oaAgentUpgradeEntity.getEnterpriseScale(), "enterpriseSize"));
            oaAgentUpgradeEntity.setFilePath(this.baseDataUtil.getFileNameInJson(oaAgentUpgradeEntity.getFilePath()));
        }
        List listVO = JsonUtil.getJsonToList(list, OaAgentListVO.class);
        for (OaAgentListVO vo : listVO) {
            FlowTaskEntity flowTaskEntity = FlowUtil.getFlowTaskSubmited((String)vo.getId(), (SFunction[])new SFunction[]{FlowTaskEntity::getStatus});
            if (flowTaskEntity != null) {
                vo.setFlowState(flowTaskEntity.getStatus());
                continue;
            }
            vo.setFlowState(null);
        }
        PageListVO pageListVO = new PageListVO();
        pageListVO.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)oaAgentUpgradePagination), PaginationVO.class);
        pageListVO.setPagination(page);
        return ActionResult.success((Object)pageListVO);
    }

    @PostMapping
    @DSTransactional
    public ActionResult create(@RequestBody @Valid Map<String, Object> crData) throws DataException, WorkFlowException {
        OaAgentUpgradeCrForm oaAgentCrForm = (OaAgentUpgradeCrForm)((Object)JsonUtil.getJsonToBean(crData, OaAgentUpgradeCrForm.class));
        UserInfo userInfo = this.userProvider.get();
        String flowEngineId = oaAgentCrForm.getFlowId();
        String mainId = RandomUtil.uuId();
        if (StringUtils.isNotEmpty((String)oaAgentCrForm.getAgentProduct())) {
            oaAgentCrForm.setAgentProduct(oaAgentCrForm.getAgentProduct().replaceAll("\"", "").replaceAll("]", "").replace("[", ""));
        }
        if (!ObjectUtil.isEmpty((Object)oaAgentCrForm.getName())) {
            oaAgentCrForm.setPinyin(PinyinUtil.getFirstLetter((String)oaAgentCrForm.getName(), (String)"").toUpperCase());
        }
        OaAgentUpgradeEntity entity = (OaAgentUpgradeEntity)JsonUtil.getJsonToBean((Object)((Object)oaAgentCrForm), OaAgentUpgradeEntity.class);
        entity.setEnabledMark(oaAgentCrForm.getStatus());
        entity.setId(mainId);
        this.oaAgentUpgradeService.save(entity);
        FlowUtil.saveOrSubmit((String)oaAgentCrForm.getTaskId(), (String)flowEngineId, (String)oaAgentCrForm.getTemplateId(), (String)mainId, (Object)((Object)oaAgentCrForm), (Integer)oaAgentCrForm.getStatus(), (String)oaAgentCrForm.getName());
        if (oaAgentCrForm.getStatus() == 0) {
            return ActionResult.success((String)OaReminderEnum.TS.getType());
        }
        return ActionResult.success((String)OaReminderEnum.SUCCEED.getType());
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<OaAgentUpgradeInfoVO> info(@PathVariable(value="id") String id) {
        OaAgentUpgradeEntity entity = this.oaAgentUpgradeService.getInfoHandleRegionDate(id);
        OaAgentUpgradeInfoVO vo = (OaAgentUpgradeInfoVO)JsonUtil.getJsonToBean((Object)entity, OaAgentUpgradeInfoVO.class);
        if (!StrUtil.isBlank((CharSequence)vo.getAgentProduct())) {
            List ids = JsonUtil.getJsonToList((String)vo.getAgentProduct(), String.class);
            List categoryList = this.crmProductCategoryService.getInfoByIdList(ids);
            vo.setAgentProductName(categoryList.stream().map(CrmProductCategoryEntity::getName).collect(Collectors.joining(",")));
        }
        return ActionResult.success((Object)vo);
    }

    @PutMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid Map<String, Object> upData) throws DataException, WorkFlowException {
        OaAgentUpgradeUpForm oaAgentUpForm = (OaAgentUpgradeUpForm)((Object)JsonUtil.getJsonToBean(upData, OaAgentUpgradeUpForm.class));
        if (StringUtils.isNotEmpty((String)oaAgentUpForm.getAgentProduct())) {
            oaAgentUpForm.setAgentProduct(oaAgentUpForm.getAgentProduct().replaceAll("\"", "").replaceAll("]", "").replace("[", ""));
        }
        String flowEngineId = oaAgentUpForm.getFlowId();
        UserInfo userInfo = this.userProvider.get();
        OaAgentUpgradeEntity entity = this.oaAgentUpgradeService.getInfo(id);
        if (entity != null) {
            OaAgentUpgradeEntity subentity = (OaAgentUpgradeEntity)JsonUtil.getJsonToBean((Object)((Object)oaAgentUpForm), OaAgentUpgradeEntity.class);
            subentity.setEnabledMark(oaAgentUpForm.getStatus());
            this.oaAgentUpgradeService.update(id, subentity);
            FlowUtil.saveOrSubmit((String)oaAgentUpForm.getTaskId(), (String)flowEngineId, (String)oaAgentUpForm.getTemplateId(), (String)id, (Object)((Object)oaAgentUpForm), (Integer)oaAgentUpForm.getStatus(), (String)oaAgentUpForm.getName());
            if (oaAgentUpForm.getStatus() == 0) {
                return ActionResult.success((String)OaReminderEnum.TS.getType());
            }
            return ActionResult.success((String)OaReminderEnum.SUCCEED.getType());
        }
        return ActionResult.fail((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
    }

    @DeleteMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult delete(@PathVariable(value="id") String id) {
        OaAgentUpgradeEntity entity = this.oaAgentUpgradeService.getInfo(id);
        if (entity != null) {
            FlowTaskEntity taskEntity = FlowUtil.getFlowTaskSubmited((String)id, (SFunction[])new SFunction[]{FlowTaskEntity::getId, FlowTaskEntity::getStatus});
            if (taskEntity != null) {
                try {
                    FlowUtil.delete((String)id);
                }
                catch (WorkFlowException e) {
                    e.printStackTrace();
                }
            }
            this.oaAgentUpgradeService.delete(entity);
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }
}

